/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.common;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Project;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.common.FileCache;
import java.io.InputStream;
import java.util.TreeMap;

public class InstanceContext {
    private Odps odps;
    private ExecutionContext session;
    private String errorMsg;
    private Project project;
    private Instance instance;
    private String task;
    private TreeMap<String, String> logDir = new TreeMap();
    private static final int MAX_FILES = 42;
    private static final FileCache fileCache = new FileCache(42);

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String msg) {
        this.errorMsg = msg;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setProjectByName(String projName) throws OdpsException {
        if (this.project == null || !this.project.getName().toLowerCase().equals(projName.toLowerCase())) {
            this.project = this.odps.projects().get(projName);
            this.reset(null);
        }
    }

    public Instance getInstance() {
        return this.instance;
    }

    public void setInstance(Instance instance) {
        this.reset(instance);
    }

    public void setInstanceById(String id) {
        id = id.toLowerCase();
        if (this.instance == null || !id.equals(this.instance.getId())) {
            this.reset(this.odps.instances().get(id));
        }
    }

    public void reset(Instance instance) {
        if (instance != this.instance) {
            this.logDir.clear();
            this.task = null;
        }
        this.instance = instance;
    }

    public ExecutionContext getSession() {
        return this.session;
    }

    public void setSession(ExecutionContext execCtx) {
        this.session = execCtx;
    }

    public Odps getConn() {
        return this.odps;
    }

    public void setConn(Odps odps) {
        this.odps = odps;
    }

    public TreeMap<String, String> getLogDir() {
        return this.logDir;
    }

    public void setLogDir(TreeMap<String, String> logDir) {
        this.logDir = logDir;
    }

    public String getTask() {
        return this.task;
    }

    public void setTask(String task) {
        this.task = task;
    }

    public InputStream getTaskDetails(Instance inst, String taskName) throws ODPSConsoleException {
        return fileCache.get(inst, taskName);
    }
}

