/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.apache.hc.core5.http.impl.nio;

import com.aliyun.apache.hc.core5.annotation.Contract;
import com.aliyun.apache.hc.core5.annotation.ThreadingBehavior;
import com.aliyun.apache.hc.core5.http.HttpResponse;
import com.aliyun.apache.hc.core5.http.HttpResponseFactory;
import com.aliyun.apache.hc.core5.http.ReasonPhraseCatalog;
import com.aliyun.apache.hc.core5.http.impl.EnglishReasonPhraseCatalog;
import com.aliyun.apache.hc.core5.http.message.BasicHttpResponse;
import com.aliyun.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseFactory
implements HttpResponseFactory<HttpResponse> {
    public static final DefaultHttpResponseFactory INSTANCE = new DefaultHttpResponseFactory();
    private final ReasonPhraseCatalog reasonCatalog;

    public DefaultHttpResponseFactory(ReasonPhraseCatalog catalog) {
        this.reasonCatalog = Args.notNull(catalog, "Reason phrase catalog");
    }

    public DefaultHttpResponseFactory() {
        this(EnglishReasonPhraseCatalog.INSTANCE);
    }

    @Override
    public HttpResponse newHttpResponse(int status, String reasonPhrase) {
        return new BasicHttpResponse(status, reasonPhrase);
    }

    @Override
    public HttpResponse newHttpResponse(int status) {
        return new BasicHttpResponse(status, this.reasonCatalog, null);
    }
}

