/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.request.cupid;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.commons.transport.Request;
import com.aliyun.odps.request.cupid.CupidRequestType;
import com.aliyun.odps.rest.JAXBUtils;
import com.aliyun.odps.rest.ResourceBuilder;
import java.io.IOException;
import java.util.HashMap;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

public class CupidRequestProxy {
    private static final CupidRequestProxy INSTANCE = new CupidRequestProxy();

    public static CupidRequestProxy getInstance() {
        return INSTANCE;
    }

    private ResponseForRequest callOdpsWorker(String bodyXmlStr, String httpUriType, Odps odps, String lookupName) throws IOException {
        ResponseForRequest responseForRpc;
        HashMap<String, String> headers = new HashMap<String, String>();
        HashMap<String, String> params = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        params.put("type", httpUriType);
        StringBuilder sb = new StringBuilder();
        sb.append("/projects").append('/').append(ResourceBuilder.encodeObjectName((String)odps.getDefaultProject()));
        sb.append("/instances").append('/').append(ResourceBuilder.encodeObjectName((String)lookupName));
        sb.append("/rpccall");
        String resource = sb.toString();
        try {
            responseForRpc = (ResponseForRequest)odps.getRestClient().stringRequest(ResponseForRequest.class, resource, Request.Method.POST.name(), params, headers, bodyXmlStr);
        }
        catch (OdpsException e) {
            throw new IOException(e.getMessage(), e);
        }
        return responseForRpc;
    }

    public String cupidRequestRPC(String rpcData, Odps odps, String lookupName) throws IOException {
        return this.cupidRequestRPC(rpcData, odps, lookupName, CupidRequestType.REQUESTRPC);
    }

    public String cupidRequestRPC(String rpcData, Odps odps, String lookupName, String requestType) throws IOException {
        String bodyXml;
        CupidRequestRPC cupidRequestRPC = new CupidRequestRPC();
        cupidRequestRPC.requestType = requestType;
        cupidRequestRPC.data = rpcData;
        try {
            bodyXml = JAXBUtils.marshal((Object)cupidRequestRPC, CupidRequestRPC.class);
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
        ResponseForRequest response = this.callOdpsWorker(bodyXml, "cupid", odps, lookupName);
        return response.data;
    }

    @XmlRootElement(name="Item")
    static class ResponseForRequest {
        @XmlElement(name="Data")
        private String data;

        ResponseForRequest() {
        }
    }

    @XmlRootElement(name="CupidRequestRPC")
    static class CupidRequestRPC
    extends CupidRequestBase {
        @XmlElement(name="Data")
        private String data;

        CupidRequestRPC() {
        }
    }

    static class CupidRequestBase {
        @XmlElement(name="RequestType")
        protected String requestType;

        CupidRequestBase() {
        }
    }
}

