/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.table;

import java.io.Serializable;
import java.util.ArrayList;

public class TableInputInfo
implements Serializable {
    private static final long serialVersionUID = 7934303490785687617L;
    private String projectName;
    private String tableName;
    private String partSpec = null;
    private String[] columns;

    public String[] getColumns() {
        return this.columns;
    }

    public void setColumns(String[] columns) {
        this.columns = columns;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getPartSpec() {
        return this.partSpec;
    }

    public void setPartSpec(String partSpec) {
        this.partSpec = partSpec;
    }

    public TableInputInfo() {
        this.projectName = null;
        this.tableName = null;
        this.partSpec = null;
        this.columns = null;
    }

    public TableInputInfo(String projectName, String tableName, String[] columns) {
        this(projectName, tableName, columns, null);
    }

    public TableInputInfo(String projectName, String tableName, String[] columns, String partSpec) {
        this.projectName = projectName;
        this.tableName = tableName;
        this.columns = columns;
        this.partSpec = partSpec;
    }

    public static TableInputInfo[] generateTableInputInfos(String projectName, String tableName, String[] columns, String[] partSpecs) throws Exception {
        ArrayList<TableInputInfo> tableInputInfos = new ArrayList<TableInputInfo>();
        if (partSpecs.length == 0) {
            tableInputInfos.add(new TableInputInfo(projectName, tableName, columns, null));
        } else {
            for (String partSpec : partSpecs) {
                tableInputInfos.add(new TableInputInfo(projectName, tableName, columns, partSpec));
            }
        }
        return tableInputInfos.toArray(new TableInputInfo[tableInputInfos.size()]);
    }
}

