/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.requestcupid;

import apsara.odps.cupid.protocol.CupidTaskParamProtos;
import apsara.odps.cupid.protocol.VolumePathsCapProtos;
import apsara.odps.cupid.protocol.YarnClientProtos;
import com.aliyun.odps.Instance;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.cupid.CupidConf;
import com.aliyun.odps.cupid.CupidException;
import com.aliyun.odps.cupid.CupidSession;
import com.aliyun.odps.cupid.CupidUtil;
import com.aliyun.odps.cupid.com.google.protobuf.InvalidProtocolBufferException;
import com.aliyun.odps.cupid.requestcupid.CupidTaskRunningMode;
import com.aliyun.odps.cupid.requestcupid.SubmitJobUtil;
import com.aliyun.odps.cupid.util.TrackUrl;
import com.aliyun.odps.request.cupid.webproxy.PollCallWebProxy;
import com.github.rholder.retry.RetryException;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class YarnClientImplUtil {
    private static Logger logger = Logger.getLogger(YarnClientImplUtil.class);

    public static int getClusterTuboNum() {
        return 100;
    }

    public static int getRanDomAppId() {
        return new Random().nextInt(Integer.MAX_VALUE) % Integer.MAX_VALUE + 1;
    }

    public static YarnClientProtos.GetNewApplicationResponseProto getNewApplicationResponse() {
        YarnClientProtos.GetNewApplicationResponseProto.Builder getNewApplicationResponseProtoBuilder = YarnClientProtos.GetNewApplicationResponseProto.newBuilder();
        YarnClientProtos.ApplicationIdProto.Builder applicationIdProtoOrBuilder = YarnClientProtos.ApplicationIdProto.newBuilder();
        int appId = YarnClientImplUtil.getRanDomAppId();
        applicationIdProtoOrBuilder.setId(appId);
        applicationIdProtoOrBuilder.setClusterTimestamp(System.currentTimeMillis());
        getNewApplicationResponseProtoBuilder.setApplicationId(applicationIdProtoOrBuilder.build());
        YarnClientProtos.ResourceProto.Builder resourceBuilder = YarnClientProtos.ResourceProto.newBuilder();
        resourceBuilder.setMemory(96000);
        resourceBuilder.setVirtualCores(128);
        getNewApplicationResponseProtoBuilder.setMaximumCapability(resourceBuilder.build());
        logger.info((Object)("appId " + appId + "," + applicationIdProtoOrBuilder.getClusterTimestamp()));
        return getNewApplicationResponseProtoBuilder.build();
    }

    public static void initCupidSession(HashMap<String, String> cupidConfParam) {
        CupidConf conf = new CupidConf();
        for (Map.Entry<String, String> cupidConfParamItem : cupidConfParam.entrySet()) {
            conf.set(cupidConfParamItem.getKey(), cupidConfParamItem.getValue());
        }
        CupidSession.setConf(conf);
    }

    public static CupidTaskParamProtos.CupidTaskDetailResultParam pollAMStatus(Instance ins) throws InvalidProtocolBufferException, ExecutionException, RetryException, InterruptedException, CupidException {
        return CupidUtil.getResult(ins);
    }

    public static CupidTaskParamProtos.OdpsLocalResource setProjectForLocalResource(CupidTaskParamProtos.OdpsLocalResource odpsLocalResource) {
        return YarnClientImplUtil.setProjectForLocalResource(odpsLocalResource, null);
    }

    public static CupidTaskParamProtos.OdpsLocalResource setProjectForLocalResource(CupidTaskParamProtos.OdpsLocalResource odpsLocalResource, CupidSession overrideCupidSession) {
        CupidSession cupidSession = overrideCupidSession == null ? CupidSession.get() : overrideCupidSession;
        CupidTaskParamProtos.OdpsLocalResource.Builder odpsLocalResourceBuilder = CupidTaskParamProtos.OdpsLocalResource.newBuilder();
        CupidTaskParamProtos.OdpsLocalResourceItem.Builder odpsLocalResourceBuilderItemBuilder = CupidTaskParamProtos.OdpsLocalResourceItem.newBuilder();
        for (CupidTaskParamProtos.OdpsLocalResourceItem item : odpsLocalResource.getLocalresourceitemList()) {
            odpsLocalResourceBuilderItemBuilder.setProjectname(cupidSession.conf.get("odps.project.name"));
            odpsLocalResourceBuilderItemBuilder.setRelativefilepath(item.getRelativefilepath());
            odpsLocalResourceBuilderItemBuilder.setType(item.getType());
            odpsLocalResourceBuilder.addLocalresourceitem(odpsLocalResourceBuilderItemBuilder.build());
        }
        return odpsLocalResourceBuilder.build();
    }

    public static String genCupidTrackUrl(Instance amInstance, String appId, String webUrl) throws OdpsException {
        return YarnClientImplUtil.genCupidTrackUrl(amInstance, appId, webUrl, null);
    }

    public static String genCupidTrackUrl(Instance amInstance, String appId, String webUrl, CupidSession overrideCupidSession) throws OdpsException {
        CupidSession cupidSession = overrideCupidSession == null ? CupidSession.get() : overrideCupidSession;
        String endPoint = cupidSession.conf.get("odps.runtime.end.point", cupidSession.conf.get("odps.end.point"));
        String defaultTrackurlHost = endPoint != null && endPoint.toLowerCase().contains("maxcompute.aliyun") ? "http://jobview.odps.aliyun.com" : "http://jobview.odps.aliyun-inc.com";
        String trackurlHost = cupidSession.conf.get("odps.moye.trackurl.host", defaultTrackurlHost);
        TrackUrl trackUrl = new TrackUrl(cupidSession.odps(), trackurlHost);
        String hours = cupidSession.conf.get("odps.cupid.job.capability.duration.hours", "72");
        String cupidType = cupidSession.conf.get("odps.moye.runtime.type", "spark");
        String lookupName = cupidSession.getJobLookupName();
        if (!trackurlHost.equals("")) {
            trackUrl.setLogViewHost(trackurlHost);
        }
        String webproxyEndPoint = cupidSession.conf.get("odps.cupid.webproxy.endpoint", endPoint);
        String trackUrlStr = "true".equals(cupidSession.conf.get("odps.cupid.proxy.enable", "false")) ? trackUrl.genCupidTrackUrl(amInstance, appId, webUrl, hours, cupidType, lookupName, webproxyEndPoint, cupidSession) : trackUrl.genCupidTrackUrl(amInstance, appId, webUrl, hours, cupidType, lookupName, webproxyEndPoint);
        if (cupidSession.conf.get("odps.moye.test.callwebproxy", "false").equals("true")) {
            logger.info((Object)"start to call the webproxy");
            String interval = cupidSession.conf.get("odps.moye.test.callwebproxy.interval", "10");
            PollCallWebProxy.getInstance().startPoll(trackUrlStr, Integer.parseInt(interval));
        }
        return trackUrlStr;
    }

    public static Instance transformAppCtxAndStartAM(HashMap<String, String> paramForFM, CupidTaskParamProtos.OdpsLocalResource odpsLocalResource) throws OdpsException, InterruptedException, ExecutionException, InvalidProtocolBufferException, CupidException, RetryException, FileNotFoundException {
        return YarnClientImplUtil.transformAppCtxAndStartAM(paramForFM, odpsLocalResource, null);
    }

    public static Instance transformAppCtxAndStartAM(HashMap<String, String> paramForFM, CupidTaskParamProtos.OdpsLocalResource odpsLocalResource, CupidSession overrideCupidSession) throws InvalidProtocolBufferException, ExecutionException, RetryException, InterruptedException, CupidException, FileNotFoundException, OdpsException {
        int jobPriority;
        CupidSession cupidSession = overrideCupidSession == null ? CupidSession.get() : overrideCupidSession;
        CupidTaskParamProtos.CupidTaskOperator.Builder cupidTaskOperator = CupidTaskParamProtos.CupidTaskOperator.newBuilder();
        cupidTaskOperator.setMoperator("startam");
        cupidTaskOperator.setMlookupName("");
        String engineType = paramForFM.get("odps.cupid.engine.running.type");
        int n = jobPriority = paramForFM.get("odps.cupid.job.priority") == null ? 1 : Integer.parseInt(paramForFM.get("odps.cupid.job.priority"));
        if (engineType != null) {
            cupidTaskOperator.setMenginetype(engineType);
        }
        if (paramForFM.containsKey("odps.cupid.volume.paths")) {
            VolumePathsCapProtos.VolumePaths.Builder volumePathsBuilder = VolumePathsCapProtos.VolumePaths.newBuilder();
            VolumePathsCapProtos.PathInfo.Builder pathInfoBuilder = VolumePathsCapProtos.PathInfo.newBuilder();
            for (String volumePath : paramForFM.get("odps.cupid.volume.paths").split(",")) {
                pathInfoBuilder.setVolumepath(volumePath);
                pathInfoBuilder.setVolumecap(VolumePathsCapProtos.VolumeCap.ReadAndWrite);
                volumePathsBuilder.addPathinfo(pathInfoBuilder.build());
            }
            paramForFM.put("odps.moye.volume.path.info", Base64.encodeBase64String((byte[])volumePathsBuilder.build().toByteArray()));
        }
        CupidTaskParamProtos.JobConf.Builder jobConfBuilder = CupidTaskParamProtos.JobConf.newBuilder();
        CupidTaskParamProtos.JobConfItem.Builder jobConfItemBuilder = CupidTaskParamProtos.JobConfItem.newBuilder();
        for (Map.Entry<String, String> entry : paramForFM.entrySet()) {
            if (!entry.getKey().startsWith("cupid") && !entry.getKey().startsWith("odps") && !entry.getKey().startsWith("odps.moye") && !entry.getKey().startsWith("odps.executor") && !entry.getKey().startsWith("odps.cupid")) continue;
            jobConfItemBuilder.setKey(entry.getKey());
            jobConfItemBuilder.setValue(entry.getValue());
            jobConfBuilder.addJobconfitem(jobConfItemBuilder.build());
        }
        if (paramForFM.containsKey("odps.cupid.aliyarn.mode.enable") && paramForFM.get("odps.cupid.aliyarn.mode.enable").equals("true")) {
            jobConfItemBuilder.setKey("yarn.ipc.client.factory.class");
            jobConfItemBuilder.setValue("org.apache.hadoop.yarn.client.api.aliyarn.FuxiClientFactoryImpl");
            jobConfBuilder.addJobconfitem(jobConfItemBuilder.build());
        } else if (!paramForFM.containsKey("odps.cupid.aliyarn.mode.enable")) {
            jobConfItemBuilder.setKey("odps.cupid.aliyarn.mode.enable");
            jobConfItemBuilder.setValue("true");
            jobConfBuilder.addJobconfitem(jobConfItemBuilder.build());
            jobConfItemBuilder.setKey("yarn.ipc.client.factory.class");
            jobConfItemBuilder.setValue("org.apache.hadoop.yarn.client.api.aliyarn.FuxiClientFactoryImpl");
            jobConfBuilder.addJobconfitem(jobConfItemBuilder.build());
        } else {
            logger.info((Object)"User close aliyarn mode!");
        }
        CupidTaskParamProtos.CupidTaskParam.Builder cupidTaskParamBuilder = CupidTaskParamProtos.CupidTaskParam.newBuilder();
        cupidTaskParamBuilder.setMcupidtaskoperator(cupidTaskOperator.build());
        cupidTaskParamBuilder.setJobconf(jobConfBuilder.build());
        cupidTaskParamBuilder.setLocalresource(YarnClientImplUtil.setProjectForLocalResource(odpsLocalResource));
        boolean cupidPlanUseResource = false;
        if (engineType != null && engineType.equals("longtime")) {
            cupidPlanUseResource = true;
        }
        Instance instance = SubmitJobUtil.submitJob(cupidTaskParamBuilder.build(), CupidTaskRunningMode.eHasFuxiJob, jobPriority, cupidPlanUseResource, cupidSession);
        logger.info((Object)("transformAppCtxAndStartAM instance id " + instance.getId()));
        if (paramForFM.containsKey("odps.cupid.logview.host")) {
            cupidSession.odps().setLogViewHost(paramForFM.get("odps.cupid.logview.host"));
        }
        long hours = 72L;
        if (paramForFM.containsKey("odps.cupid.job.capability.duration.hours")) {
            hours = Long.parseLong(paramForFM.get("odps.cupid.job.capability.duration.hours"));
        }
        String logViewUrl = cupidSession.odps().logview().generateLogView(instance, hours);
        logger.info((Object)("logview url: " + logViewUrl));
        cupidSession.setJobLookupName(instance.getId());
        CupidSession.get().setJobLookupName(instance.getId());
        if (!paramForFM.containsKey("odps.cupid.submit.detach.mode.enable") || paramForFM.get("odps.cupid.submit.detach.mode.enable").equals("false")) {
            CupidUtil.getResult(instance);
        }
        return instance;
    }
}

