/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.requestcupid;

import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class RetryUtil {
    private static Logger logger = Logger.getLogger(RetryUtil.class);

    public static <T> T retryFunction(Callable<T> f, String message) throws ExecutionException, RetryException {
        return RetryUtil.retryFunction(f, message, 0, 1);
    }

    public static <T> T retryFunction(Callable<T> f, String message, int RetryTimes) throws ExecutionException, RetryException {
        return RetryUtil.retryFunction(f, message, RetryTimes, 1);
    }

    public static <T> T retryFunction(Callable<T> f, String message, int RetryTimes, int IntervalTimes) throws ExecutionException, RetryException {
        logger.debug((Object)("enter retryFunction with message: " + message + ", RetryTimes: " + RetryTimes + ", IntervalTimes: " + IntervalTimes));
        Retryer retryer = RetryerBuilder.newBuilder().retryIfExceptionOfType(Throwable.class).withWaitStrategy(WaitStrategies.fixedWait((long)IntervalTimes, (TimeUnit)TimeUnit.SECONDS)).withStopStrategy(StopStrategies.stopAfterAttempt((int)RetryTimes)).build();
        try {
            return (T)retryer.call(f);
        }
        catch (RetryException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            throw e;
        }
    }
}

