/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.requestcupid;

import apsara.odps.cupid.protocol.CupidTaskParamProtos;
import apsara.odps.cupid.protocol.CupidTaskServiceProto;
import com.aliyun.odps.cupid.CupidSession;
import com.aliyun.odps.cupid.basic.rpc.CupidTaskServiceRpcChannel;
import com.aliyun.odps.cupid.basic.rpc.CupidTaskServiceRpcController;
import com.aliyun.odps.cupid.com.google.protobuf.RpcCallback;
import com.aliyun.odps.cupid.requestcupid.CupidTaskBaseUtil;
import com.aliyun.odps.cupid.requestcupid.CupidTaskOperatorConst;
import com.aliyun.odps.cupid.requestcupid.SubmitJobUtil;
import java.util.List;
import org.apache.log4j.Logger;

public class CupidProxyTokenUtil {
    private static Logger logger = Logger.getLogger(CupidProxyTokenUtil.class);

    public static String getProxyToken(String instanceId, String appName, int expiredInHours, CupidSession cupidSession) throws Exception {
        CupidTaskParamProtos.CupidTaskParam.Builder cupidTaskParamBuilder = CupidTaskBaseUtil.getOperationBaseInfo(cupidSession, CupidTaskOperatorConst.CUPID_TASK_GET_PROXY_TOKEN);
        CupidTaskParamProtos.CupidProxyTokenRequest.Builder cupidProxyTokenRequest = CupidTaskParamProtos.CupidProxyTokenRequest.newBuilder();
        cupidProxyTokenRequest.setInstanceId(instanceId);
        cupidProxyTokenRequest.setAppName(appName);
        cupidProxyTokenRequest.setExpiredInHours(expiredInHours);
        cupidTaskParamBuilder.setCupidProxyTokenRequest(cupidProxyTokenRequest.build());
        return SubmitJobUtil.getProxyTokenSubmitJob(cupidTaskParamBuilder.build(), cupidSession);
    }

    public static List<String> getProxyAppNames(String instanceId, CupidSession cupidSession) throws Exception {
        CupidTaskServiceRpcController controller = new CupidTaskServiceRpcController();
        CupidTaskServiceRpcChannel channel = new CupidTaskServiceRpcChannel(cupidSession);
        CupidTaskServiceProto.CupidTaskService.Stub stub = CupidTaskServiceProto.CupidTaskService.newStub(channel);
        CupidTaskServiceProto.CupidProxyAppNamesRequest.Builder request = CupidTaskServiceProto.CupidProxyAppNamesRequest.newBuilder();
        request.setInstanceId(instanceId);
        final CupidTaskServiceProto.CupidProxyAppNamesResponse.Builder response = CupidTaskServiceProto.CupidProxyAppNamesResponse.newBuilder();
        RpcCallback<CupidTaskServiceProto.CupidProxyAppNamesResponse> callback = new RpcCallback<CupidTaskServiceProto.CupidProxyAppNamesResponse>(){

            @Override
            public void run(CupidTaskServiceProto.CupidProxyAppNamesResponse parameter) {
                response.mergeFrom(parameter);
            }
        };
        stub.getCupidProxyAppNames(controller, request.build(), callback);
        if (controller.failed()) {
            throw new Exception(controller.errorText());
        }
        return response.getNamesList();
    }
}

