/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.requestcupid;

import apsara.odps.cupid.protocol.CupidTaskParamProtos;
import com.aliyun.odps.cupid.CupidException;
import com.aliyun.odps.cupid.CupidSession;
import com.aliyun.odps.cupid.requestcupid.CupidTaskBaseUtil;
import com.aliyun.odps.cupid.requestcupid.CupidTaskOperatorConst;
import com.aliyun.odps.cupid.requestcupid.SubmitJobUtil;
import org.apache.log4j.Logger;

public class ApplicationMetaUtil {
    private static Logger logger = Logger.getLogger(ApplicationMetaUtil.class);

    public static void createApplicationMeta(String applicationType, String applicationId, String instanceId, String applicationTags, String applicationName, CupidSession cupidSession) throws Exception {
        CupidTaskParamProtos.CupidTaskParam.Builder cupidTaskParamBuilder = CupidTaskBaseUtil.getOperationBaseInfo(cupidSession, CupidTaskOperatorConst.CUPID_TASK_CREATE_APPLICATION_META);
        CupidTaskParamProtos.CreateApplicationMetaInfo.Builder createApplicationMetaInfo = CupidTaskParamProtos.CreateApplicationMetaInfo.newBuilder();
        createApplicationMetaInfo.setApplicationId(applicationId);
        createApplicationMetaInfo.setApplicationTags(applicationTags);
        createApplicationMetaInfo.setInstanceId(instanceId);
        createApplicationMetaInfo.setApplicationType(applicationType);
        createApplicationMetaInfo.setRunningMode(cupidSession.conf.get("odps.cupid.engine.running.type", "default"));
        createApplicationMetaInfo.setApplicationName(applicationName);
        cupidTaskParamBuilder.setCreateApplicationMetaInfo(createApplicationMetaInfo.build());
        SubmitJobUtil.createApplicationMetaSubmitJob(cupidTaskParamBuilder.build(), cupidSession);
    }

    public static CupidTaskParamProtos.ApplicationMeta getApplicationMeta(String applicationId, CupidSession cupidSession) throws Exception {
        CupidTaskParamProtos.CupidTaskParam.Builder cupidTaskParamBuilder = CupidTaskBaseUtil.getOperationBaseInfo(cupidSession, CupidTaskOperatorConst.CUPID_TASK_GET_APPLICATION_META);
        CupidTaskParamProtos.GetApplicationMetaInfo.Builder getApplicationMetaInfo = CupidTaskParamProtos.GetApplicationMetaInfo.newBuilder();
        getApplicationMetaInfo.setApplicationId(applicationId);
        cupidTaskParamBuilder.setGetApplicationMetaInfo(getApplicationMetaInfo.build());
        return SubmitJobUtil.getApplicationMetaSubmitJob(cupidTaskParamBuilder.build(), cupidSession);
    }

    public static CupidTaskParamProtos.ApplicationMeta getCupidInstanceMeta(String instanceId, CupidSession cupidSession) throws Exception {
        CupidTaskParamProtos.CupidTaskParam.Builder cupidTaskParamBuilder = CupidTaskBaseUtil.getOperationBaseInfo(cupidSession, CupidTaskOperatorConst.CUPID_TASK_GET_APPLICATION_META);
        try {
            CupidTaskParamProtos.GetApplicationMetaInfo.Builder getApplicationMetaInfo = CupidTaskParamProtos.GetApplicationMetaInfo.newBuilder();
            getApplicationMetaInfo.setInstanceId(instanceId);
            cupidTaskParamBuilder.setGetApplicationMetaInfo(getApplicationMetaInfo.build());
            return SubmitJobUtil.getApplicationMetaSubmitJob(cupidTaskParamBuilder.build(), cupidSession);
        }
        catch (CupidException ex) {
            logger.error((Object)("getCupidInstanceMeta via instanceId: " + instanceId + " failed with errMsg: " + ex.getMessage()), (Throwable)ex);
            return null;
        }
    }

    public static CupidTaskParamProtos.ApplicationMetaList listApplicationMeta(String applicationTypes, String yarnApplicationStates, CupidSession cupidSession) throws Exception {
        CupidTaskParamProtos.CupidTaskParam.Builder cupidTaskParamBuilder = CupidTaskBaseUtil.getOperationBaseInfo(cupidSession, CupidTaskOperatorConst.CUPID_TASK_LIST_APPLICATION_META);
        CupidTaskParamProtos.ListApplicationMetaInfo.Builder listApplicationMetaInfo = CupidTaskParamProtos.ListApplicationMetaInfo.newBuilder();
        if (applicationTypes != null && !applicationTypes.equals("")) {
            listApplicationMetaInfo.setApplicationTypes(applicationTypes);
        }
        if (yarnApplicationStates != null && !yarnApplicationStates.equals("")) {
            listApplicationMetaInfo.setYarnApplicationStates(yarnApplicationStates);
        }
        cupidTaskParamBuilder.setListApplicationMetaInfo(listApplicationMetaInfo.build());
        return SubmitJobUtil.listApplicationMetaSubmitJob(cupidTaskParamBuilder.build(), cupidSession);
    }

    public static void updateApplicationMeta(String applicationId, CupidTaskParamProtos.ApplicationMeta applicationMeta, CupidSession cupidSession) throws Exception {
        CupidTaskParamProtos.CupidTaskParam.Builder cupidTaskParamBuilder = CupidTaskBaseUtil.getOperationBaseInfo(cupidSession, CupidTaskOperatorConst.CUPID_TASK_UPDATE_APPLICATION_META);
        CupidTaskParamProtos.UpdateApplicationMetaInfo.Builder updateApplicationMetaInfo = CupidTaskParamProtos.UpdateApplicationMetaInfo.newBuilder();
        updateApplicationMetaInfo.setApplicationId(applicationId);
        updateApplicationMetaInfo.setApplicationMeta(applicationMeta);
        cupidTaskParamBuilder.setUpdateApplicationMetaInfo(updateApplicationMetaInfo.build());
        SubmitJobUtil.updateApplicationMetaSubmitJob(cupidTaskParamBuilder.build(), cupidSession);
    }
}

