/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid;

import com.aliyun.odps.cupid.utils.JTuple;
import java.util.ArrayList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class CupidConf {
    private Logger logger = Logger.getLogger(CupidConf.class);
    private ConcurrentHashMap<String, String> settings = new ConcurrentHashMap();

    public String get(String key) {
        if (this.settings.containsKey(key)) {
            return this.settings.get(key);
        }
        throw new NoSuchElementException(key);
    }

    public String get(String key, String defaultValue) {
        if (this.settings.containsKey(key)) {
            return this.settings.get(key);
        }
        return defaultValue;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        if (this.settings.containsKey(key)) {
            return Boolean.parseBoolean(this.settings.get(key));
        }
        return defaultValue;
    }

    public JTuple.JTuple2<String, String>[] getAll() {
        ArrayList<JTuple.JTuple2<String, String>> allConfs = new ArrayList<JTuple.JTuple2<String, String>>();
        for (Map.Entry<String, String> entry : this.settings.entrySet()) {
            allConfs.add(JTuple.tuple(entry.getKey(), entry.getValue()));
        }
        return allConfs.toArray(new JTuple.JTuple2[allConfs.size()]);
    }

    public CupidConf remove(String key) {
        this.settings.remove(key);
        return this;
    }

    public CupidConf set(String key, String value) {
        if (key == null) {
            throw new NullPointerException("null key");
        }
        if (value == null) {
            throw new NullPointerException("null value for " + key);
        }
        this.settings.put(key.trim(), value.trim());
        return this;
    }
}

