/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.ship.upload;

import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.RecordWriter;
import com.aliyun.odps.ship.common.BlockInfo;
import com.aliyun.odps.ship.common.CommandType;
import com.aliyun.odps.ship.common.Constants;
import com.aliyun.odps.ship.common.DshipContext;
import com.aliyun.odps.ship.common.DshipStopWatch;
import com.aliyun.odps.ship.common.RecordConverter;
import com.aliyun.odps.ship.common.SessionStatus;
import com.aliyun.odps.ship.common.Util;
import com.aliyun.odps.ship.history.SessionHistory;
import com.aliyun.odps.ship.upload.BlockRecordReader;
import com.aliyun.odps.ship.upload.CsvRecordReader;
import com.aliyun.odps.ship.upload.RecordReader;
import com.aliyun.odps.ship.upload.TunnelUpdateSession;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.cli.ParseException;
import org.jline.reader.UserInterruptException;

public class BlockUploader {
    private BlockInfo blockInfo;
    private Long blockId;
    private TunnelUpdateSession updateSession;
    private SessionHistory sessionHistory;
    private boolean isScan;
    private boolean isDiscardBadRecord;
    private boolean isStrictSchema;
    private long badRecords;
    private long maxBadRecords = Constants.DEFAULT_BAD_RECORDS;
    private DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private long startTime = 0L;
    private long preTime = 0L;
    private DshipStopWatch localIOStopWatch;
    private DshipStopWatch tunnelIOStopWatch;
    private boolean isCsv;
    private boolean printIOElapsedTime;
    protected boolean isUpsert;

    public BlockUploader(BlockInfo blockInfo, TunnelUpdateSession tus, SessionHistory sh) throws IOException {
        this(blockInfo, tus, sh, false);
    }

    public BlockUploader(BlockInfo blockInfo, TunnelUpdateSession tus, SessionHistory sh, boolean isCsv) {
        this.isUpsert = tus.getCommandType().equals((Object)CommandType.upsert);
        this.blockInfo = blockInfo;
        this.blockId = blockInfo.getBlockId();
        this.updateSession = tus;
        this.sessionHistory = sh;
        this.isScan = tus.isScan();
        this.isDiscardBadRecord = Boolean.valueOf(DshipContext.INSTANCE.get("discard-bad-records"));
        this.isStrictSchema = Boolean.valueOf(DshipContext.INSTANCE.get("strict-schema"));
        this.printIOElapsedTime = Boolean.valueOf(DshipContext.INSTANCE.get("time"));
        this.localIOStopWatch = new DshipStopWatch("local I/O", this.printIOElapsedTime);
        this.tunnelIOStopWatch = new DshipStopWatch("tunnel I/O", this.printIOElapsedTime);
        this.badRecords = 0L;
        if (DshipContext.INSTANCE.get("max-bad-records") != null) {
            this.maxBadRecords = Long.valueOf(DshipContext.INSTANCE.get("max-bad-records"));
        }
        this.isCsv = isCsv;
    }

    public void upload() throws TunnelException, IOException, ParseException {
        this.startTime = System.currentTimeMillis();
        this.preTime = System.currentTimeMillis();
        String type = this.isUpsert ? "upsert" : (this.isScan ? "scan" : "upload");
        this.print(type + " block: '" + this.blockId + "'\n");
        this.sessionHistory.log("start " + type + " , blockid=" + this.blockId);
        this.sessionHistory.saveContext();
        int retry = 1;
        while (true) {
            try {
                this.doUpdate();
                break;
            }
            catch (TunnelException e) {
                this.sessionHistory.log("retry:" + retry + "  " + Util.getStack((Exception)((Object)e)));
                if (retry > 5) {
                    DshipContext.INSTANCE.put("status", SessionStatus.resume.toString());
                    this.sessionHistory.saveContext();
                    throw e;
                }
                this.print("update block " + this.blockId + " fail, retry:" + retry + "\n");
            }
            catch (IOException e) {
                this.sessionHistory.log("retry:" + retry + "  " + Util.getStack(e));
                if (retry > 5) {
                    DshipContext.INSTANCE.put("status", SessionStatus.resume.toString());
                    this.sessionHistory.saveContext();
                    throw e;
                }
                this.print("update block " + this.blockId + " fail, retry:" + retry + "\n");
            }
            ++retry;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                throw new UserInterruptException(e.getMessage());
            }
        }
        this.sessionHistory.log(type + " complete, blockid=" + this.blockId);
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append(String.format("%s block complete, block id: %d%s", type, this.blockId, this.badRecords > 0L ? " [bad " + this.badRecords + "]" : ""));
        if (!this.isScan) {
            messageBuilder.append(this.localIOStopWatch.getFormattedSummary());
            messageBuilder.append(this.tunnelIOStopWatch.getFormattedSummary());
        }
        messageBuilder.append("\n");
        this.print(messageBuilder.toString());
    }

    private boolean doUpdate() throws TunnelException, IOException, ParseException {
        this.sessionHistory.clearBadData(this.blockId);
        RecordReader reader = this.createReader();
        RecordConverter recordConverter = this.createRecordConverter(reader.getDetectedCharset());
        RecordWriter writer = this.updateSession.getWriter(this.blockId);
        this.updateSession.initRecord();
        while (true) {
            try {
                byte[][] textRecord;
                while ((textRecord = this.readAndTime(reader)) != null) {
                    Record r = this.updateSession.getRecord(recordConverter, textRecord);
                    this.writeAndTime(writer, r);
                    this.printProgress(reader.getReadBytes(), false);
                    ODPSConsoleUtils.checkThreadInterrupted();
                }
            }
            catch (ParseException e) {
                String currentLine = reader.getCurrentLine();
                long offset = reader.getReadBytes() + this.blockInfo.getStartPos() - (long)currentLine.length();
                if (currentLine.length() > 100) {
                    currentLine = currentLine.substring(0, 100) + " ...";
                }
                String errMsg = e.getMessage() + "content: " + currentLine + "\noffset: " + offset + "\n";
                if (this.isDiscardBadRecord) {
                    this.print(errMsg);
                    this.checkDiscardBadData();
                    this.sessionHistory.saveBadData(reader.getCurrentLine() + DshipContext.INSTANCE.get("record-delimiter"), this.blockId);
                    continue;
                }
                DshipContext.INSTANCE.put("status", SessionStatus.failed.toString());
                this.sessionHistory.saveContext();
                throw new ParseException(errMsg);
            }
            break;
        }
        writer.close();
        reader.close();
        if (!this.isScan) {
            this.printProgress(reader.getReadBytes(), true);
            this.sessionHistory.saveFinishBlock(this.blockInfo);
        }
        return false;
    }

    private RecordReader createReader() throws IOException {
        RecordReader reader;
        boolean ignoreHeader = "true".equalsIgnoreCase(DshipContext.INSTANCE.get("header"));
        if (this.isCsv) {
            reader = new CsvRecordReader(this.blockInfo, DshipContext.INSTANCE.get("charset"), ignoreHeader);
        } else {
            String fieldDelimiter = DshipContext.INSTANCE.get("field-delimiter");
            String recordDelimiter = DshipContext.INSTANCE.get("record-delimiter");
            reader = new BlockRecordReader(this.blockInfo, fieldDelimiter, recordDelimiter, ignoreHeader);
        }
        return reader;
    }

    private RecordConverter createRecordConverter(String detectedCharset) throws UnsupportedEncodingException {
        String charset = detectedCharset == null ? DshipContext.INSTANCE.get("charset") : detectedCharset;
        String ni = DshipContext.INSTANCE.get("null-indicator");
        String dfp = DshipContext.INSTANCE.get("date-format-pattern");
        String tz = DshipContext.INSTANCE.get("time-zone");
        RecordConverter recordConverter = new RecordConverter(this.updateSession.getSchema(), ni, dfp, tz, charset, false, this.isStrictSchema);
        return recordConverter;
    }

    private void printProgress(long cb, boolean summary) {
        if (this.updateSession.isScan()) {
            return;
        }
        long currTime = System.currentTimeMillis();
        int updateGap = 5000;
        if (!summary && currTime - this.preTime <= (long)updateGap) {
            return;
        }
        long gap = (currTime - this.startTime) / 1000L;
        long length = this.blockInfo.getLength();
        if (gap > 0L && length > 0L) {
            long cspeed = cb / gap;
            long percent = cb * 100L / length;
            StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.append(String.format("Block info: %s, progress: %d%%, bs: %s, speed: %s/s", this.blockInfo.toString(), percent, Util.toReadableBytes(cb), Util.toReadableBytes(cspeed)));
            messageBuilder.append(this.localIOStopWatch.getFormattedSummary());
            messageBuilder.append(this.tunnelIOStopWatch.getFormattedSummary());
            messageBuilder.append("\n");
            this.print(messageBuilder.toString());
            this.preTime = currTime;
        }
    }

    private void print(String msg) {
        Instant instant = Instant.now();
        ZonedDateTime zonedDateTime = instant.atZone(ZoneId.systemDefault());
        String processStr = this.dateTimeFormatter.format(zonedDateTime) + "\t";
        System.err.print(processStr + msg);
    }

    private void checkDiscardBadData() throws ParseException, IOException {
        ++this.badRecords;
        if (this.badRecords > this.maxBadRecords) {
            DshipContext.INSTANCE.put("status", SessionStatus.failed.toString());
            this.sessionHistory.saveContext();
            throw new ParseException("ERROR: bad records exceed " + this.maxBadRecords);
        }
    }

    private void writeAndTime(RecordWriter writer, Record record) throws IOException {
        this.tunnelIOStopWatch.resume();
        try {
            writer.write(record);
        }
        finally {
            this.tunnelIOStopWatch.suspend();
        }
    }

    private byte[][] readAndTime(RecordReader reader) throws IOException {
        this.localIOStopWatch.resume();
        try {
            byte[][] byArray = reader.readTextRecord();
            return byArray;
        }
        finally {
            this.localIOStopWatch.suspend();
        }
    }
}

