/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.ship.download;

import com.aliyun.odps.Column;
import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.data.RecordReader;
import com.aliyun.odps.ship.common.DshipContext;
import com.aliyun.odps.ship.download.DshipRecordReader;
import com.aliyun.odps.ship.history.SessionHistory;
import com.aliyun.odps.ship.history.SessionHistoryManager;
import com.aliyun.odps.tunnel.InstanceTunnel;
import com.aliyun.odps.tunnel.TableTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.utils.OdpsConnectionFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

public class TunnelDownloadSession {
    private TableTunnel.DownloadSession tableDownload = null;
    private InstanceTunnel.DownloadSession instanceDownload = null;
    boolean isInstanceTunnel = false;
    private List<Column> selectedColumns = null;
    private TableSchema schema;
    private String downloadId;
    private SessionHistory sessionHistory;
    private long totalLines;

    protected TunnelDownloadSession(long lines) {
        this.totalLines = lines;
    }

    public TunnelDownloadSession(String instanceId) throws TunnelException, ODPSConsoleException, FileNotFoundException {
        String tableProject = DshipContext.INSTANCE.get("table-project");
        Odps odps = OdpsConnectionFactory.createOdps((ExecutionContext)DshipContext.INSTANCE.getExecutionContext());
        InstanceTunnel tunnel = new InstanceTunnel(odps);
        if (DshipContext.INSTANCE.get("tunnel_endpoint") != null) {
            tunnel.setEndpoint(DshipContext.INSTANCE.get("tunnel_endpoint"));
        } else if (StringUtils.isNotEmpty((String)DshipContext.INSTANCE.getExecutionContext().getTunnelEndpoint())) {
            tunnel.setEndpoint(DshipContext.INSTANCE.getExecutionContext().getTunnelEndpoint());
        }
        if (tableProject == null) {
            tableProject = odps.getDefaultProject();
        }
        this.instanceDownload = tunnel.createDownloadSession(tableProject, instanceId);
        this.sessionHistory = SessionHistoryManager.createSessionHistory(this.instanceDownload.getId());
        this.totalLines = this.instanceDownload.getRecordCount();
        this.schema = this.instanceDownload.getSchema();
        this.downloadId = this.instanceDownload.getId();
        this.isInstanceTunnel = true;
        this.initSelectColumns();
    }

    public TunnelDownloadSession(String tableName, PartitionSpec ps) throws OdpsException, ODPSConsoleException, IOException {
        String tableProject = DshipContext.INSTANCE.get("table-project");
        String schemaName = DshipContext.INSTANCE.get("schema");
        Odps odps = OdpsConnectionFactory.createOdps((ExecutionContext)DshipContext.INSTANCE.getExecutionContext());
        TableTunnel tunnel = new TableTunnel(odps);
        tunnel.getConfig().setQuotaName(DshipContext.INSTANCE.get("quota_name"));
        if (DshipContext.INSTANCE.get("tunnel_endpoint") != null) {
            tunnel.setEndpoint(DshipContext.INSTANCE.get("tunnel_endpoint"));
        } else if (StringUtils.isNotEmpty((String)DshipContext.INSTANCE.getExecutionContext().getTunnelEndpoint())) {
            tunnel.setEndpoint(DshipContext.INSTANCE.getExecutionContext().getTunnelEndpoint());
        }
        if (tableProject == null) {
            tableProject = odps.getDefaultProject();
        }
        TableTunnel.DownloadSessionBuilder builder = tunnel.buildDownloadSession(tableProject, tableName).setSchemaName(schemaName).setAsyncMode(true).setWaitAsyncBuild(false);
        this.tableDownload = ps == null ? builder.build() : builder.setPartitionSpec(ps).build();
        this.sessionHistory = SessionHistoryManager.createSessionHistory(this.tableDownload.getId());
        String rapInstanceId = this.tableDownload.getRAPInstanceId();
        if (rapInstanceId != null) {
            while (rapInstanceId.isEmpty()) {
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                TableTunnel.DownloadStatus status = this.tableDownload.getStatus();
                rapInstanceId = this.tableDownload.getRAPInstanceId();
                if (status == TableTunnel.DownloadStatus.INITIATING) continue;
                break;
            }
            if (rapInstanceId.isEmpty()) {
                throw new OdpsException("Create TunnelDownloadSession error, failed to create RAP instance. session id: " + this.tableDownload.getId());
            }
            Instance sqlInstance = odps.instances().get(rapInstanceId);
            this.log("\nDue to the presence of row-level permission rules on current table, tunnel download requires run SQL task. Task info:");
            this.log("ID = " + rapInstanceId);
            this.log("Log view:\n" + odps.logview().generateLogView(sqlInstance, 168L) + "\n");
            sqlInstance.waitForSuccess();
        }
        builder.wait(this.tableDownload, 2, 120L);
        this.totalLines = this.tableDownload.getRecordCount();
        this.schema = this.tableDownload.getSchema();
        this.downloadId = this.tableDownload.getId();
        this.initSelectColumns();
    }

    private void initSelectColumns() {
        String columnNames = DshipContext.INSTANCE.get("columns-name");
        String columnIndexes = DshipContext.INSTANCE.get("columns-index");
        if (columnIndexes != null || columnNames != null) {
            boolean isIndex = columnIndexes != null;
            String columns = isIndex ? columnIndexes : columnNames;
            this.selectedColumns = new ArrayList<Column>();
            try {
                for (String name : columns.split(",")) {
                    if (!isIndex) {
                        this.selectedColumns.add(this.schema.getColumn(name.trim().toLowerCase()));
                        continue;
                    }
                    this.selectedColumns.add(this.schema.getColumn(Integer.parseInt(name.trim())));
                }
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Parse selected columns: %s failed, %s", columns, e.getMessage()), e);
            }
            System.err.println(String.format("Download %d columns, %s: %s", this.selectedColumns.size(), isIndex ? "column indexes are" : "column names are", columns));
            this.schema.setColumns(this.selectedColumns);
        }
    }

    public DshipRecordReader getRecordReader(Long start, Long end) throws IOException, TunnelException {
        return new DshipRecordReader(this, start, end, this.selectedColumns);
    }

    public TableSchema getSchema() {
        return this.schema;
    }

    public String getDownloadId() {
        return this.downloadId;
    }

    public long getTotalLines() {
        return this.totalLines;
    }

    public SessionHistory getSessionHistory() {
        return this.sessionHistory;
    }

    public RecordReader openRecordReader(long start, long count, boolean compress, List<Column> columns) throws TunnelException, IOException {
        return this.isInstanceTunnel ? this.instanceDownload.openRecordReader(start, count, compress, columns) : this.tableDownload.openRecordReader(start, count, compress, columns);
    }

    private void log(String str) throws IOException {
        this.sessionHistory.log(str);
        System.err.println(str);
    }
}

