/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.ship.download;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.ship.common.DshipContext;
import com.aliyun.odps.ship.common.PartitionHelper;
import com.aliyun.odps.ship.common.SessionStatus;
import com.aliyun.odps.ship.common.Util;
import com.aliyun.odps.ship.download.FileDownloader;
import com.aliyun.odps.ship.download.TunnelDownloadSession;
import com.aliyun.odps.ship.history.SessionHistory;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.utils.OdpsConnectionFactory;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.jline.reader.UserInterruptException;

public class DshipDownload {
    private ArrayList<FileDownloader> workItems = new ArrayList();
    private int threads;
    private String path;
    private long writtenBytes = 0L;
    private Long limit;
    private ExecutionContext context;
    private String projectName;
    private String schemaName;
    private String tableName;
    private String instanceId;
    private String partitonSpecLiteral;
    private String ext;
    private String filename;
    private String parentDir;
    private long totalLines;
    private long slices;
    private boolean isCsv;
    SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public DshipDownload() {
        this.threads = Integer.parseInt(DshipContext.INSTANCE.get("threads"));
        this.limit = DshipContext.INSTANCE.get("limit") != null ? Long.valueOf(Long.parseLong(DshipContext.INSTANCE.get("limit"))) : null;
        this.path = DshipContext.INSTANCE.get("resume-path");
        this.projectName = DshipContext.INSTANCE.get("table-project");
        this.schemaName = DshipContext.INSTANCE.get("schema");
        this.tableName = DshipContext.INSTANCE.get("table");
        this.instanceId = DshipContext.INSTANCE.get("instance-id");
        this.partitonSpecLiteral = DshipContext.INSTANCE.get("partition-spec");
        this.ext = Files.getFileExtension((String)this.path);
        this.filename = Files.getNameWithoutExtension((String)this.path);
        this.parentDir = FilenameUtils.removeExtension((String)this.path) + File.separator;
        this.context = DshipContext.INSTANCE.getExecutionContext();
        this.isCsv = "true".equalsIgnoreCase(DshipContext.INSTANCE.get("csv-format"));
    }

    public void initInstanceDownloadWorkItems(Odps odps) throws IOException, ODPSConsoleException, OdpsException {
        this.splitDataByThreads(new TunnelDownloadSession(this.instanceId), null);
    }

    public void initTableDownloadWorkItems(Odps odps) throws IOException, ODPSConsoleException, OdpsException {
        PartitionHelper helper = new PartitionHelper(odps, this.projectName, this.schemaName, this.tableName);
        if (!helper.isPartitioned()) {
            if (this.partitonSpecLiteral != null) {
                throw new OdpsException("ERROR: can not specify partition for an unpartitioned table");
            }
            this.splitDataByThreads(new TunnelDownloadSession(this.tableName, null), null);
        } else {
            List<PartitionSpec> parSpecs = helper.inferPartitionSpecs(this.partitonSpecLiteral);
            if (parSpecs.size() == 0) {
                throw new OdpsException("ERROR: can not infer any partitions from: " + this.partitonSpecLiteral);
            }
            if (parSpecs.size() == 1) {
                PartitionSpec ps = parSpecs.get(0);
                this.splitDataByThreads(new TunnelDownloadSession(this.tableName, ps), ps);
            } else {
                this.slices = parSpecs.size();
                long sliceId = 0L;
                long start = 0L;
                for (PartitionSpec ps : parSpecs) {
                    if (this.limit != null && start == this.limit) break;
                    TunnelDownloadSession tds = new TunnelDownloadSession(this.tableName, ps);
                    SessionHistory sh = tds.getSessionHistory();
                    String msg = ps.toString() + "\tnew session: " + tds.getDownloadId() + "\ttotal lines: " + Util.toReadableNumber(tds.getTotalLines());
                    System.err.println(this.sim.format(new Date()) + "  -  " + msg);
                    sh.log(msg);
                    long step = this.limit == null ? tds.getTotalLines() : Math.min(tds.getTotalLines(), this.limit - start);
                    String sliceFileName = this.filename + PartitionHelper.buildSuffix(ps);
                    if (StringUtils.isNotEmpty((String)this.ext)) {
                        sliceFileName = sliceFileName + "." + this.ext;
                    }
                    this.path = this.parentDir + sliceFileName;
                    FileDownloader sd = new FileDownloader(this.path, sliceId, 0L, step, tds, sh, this.isCsv, ps);
                    this.workItems.add(sd);
                    ++sliceId;
                    start += step;
                }
                this.totalLines = start;
            }
        }
    }

    public void download() throws IOException, ParseException, ODPSConsoleException, OdpsException {
        Odps odps = OdpsConnectionFactory.createOdps((ExecutionContext)this.context);
        if (this.projectName == null) {
            this.projectName = odps.getDefaultProject();
        }
        if (this.instanceId != null) {
            this.initInstanceDownloadWorkItems(odps);
        } else {
            this.initTableDownloadWorkItems(odps);
        }
        long startTime = System.currentTimeMillis();
        for (FileDownloader sd : this.workItems) {
            DshipContext.INSTANCE.put("status", SessionStatus.running.toString());
            sd.sh.saveContext();
        }
        if (this.threads == 1) {
            System.err.printf("downloading %s records into %s\n", Util.toReadableNumber(this.totalLines), Util.pluralize("file", this.slices));
            for (FileDownloader sd : this.workItems) {
                sd.download();
                this.writtenBytes += sd.getWrittenBytes();
            }
        } else {
            System.err.printf("downloading %s records into %s using %s\n", Util.toReadableNumber(this.totalLines), Util.pluralize("file", this.slices), Util.pluralize("thread", this.threads));
            this.multiThreadDownload();
        }
        for (FileDownloader sd : this.workItems) {
            DshipContext.INSTANCE.put("status", SessionStatus.success.toString());
            sd.sh.saveContext();
        }
        long gap = System.currentTimeMillis() - startTime;
        if (gap > 0L) {
            long avgSpeed = this.writtenBytes / gap * 1000L;
            System.err.printf("total: %s, time: %s, average speed: %s/s\n", Util.toReadableBytes(this.writtenBytes), Util.toReadableMilliseconds(gap), Util.toReadableBytes(avgSpeed));
        }
        System.err.println("download OK");
    }

    private void splitDataByThreads(TunnelDownloadSession tds, PartitionSpec ps) throws IOException {
        SessionHistory sh = tds.getSessionHistory();
        String msg = "new session: " + tds.getDownloadId() + "\ttotal lines: " + Util.toReadableNumber(tds.getTotalLines());
        System.err.println(this.sim.format(new Date()) + "  -  " + msg);
        sh.log(msg);
        this.slices = this.threads;
        long start = 0L;
        this.totalLines = this.limit == null ? tds.getTotalLines() : Math.min(this.limit, tds.getTotalLines());
        long step = (this.totalLines + this.slices - 1L) / this.slices;
        for (long i = 0L; i < this.slices; ++i) {
            long end = Math.min(start + step, this.totalLines);
            if (this.slices != 1L) {
                String sliceFileName = this.filename + "_" + i;
                if (StringUtils.isNotEmpty((String)this.ext)) {
                    sliceFileName = sliceFileName + "." + this.ext;
                }
                this.path = this.parentDir + sliceFileName;
            }
            FileDownloader sd = new FileDownloader(this.path, i, start, end, tds, sh, this.isCsv, ps);
            this.workItems.add(sd);
            start = end;
        }
    }

    private void multiThreadDownload() throws TunnelException {
        ArrayList<1> callList = new ArrayList<1>();
        for (final FileDownloader downloader : this.workItems) {
            Callable<Long> call = new Callable<Long>(){

                @Override
                public Long call() throws Exception {
                    downloader.download();
                    return downloader.getWrittenBytes();
                }
            };
            callList.add(call);
        }
        ExecutorService executors = Executors.newFixedThreadPool(this.threads);
        try {
            List futures = executors.invokeAll(callList);
            ArrayList<String> failedThread = new ArrayList<String>();
            for (int i = 0; i < futures.size(); ++i) {
                try {
                    this.writtenBytes += ((Long)futures.get(i).get()).longValue();
                    continue;
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                    failedThread.add(String.valueOf(i));
                }
            }
            if (!failedThread.isEmpty()) {
                throw new TunnelException("Slice ID:" + StringUtils.join(failedThread, (String)",") + " Failed.");
            }
        }
        catch (InterruptedException e) {
            throw new UserInterruptException(e.getMessage());
        }
        finally {
            executors.shutdownNow();
        }
    }
}

