/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.ship.download;

import com.aliyun.odps.ship.common.Util;
import com.aliyun.odps.ship.download.RecordWriter;
import com.csvreader.CsvWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;

public class CsvRecordWriter
extends RecordWriter {
    private CsvWriter csvWriter;
    private Charset charset;

    public CsvRecordWriter(File file, String cs) throws FileNotFoundException {
        super(file);
        String charsetName = Util.isIgnoreCharset(cs) ? "utf8" : cs;
        this.charset = Charset.forName(charsetName);
        this.csvWriter = new CsvWriter((OutputStream)this.os, ',', this.charset);
    }

    @Override
    public void write(byte[][] line, List<byte[]> ptVals) throws IOException {
        for (byte[] value : line) {
            this.csvWriter.write(new String(value, this.charset), true);
        }
        Object object = ptVals.iterator();
        while (object.hasNext()) {
            byte[] ptVal = (byte[])object.next();
            this.csvWriter.write(new String(ptVal, this.charset), true);
        }
        this.csvWriter.endRecord();
    }

    @Override
    public void close() throws IOException {
        this.csvWriter.close();
    }
}

