/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.ship;

import com.aliyun.odps.ship.DShip;
import com.aliyun.odps.ship.common.CommandType;
import com.aliyun.odps.ship.common.DshipContext;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.jline.reader.UserInterruptException;

public class DShipCommand
extends AbstractCommand {
    public static final String[] HELP_TAGS = new String[]{"tunnel", "dship"};

    public static void printUsage(PrintStream out) {
        try {
            DShip.showHelp("help.txt");
        }
        catch (IOException e) {
            out.println("Error: IO Error when get help info of tunnel");
        }
    }

    public DShipCommand(String commandText, ExecutionContext context) {
        super(commandText, context);
    }

    public static DShipCommand parse(String commandString, ExecutionContext sessionContext) {
        String readCommandString = commandString;
        if ("TUNNEL".equalsIgnoreCase(readCommandString.trim()) || readCommandString.toUpperCase().matches("\\s*TUNNEL\\s+.*")) {
            readCommandString = readCommandString.trim().replaceAll("\\s+", " ");
            return new DShipCommand(readCommandString, sessionContext);
        }
        return null;
    }

    public void run() throws ODPSConsoleException {
        String commandString = this.getCommandText();
        ArrayList<String> _args = new ArrayList<String>(Arrays.asList(commandString.split(" ", 3)));
        _args.remove(0);
        if (_args.size() == 0) {
            _args.add("help");
        }
        if (_args.size() == 2) {
            String[] suffix = ODPSConsoleUtils.translateCommandline((String)((String)_args.get(1)));
            _args.remove(1);
            _args.addAll(Arrays.asList(suffix));
        }
        DshipContext.INSTANCE.setExecutionContext(this.getContext());
        String[] args = _args.toArray(new String[_args.size()]);
        CommandType type = DShip.parseSubCommand(args);
        try {
            DShip.runSubCommand(type, args);
        }
        catch (UserInterruptException e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new ODPSConsoleException("error occurred while running tunnel command", throwable);
        }
    }
}

