/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.ship;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.ship.common.CommandType;
import com.aliyun.odps.ship.common.DshipContext;
import com.aliyun.odps.ship.common.OptionsBuilder;
import com.aliyun.odps.ship.common.Util;
import com.aliyun.odps.ship.download.DshipDownload;
import com.aliyun.odps.ship.history.SessionHistory;
import com.aliyun.odps.ship.history.SessionHistoryManager;
import com.aliyun.odps.ship.upload.TunnelUpdateSession;
import com.aliyun.odps.ship.upload.TunnelUploadSession;
import com.aliyun.odps.ship.upsert.DshipUpdate;
import com.aliyun.odps.ship.upsert.TunnelUpsertSession;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.InvalidParameterException;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.jline.reader.UserInterruptException;

public class DShip {
    public static CommandType parseSubCommand(String[] args) {
        CommandType type;
        try {
            type = CommandType.fromString(args[0]);
        }
        catch (IllegalArgumentException e) {
            System.err.println("Unknown command: '" + args[0] + "'.");
            System.err.println("Type 'tunnel help' for usage.");
            throw e;
        }
        return type;
    }

    public static void runSubCommand(CommandType type, String[] args) throws Throwable {
        String sid = null;
        try {
            switch (type) {
                case upload: {
                    OptionsBuilder.buildUploadOption(args);
                    DshipUpdate uploader = new DshipUpdate(new TunnelUploadSession());
                    sid = uploader.getTunnelSessionId();
                    uploader.upload();
                    break;
                }
                case download: {
                    OptionsBuilder.buildDownloadOption(args);
                    DshipDownload downloader = new DshipDownload();
                    downloader.download();
                    break;
                }
                case upsert: {
                    OptionsBuilder.buildUpsertOption(args);
                    DshipUpdate upserter = new DshipUpdate(new TunnelUpsertSession());
                    sid = upserter.getTunnelSessionId();
                    upserter.upload();
                    break;
                }
                case resume: {
                    DShip.resume(args);
                    break;
                }
                case show: {
                    DShip.show(args);
                    break;
                }
                case purge: {
                    DShip.purge(args);
                    break;
                }
                case help: {
                    DShip.help(args);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("ERROR: Unknown command");
                }
            }
        }
        catch (UserInterruptException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            DShip.logException(sid, e);
            throw e;
        }
        catch (FileNotFoundException e) {
            DShip.logException(sid, e);
            throw e;
        }
        catch (TunnelException e) {
            DShip.logExceptionWithCause(sid, "ERROR: TunnelException - ", (Exception)((Object)e));
            throw e;
        }
        catch (OdpsException e) {
            DShip.logExceptionWithCause(sid, "ERROR: OdpsException - ", (Exception)((Object)e));
            throw e;
        }
        catch (IOException e) {
            DShip.logExceptionWithCause(sid, "ERROR: IOException - ", e);
            throw e;
        }
        catch (ParseException e) {
            DShip.logException(sid, (Exception)((Object)e));
            throw e;
        }
        catch (Throwable e) {
            DShip.logException(sid, new Exception("ERROR: Unknown error - " + e.getMessage(), e));
            throw e;
        }
    }

    public static void resume(String[] args) throws OdpsException, IOException, ParseException, InvalidParameterException, ODPSConsoleException {
        TunnelUpdateSession uploadSession;
        System.out.println("start resume");
        OptionsBuilder.buildResumeOption(args);
        String sid = DshipContext.INSTANCE.get("session-id");
        System.out.println(sid);
        SessionHistory sh = null;
        if (sid == null) {
            sh = SessionHistoryManager.getLatest();
            sid = sh.getSid();
            System.out.println(sid);
        } else {
            Util.checkSession(sid);
            sh = SessionHistoryManager.createSessionHistory(sid);
        }
        sh.loadContext();
        String type = DshipContext.INSTANCE.get("command-type");
        if (type == null || !type.equals("upload") && !type.equals("upsert")) {
            throw new InvalidParameterException("ERROR: not support resume for '" + type + "'");
        }
        sh.log("start resume");
        switch (type) {
            case "upsert": {
                uploadSession = new TunnelUpsertSession();
                break;
            }
            default: {
                uploadSession = new TunnelUploadSession();
            }
        }
        DshipUpdate uploader = new DshipUpdate(uploadSession);
        uploader.upload();
        sh.log("resume complete");
    }

    private static void show(String[] args) throws ParseException, IOException {
        OptionsBuilder.buildShowOption(args);
        String cmd = DshipContext.INSTANCE.get("show-command");
        String sid = DshipContext.INSTANCE.get("session-id");
        if ("history".equals(cmd)) {
            int n = DshipContext.INSTANCE.get("number") == null ? 20 : Integer.valueOf(DshipContext.INSTANCE.get("number"));
            SessionHistoryManager.showHistory(n);
        } else if ("log".equals(cmd)) {
            SessionHistory sh;
            Util.checkSession(sid);
            SessionHistory sessionHistory = sh = sid == null ? SessionHistoryManager.getLatestSilently() : SessionHistoryManager.createSessionHistory(sid);
            if (sh != null) {
                sh.showLog();
            } else {
                DShip.logWarning("previous session not found.");
            }
        } else if ("bad".equals(cmd)) {
            SessionHistory sh;
            Util.checkSession(sid);
            SessionHistory sessionHistory = sh = sid == null ? SessionHistoryManager.getLatestSilently() : SessionHistoryManager.createSessionHistory(sid);
            if (sh != null) {
                sh.showBad();
            } else {
                DShip.logWarning("previous session not found.");
            }
        } else {
            throw new ParseException("Unknown command: '" + cmd + "'\nType 'tunnel help show' for usage.");
        }
    }

    private static void purge(String[] args) throws ParseException, IOException {
        OptionsBuilder.buildPurgeOption(args);
        int n = Integer.valueOf(DshipContext.INSTANCE.get("purge-number"));
        SessionHistoryManager.purgeHistory(n);
    }

    private static void help(String[] args) throws ParseException, IOException {
        OptionsBuilder.buildHelpOption(args);
        String cmd = DshipContext.INSTANCE.get("help-subcommand");
        if (DshipContext.INSTANCE.get("help-subcommand") == null) {
            cmd = "help";
        }
        HelpFormatter formatter = new HelpFormatter();
        formatter.setLongOptPrefix("-");
        CommandType type = CommandType.fromString(cmd);
        switch (type) {
            case upload: {
                formatter.printHelp("tunnel upload [options] <path> <[project.]table[/partition]>\n\tupload data from local file", OptionsBuilder.getUploadOptions());
                DShip.showHelp("upload.txt");
                break;
            }
            case download: {
                formatter.printHelp("tunnel download [options] <[project.]table[/partition]> <path>\n\tdownload data to local file", OptionsBuilder.getDownloadOptions());
                formatter.printHelp("tunnel download [options] instance://<[project/]instance_id> <path>\n\tdownload instance result to local file", OptionsBuilder.getDownloadOptions());
                DShip.showHelp("download.txt");
                break;
            }
            case upsert: {
                formatter.printHelp("tunnel upsert [options] <path> <[project.]table[/partition]>\n\tupsert data from local file", OptionsBuilder.getUpsertOptions());
                DShip.showHelp("upsert.txt");
                break;
            }
            case resume: {
                formatter.printHelp("tunnel resume [session_id] [-force]\n\tresume an upload session", OptionsBuilder.getResumeOptions());
                DShip.showHelp("resume.txt");
                break;
            }
            case show: {
                formatter.printHelp("tunnel show history [options]\n\tshow session information", OptionsBuilder.getShowOptions());
                DShip.showHelp("show.txt");
                break;
            }
            case purge: {
                formatter.printHelp("tunnel purge [n]\n\tforce session history to be purged.([n] days before, default 3 days)", OptionsBuilder.getPurgeOptions());
                DShip.showHelp("purge.txt");
                break;
            }
            case help: {
                DShip.showHelp("help.txt");
                break;
            }
        }
    }

    private static void logException(String sid, Exception e) {
        DShip.logExceptionWithCause(sid, "", e);
    }

    private static void logWarning(String message) {
        System.err.println(message);
    }

    private static void logExceptionWithCause(String sid, String cause, Exception e) {
        DShip.logWarning(cause + e.getMessage());
        if (sid == null) {
            sid = ".sidnull";
        }
        try {
            SessionHistory sh = SessionHistoryManager.createSessionHistory(sid);
            sh.log(Util.getStack(e));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void showHelp(String filename) throws IOException {
        InputStream ins = DShip.class.getResourceAsStream("/" + filename);
        try {
            InputStreamReader reader = new InputStreamReader(ins, "utf-8");
            int c = reader.read();
            while (c != -1) {
                System.out.print((char)c);
                c = reader.read();
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)ins);
        }
    }
}

