/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.graph.local.master;

import com.aliyun.odps.counter.Counter;
import com.aliyun.odps.counter.CounterGroup;
import com.aliyun.odps.counter.Counters;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.graph.Aggregator;
import com.aliyun.odps.graph.JobConf;
import com.aliyun.odps.graph.Partitioner;
import com.aliyun.odps.graph.VertexResolver;
import com.aliyun.odps.graph.local.COUNTER;
import com.aliyun.odps.graph.local.GraphTaskAttemptID;
import com.aliyun.odps.graph.local.InputSplit;
import com.aliyun.odps.graph.local.LocalVertexMutations;
import com.aliyun.odps.graph.local.RuntimeContext;
import com.aliyun.odps.graph.local.utils.LocalGraphRunUtils;
import com.aliyun.odps.graph.local.worker.Worker;
import com.aliyun.odps.graph.utils.VerifyUtils;
import com.aliyun.odps.io.Writable;
import com.aliyun.odps.io.WritableComparable;
import com.aliyun.odps.local.common.FileSplit;
import com.aliyun.odps.utils.ReflectionUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Master<VERTEX_ID extends WritableComparable<?>, VERTEX_VALUE extends Writable, EDGE_VALUE extends Writable, MESSAGE extends Writable, AGGR_INFO extends Writable, VALUE extends Writable> {
    private static Log LOG = LogFactory.getLog(Master.class);
    JobConf mJob;
    RuntimeContext mCtx;
    List<FileSplit> mInputs;
    Map<String, TableInfo> mOutputs;
    private Partitioner<VERTEX_ID> p;
    private List<AGGR_INFO> mLastAggregatorValues;
    int superStep = -1;
    int maxIteration;
    List<Worker> mWorkers = new ArrayList<Worker>();
    private Counters mCounters;
    int totalVertex = 0;
    int totalEdge = 0;

    public Master(JobConf job, RuntimeContext ctx, List<FileSplit> inputs, Map<String, TableInfo> outputs) throws Exception {
        this.mJob = job;
        this.mCtx = ctx;
        this.mInputs = inputs;
        this.mOutputs = outputs;
        this.mLastAggregatorValues = new ArrayList<AGGR_INFO>();
        this.mCounters = ctx.getCounters();
        this.init();
    }

    private void init() throws InstantiationException, IllegalAccessException, IOException, ClassNotFoundException, NoSuchFieldException {
        VerifyUtils.verifyGraphConf((JobConf)this.mJob);
        ReflectionUtils.setField((Object)this.mJob, (String)"state", (Object)JobConf.JobState.RUNNING);
        this.maxIteration = this.mJob.getMaxIteration();
        int usrWorkerNum = this.mJob.getNumWorkers();
        int workerNum = this.mInputs.size() < usrWorkerNum ? usrWorkerNum : this.mInputs.size();
        LOG.info((Object)("worker num :" + workerNum));
        this.p = LocalGraphRunUtils.createPartitioner(this.mJob);
        for (int workerCount = 0; workerCount < workerNum; ++workerCount) {
            FileSplit input = null;
            if (workerCount < this.mInputs.size()) {
                input = this.mInputs.get(workerCount);
            }
            InputSplit inputSplit = null;
            inputSplit = input != null && input != FileSplit.NullSplit ? (InputSplit)input : InputSplit.NullSplit;
            GraphTaskAttemptID taskAttemptID = new GraphTaskAttemptID(this.mCtx.getJobId(), workerCount, 0);
            Worker w = new Worker(this.mJob, this.mCtx, this, taskAttemptID, workerCount, workerNum, inputSplit, this.mOutputs);
            this.mWorkers.add(w);
        }
        this.initCounters();
    }

    private void initCounters() {
        this.mCounters.findCounter((Enum)COUNTER.TASK_INPUT_BYTE);
        this.mCounters.findCounter((Enum)COUNTER.TASK_INPUT_RECORD);
        this.mCounters.findCounter((Enum)COUNTER.TASK_OUTPUT_BYTE);
        this.mCounters.findCounter((Enum)COUNTER.TASK_OUTPUT_RECORD);
    }

    private void initGraph() throws IOException {
        for (Worker w : this.mWorkers) {
            w.loadGraph();
        }
        VertexResolver vertexResolver = LocalGraphRunUtils.createLoadingVertexResolver(this.mJob);
        this.processMutations(vertexResolver);
        if (this.totalVertex == 0) {
            throw new IOException("ODPS-0730001: No vertices in the graph, exiting.");
        }
    }

    private void processMutations(VertexResolver vertexResolver) throws IOException {
        for (Worker worker : this.mWorkers) {
            worker.processWorkerMutations(vertexResolver);
        }
        this.totalVertex = 0;
        this.totalEdge = 0;
        for (Worker w : this.mWorkers) {
            this.totalVertex = (int)((long)this.totalVertex + w.getVertexNumber());
            this.totalEdge = (int)((long)this.totalEdge + w.getEgeNumber());
        }
        for (Worker w : this.mWorkers) {
            w.setTotalNumVerticesAndEdges(this.totalVertex, this.totalEdge);
        }
    }

    private void WorkerSetup() throws IOException {
        this.initGraph();
        for (Worker w : this.mWorkers) {
            w.init();
        }
    }

    private boolean Aggregate() throws IOException {
        List<Aggregator> aggregators = LocalGraphRunUtils.getAggregator(this.mJob);
        if (aggregators.size() > 0) {
            int i;
            boolean terminate = false;
            List<Writable> totalAggregatorValue = null;
            for (i = 0; i < this.mWorkers.size(); ++i) {
                List<Writable> partialValue = this.mWorkers.get(i).partialAggregate();
                if (i == 0) {
                    totalAggregatorValue = partialValue;
                    continue;
                }
                for (int j = 0; j < partialValue.size(); ++j) {
                    aggregators.get(j).merge(totalAggregatorValue.get(j), partialValue.get(j));
                }
            }
            for (i = 0; i < totalAggregatorValue.size(); ++i) {
                terminate |= aggregators.get(i).terminate(this.mWorkers.get(0).getTaskContext(), totalAggregatorValue.get(i));
            }
            this.mLastAggregatorValues = totalAggregatorValue;
            for (i = 0; i < this.mWorkers.size(); ++i) {
                this.mWorkers.get(i).setLastAggregatedValue(this.mLastAggregatorValues);
            }
            return terminate;
        }
        return false;
    }

    private void close() throws IOException {
        for (Worker w : this.mWorkers) {
            for (CounterGroup cg : w.getCounters()) {
                for (Counter c : cg) {
                    this.mCounters.findCounter(cg.getName(), c.getDisplayName()).increment(c.getValue());
                }
            }
        }
        FileUtils.writeStringToFile((File)new File(this.mCtx.getCounterDir(), this.mCtx.getJobId()), (String)this.mCounters.toString());
        LOG.debug((Object)this.mCounters.toString());
        System.out.println(this.mCounters.toString());
    }

    public void run() throws IOException {
        this.WorkerSetup();
        while (this.maxIteration < 0 || this.superStep + 1 < this.maxIteration) {
            boolean allVoltHalt = true;
            for (Worker w : this.mWorkers) {
                allVoltHalt = allVoltHalt && w.allVertexVoltHalt();
            }
            if (allVoltHalt) break;
            LOG.debug((Object)("master super step " + (this.superStep + 1)));
            this.processMutations(LocalGraphRunUtils.createSuperstepVertexResolver(this.mJob));
            ++this.superStep;
            for (Worker w : this.mWorkers) {
                w.processNextStep();
            }
            for (Worker w : this.mWorkers) {
                w.Compute();
            }
            if (!this.Aggregate()) continue;
            break;
        }
        for (Worker w : this.mWorkers) {
            w.cleanup();
        }
        for (Worker w : this.mWorkers) {
            w.close();
        }
        this.close();
    }

    private Worker getWorkerByVertexID(VERTEX_ID vertex_id) {
        int worker_id = this.p.getPartition(vertex_id, this.mWorkers.size());
        return this.mWorkers.get(worker_id);
    }

    public long getSuperStep() {
        return this.superStep;
    }

    public LocalVertexMutations getVertexMutations(VERTEX_ID id) {
        return this.getWorkerByVertexID(id).getVertexMutations(id);
    }

    public void pushMsg(RuntimeContext context, long superStep, VERTEX_ID vertexId, Writable msg) {
        this.getWorkerByVertexID(vertexId).pushMsg(context, superStep, (WritableComparable<?>)vertexId, msg);
    }
}

