/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.udf.local.datasource;

import com.aliyun.odps.Column;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.local.common.WareHouse;
import com.aliyun.odps.local.common.utils.PartitionUtils;
import com.aliyun.odps.udf.UDTFCollector;
import com.aliyun.odps.udf.local.LocalRunError;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;

public class UDTFTableCollector
implements UDTFCollector {
    PrintWriter pw;
    Column[] schema;

    public UDTFTableCollector(String project, String table, String[] partitions) throws IOException {
        PartitionSpec partitionSpec = null;
        if (partitions != null && partitions.length > 0) {
            partitionSpec = new PartitionSpec();
            for (String p : partitions) {
                String[] kv = p.split("=");
                if (kv.length != 2) {
                    throw new LocalRunError("Invalid partition:" + p + " of table " + project + "." + table);
                }
                partitionSpec.set(kv[0], kv[1]);
            }
        }
        WareHouse wareHouse = WareHouse.getInstance();
        if (partitions != null) {
            if (!wareHouse.existsPartition(project, table, partitionSpec)) {
                throw new LocalRunError("partition " + project + "." + table + "(" + PartitionUtils.toString((PartitionSpec)partitionSpec) + ") not exists");
            }
            File partitionDir = wareHouse.getPartitionDir(project, table, partitionSpec);
            this.pw = new PrintWriter(new File(partitionDir, "data"));
        } else {
            if (!wareHouse.existsTable(project, table)) {
                throw new LocalRunError("output table:" + project + "." + table + " not exists");
            }
            File tableDir = wareHouse.getTableDir(project, table);
            this.pw = new PrintWriter(new File(tableDir, "data"));
        }
        this.schema = wareHouse.getTableMeta(project, table).getCols();
    }

    public void collect(Object[] args) {
    }
}

