/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.local.common;

import com.aliyun.odps.Column;
import com.aliyun.odps.Table;
import com.aliyun.odps.utils.StringUtils;
import java.util.Arrays;
import java.util.List;

public class TableMeta {
    private String projName;
    private String tableName;
    private Column[] cols;
    private Column[] partitions;

    public TableMeta(String projName, String tableName, Column[] cols) {
        this.projName = projName;
        this.tableName = tableName;
        this.cols = cols;
    }

    public TableMeta(String projName, String tableName, Column[] cols, Column[] partitions) {
        this.projName = projName;
        this.tableName = tableName;
        this.cols = cols;
        if (partitions != null && partitions.length > 0) {
            this.partitions = partitions;
        }
    }

    public String getProjName() {
        return this.projName;
    }

    public void setProjName(String projName) {
        this.projName = projName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Column[] getCols() {
        return this.cols;
    }

    public void setCols(Column[] cols) {
        this.cols = cols;
    }

    public Column[] getPartitions() {
        return this.partitions;
    }

    public void setPartitions(Column[] partitions) {
        this.partitions = partitions;
    }

    public static TableMeta fromTable(Table table) {
        String projectName = table.getProject();
        String tableName = table.getName();
        List cols = table.getSchema().getColumns();
        List partitions = table.getSchema().getPartitionColumns();
        if (partitions == null || partitions.size() == 0) {
            return new TableMeta(projectName, tableName, cols.toArray(new Column[cols.size()]));
        }
        return new TableMeta(projectName, tableName, cols.toArray(new Column[cols.size()]), partitions.toArray(new Column[partitions.size()]));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TableMeta) {
            boolean ret;
            TableMeta that = (TableMeta)obj;
            boolean bl = ret = StringUtils.equals((String)this.projName, (String)that.projName) && StringUtils.equals((String)this.tableName, (String)that.tableName);
            if (ret) {
                ret = Arrays.equals(this.cols, that.cols);
            }
            if (ret) {
                if (this.partitions != null && that.partitions != null) {
                    ret = Arrays.equals(this.partitions, that.partitions);
                } else if (this.partitions != null || that.partitions != null) {
                    return false;
                }
            }
            return ret;
        }
        return false;
    }
}

