/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.open.example;

import com.aliyun.odps.counter.Counter;
import com.aliyun.odps.counter.Counters;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.mapred.JobClient;
import com.aliyun.odps.mapred.Mapper;
import com.aliyun.odps.mapred.MapperBase;
import com.aliyun.odps.mapred.Reducer;
import com.aliyun.odps.mapred.ReducerBase;
import com.aliyun.odps.mapred.RunningJob;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.utils.InputUtils;
import com.aliyun.odps.mapred.utils.OutputUtils;
import com.aliyun.odps.mapred.utils.SchemaUtils;
import java.io.IOException;
import java.util.Iterator;

public class UserDefinedCounters {
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: TestUserDefinedCounters <in_table> <out_table>");
            System.exit(2);
        }
        JobConf job = new JobConf();
        job.setMapperClass(TokenizerMapper.class);
        job.setReducerClass(SumReducer.class);
        job.setMapOutputKeySchema(SchemaUtils.fromString((String)"word:string"));
        job.setMapOutputValueSchema(SchemaUtils.fromString((String)"count:bigint"));
        InputUtils.addTable((TableInfo)TableInfo.builder().tableName(args[0]).build(), (JobConf)job);
        OutputUtils.addTable((TableInfo)TableInfo.builder().tableName(args[1]).build(), (JobConf)job);
        RunningJob rJob = JobClient.runJob((JobConf)job);
        Counters counters = rJob.getCounters();
        long m = counters.findCounter((Enum)MyCounter.MAP_TASKS).getValue();
        long r = counters.findCounter((Enum)MyCounter.REDUCE_TASKS).getValue();
        long total = counters.findCounter((Enum)MyCounter.TOTAL_TASKS).getValue();
        System.exit(0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SumReducer
    extends ReducerBase {
        private Record result = null;

        public void setup(Reducer.TaskContext context) throws IOException {
            this.result = context.createOutputRecord();
            Counter reduce_tasks = context.getCounter((Enum)MyCounter.REDUCE_TASKS);
            Counter total_tasks = context.getCounter((Enum)MyCounter.TOTAL_TASKS);
            reduce_tasks.increment(1L);
            total_tasks.increment(1L);
        }

        public void reduce(Record key, Iterator<Record> values, Reducer.TaskContext context) throws IOException {
            long count = 0L;
            while (values.hasNext()) {
                Record val = values.next();
                count += ((Long)val.get(0)).longValue();
            }
            this.result.set(0, key.get(0));
            this.result.set(1, (Object)count);
            context.write(this.result);
        }
    }

    public static class TokenizerMapper
    extends MapperBase {
        private Record word;
        private Record one;

        public void setup(Mapper.TaskContext context) throws IOException {
            super.setup(context);
            Counter map_tasks = context.getCounter((Enum)MyCounter.MAP_TASKS);
            Counter total_tasks = context.getCounter((Enum)MyCounter.TOTAL_TASKS);
            map_tasks.increment(1L);
            total_tasks.increment(1L);
            this.word = context.createMapOutputKeyRecord();
            this.one = context.createMapOutputValueRecord();
            this.one.set(new Object[]{1L});
        }

        public void map(long recordNum, Record record, Mapper.TaskContext context) throws IOException {
            for (int i = 0; i < record.getColumnCount(); ++i) {
                this.word.set(new Object[]{record.get(i).toString()});
                context.write(this.word, this.one);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MyCounter {
        TOTAL_TASKS,
        MAP_TASKS,
        REDUCE_TASKS;

    }
}

