/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.open.example;

import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.mapred.JobClient;
import com.aliyun.odps.mapred.Mapper;
import com.aliyun.odps.mapred.MapperBase;
import com.aliyun.odps.mapred.RunningJob;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.utils.InputUtils;
import com.aliyun.odps.mapred.utils.OutputUtils;
import com.aliyun.odps.mapred.utils.SchemaUtils;
import java.io.IOException;
import java.util.Iterator;

public class MultiJobs {
    public static void main(String[] args) throws Exception {
        RunningJob rJob;
        if (args.length != 1) {
            System.err.println("Usage: TestMultiJobs <table>");
            System.exit(1);
        }
        String tbl = args[0];
        long iterCount = 2L;
        System.err.println("Start to run init job.");
        JobConf initJob = new JobConf();
        initJob.setLong("multijobs.value", iterCount);
        initJob.setMapperClass(InitMapper.class);
        InputUtils.addTable((TableInfo)TableInfo.builder().tableName("mr_empty").build(), (JobConf)initJob);
        OutputUtils.addTable((TableInfo)TableInfo.builder().tableName(tbl).build(), (JobConf)initJob);
        initJob.setMapOutputKeySchema(SchemaUtils.fromString((String)"key:string"));
        initJob.setMapOutputValueSchema(SchemaUtils.fromString((String)"value:string"));
        initJob.setNumReduceTasks(0);
        JobClient.runJob((JobConf)initJob);
        do {
            System.err.println("Start to run iter job, count: " + iterCount);
            JobConf decJob = new JobConf();
            decJob.setLong("multijobs.expect.value", iterCount);
            decJob.setMapperClass(DecreaseMapper.class);
            InputUtils.addTable((TableInfo)TableInfo.builder().tableName("mr_empty").build(), (JobConf)decJob);
            OutputUtils.addTable((TableInfo)TableInfo.builder().tableName(tbl).build(), (JobConf)decJob);
            decJob.setNumReduceTasks(0);
            rJob = JobClient.runJob((JobConf)decJob);
            --iterCount;
        } while (rJob.getCounters().findCounter("multijobs", "value").getValue() != 0L);
        if (iterCount != 0L) {
            throw new IOException("Job failed.");
        }
    }

    public static class DecreaseMapper
    extends MapperBase {
        public void cleanup(Mapper.TaskContext context) throws IOException {
            long expect = context.getJobConf().getLong("multijobs.expect.value", -1L);
            long v = -1L;
            int count = 0;
            Iterator iter = context.readResourceTable("multijobs_res_table");
            while (iter.hasNext()) {
                Record r = (Record)iter.next();
                v = (Long)r.get(0);
                if (expect != v) {
                    throw new IOException("expect: " + expect + ", but: " + v);
                }
                ++count;
            }
            if (count != 1) {
                throw new IOException("res_table should have 1 record, but: " + count);
            }
            Record record = context.createOutputRecord();
            record.set(0, (Object)(--v));
            context.write(record);
            context.getCounter("multijobs", "value").setValue(v);
        }
    }

    public static class InitMapper
    extends MapperBase {
        public void setup(Mapper.TaskContext context) throws IOException {
            Record record = context.createOutputRecord();
            long v = context.getJobConf().getLong("multijobs.value", 2L);
            record.set(0, (Object)v);
            context.write(record);
        }
    }
}

