/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.open.example;

import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.mapred.JobClient;
import com.aliyun.odps.mapred.Mapper;
import com.aliyun.odps.mapred.MapperBase;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.utils.InputUtils;
import com.aliyun.odps.mapred.utils.OutputUtils;
import java.io.IOException;

public class MapOnly {
    public static void main(String[] args) throws Exception {
        if (args.length != 2 && args.length != 3) {
            System.err.println("Usage: OnlyMapper <in_table> <out_table> [setup|map|cleanup]");
            System.exit(2);
        }
        JobConf job = new JobConf();
        job.setMapperClass(MapperClass.class);
        job.setNumReduceTasks(0);
        InputUtils.addTable((TableInfo)TableInfo.builder().tableName(args[0]).build(), (JobConf)job);
        OutputUtils.addTable((TableInfo)TableInfo.builder().tableName(args[1]).build(), (JobConf)job);
        if (args.length == 3) {
            String options = new String(args[2]);
            if (options.contains("setup")) {
                job.setBoolean("option.mapper.setup", true);
            }
            if (options.contains("map")) {
                job.setBoolean("option.mapper.map", true);
            }
            if (options.contains("cleanup")) {
                job.setBoolean("option.mapper.cleanup", true);
            }
        }
        JobClient.runJob((JobConf)job);
    }

    public static class MapperClass
    extends MapperBase {
        public void setup(Mapper.TaskContext context) throws IOException {
            boolean is = context.getJobConf().getBoolean("option.mapper.setup", false);
            if (is) {
                Record result = context.createOutputRecord();
                result.set(0, (Object)"setup");
                result.set(1, (Object)1L);
                context.write(result);
            }
        }

        public void map(long key, Record record, Mapper.TaskContext context) throws IOException {
            boolean is = context.getJobConf().getBoolean("option.mapper.map", false);
            if (is) {
                Record result = context.createOutputRecord();
                result.set(0, record.get(0));
                result.set(1, (Object)1L);
                context.write(result);
            }
        }

        public void cleanup(Mapper.TaskContext context) throws IOException {
            boolean is = context.getJobConf().getBoolean("option.mapper.cleanup", false);
            if (is) {
                Record result = context.createOutputRecord();
                result.set(0, (Object)"cleanup");
                result.set(1, (Object)1L);
                context.write(result);
            }
        }
    }
}

