/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.graph.utils;

import com.aliyun.odps.graph.Combiner;
import com.aliyun.odps.graph.Edge;
import com.aliyun.odps.graph.GraphLoader;
import com.aliyun.odps.graph.JobConf;
import com.aliyun.odps.graph.Partitioner;
import com.aliyun.odps.graph.Vertex;
import com.aliyun.odps.graph.WorkerComputer;
import com.aliyun.odps.io.Writable;
import com.aliyun.odps.io.WritableComparable;
import com.aliyun.odps.utils.ReflectionUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;

public class VerifyUtils {
    private static Class<? extends Vertex> vertexClass;
    private static Class<? extends WritableComparable> vertexIdClass;
    private static Class<? extends Writable> vertexValueClass;
    private static Class<? extends Writable> edgeValueClass;
    private static Class<? extends Writable> messageValueClass;
    private static String udfPropertiesClassName;

    private static void verifyPartitioner(JobConf jobConf, Type vertexIdType) {
        Class<? extends Partitioner> partitionerClass = jobConf.getPartitionerClass();
        if (partitionerClass != null) {
            List partitionerClassList = ReflectionUtils.getTypeArguments(Partitioner.class, partitionerClass);
            if (!((Class)partitionerClassList.get(0)).equals(vertexIdType)) {
                throw new RuntimeException("ODPS-0730001: Vertex id generic type of partitioner class and vertex class not match, former is " + ReflectionUtils.getClass((Type)((Type)partitionerClassList.get(0))) + ", the later is " + ReflectionUtils.getClass((Type)vertexIdType));
            }
        } else {
            String partitionerClassStr = jobConf.get("odps.graph.partitioner.class");
            if (partitionerClassStr != null) {
                throw new RuntimeException("ODPS-0730001: Partition class " + partitionerClassStr + " not found");
            }
        }
    }

    private static void verifyCombiner(JobConf jobConf, Type vertexIdType, Type messageValueType) {
        Class<? extends Combiner> combinerClass = jobConf.getCombinerClass();
        if (combinerClass != null) {
            List combinerClassList = ReflectionUtils.getTypeArguments(Combiner.class, combinerClass);
            if (combinerClassList.size() != 2) {
                throw new RuntimeException("ODPS-0730001: combiner " + combinerClass + " should have 2 generic types for vertex id and message value");
            }
            if (!((Class)combinerClassList.get(0)).equals(vertexIdType)) {
                throw new RuntimeException("ODPS-0730001: Vertex id generic type of combiner class and vertex class not match, former is " + ReflectionUtils.getClass((Type)((Type)combinerClassList.get(0))) + ", the later is " + ReflectionUtils.getClass((Type)vertexIdType));
            }
            if (!((Class)combinerClassList.get(1)).equals(messageValueType)) {
                throw new RuntimeException("ODPS-0730001: Message value generic type of combiner class and vertex class not match, former is " + ReflectionUtils.getClass((Type)((Type)combinerClassList.get(1))) + ", the later is " + ReflectionUtils.getClass((Type)messageValueType));
            }
        } else {
            String combinerClassStr = jobConf.get("odps.graph.combiner.class");
            if (combinerClassStr != null) {
                throw new RuntimeException("ODPS-0730001: Combiner class " + combinerClassStr + " not found");
            }
        }
    }

    public static void verifyGraphConf(JobConf jobConf) {
        vertexClass = jobConf.getVertexClass();
        if (vertexClass == null) {
            throw new RuntimeException("ODPS-0730001: Vertex class not set");
        }
        Class<? extends GraphLoader> loaderClass = jobConf.getGraphLoaderClass();
        if (loaderClass == null) {
            throw new RuntimeException("ODPS-0730001: GraphLoader class not set");
        }
        List vertexTypeClassList = ReflectionUtils.getTypeArguments(Vertex.class, vertexClass);
        List graphLoaderTypeClassList = ReflectionUtils.getTypeArguments(GraphLoader.class, loaderClass);
        Type vertexIdType = (Type)vertexTypeClassList.get(0);
        Type vertexValueType = (Type)vertexTypeClassList.get(1);
        Type edgeValueType = (Type)vertexTypeClassList.get(2);
        Type messageValueType = (Type)vertexTypeClassList.get(3);
        vertexIdClass = ReflectionUtils.getClass((Type)vertexIdType);
        vertexValueClass = ReflectionUtils.getClass((Type)vertexValueType);
        edgeValueClass = ReflectionUtils.getClass((Type)edgeValueType);
        messageValueClass = ReflectionUtils.getClass((Type)messageValueType);
        String format = "ODPS-0730001: %s generic type of GraphLoader class and vertex class not match, former is %s, the later is %s.";
        String errMsg = null;
        if (!((Class)graphLoaderTypeClassList.get(0)).equals(vertexIdType)) {
            errMsg = String.format(format, "Vertex id", ReflectionUtils.getClass((Type)((Type)graphLoaderTypeClassList.get(0))), vertexIdClass);
        } else if (!((Class)graphLoaderTypeClassList.get(1)).equals(vertexValueType)) {
            errMsg = String.format(format, "Vertex value", ReflectionUtils.getClass((Type)((Type)graphLoaderTypeClassList.get(1))), vertexValueClass);
        } else if (!((Class)graphLoaderTypeClassList.get(2)).equals(edgeValueType)) {
            errMsg = String.format(format, "Edge value", ReflectionUtils.getClass((Type)((Type)graphLoaderTypeClassList.get(2))), edgeValueClass);
        } else if (!((Class)graphLoaderTypeClassList.get(3)).equals(messageValueType)) {
            errMsg = String.format(format, "Message value", ReflectionUtils.getClass((Type)((Type)graphLoaderTypeClassList.get(3))), messageValueClass);
        }
        if (errMsg != null) {
            throw new RuntimeException(errMsg);
        }
        VerifyUtils.verifyPartitioner(jobConf, vertexIdType);
        VerifyUtils.verifyCombiner(jobConf, vertexIdType, messageValueType);
        ReflectionUtils.findDeclaredMethod(vertexIdClass, (String)"hashCode");
        ReflectionUtils.findDeclaredMethod(vertexIdClass, (String)"equals");
        if (!vertexClass.getName().equals("com.aliyun.odps.graph.udf.UDFVertexImpl")) {
            ReflectionUtils.checkNonStaticField(vertexClass, Vertex.class);
        }
        Class<? extends WorkerComputer> workerComputerClass = jobConf.getWorkerComputerClass();
        ReflectionUtils.checkNonStaticField(workerComputerClass, WorkerComputer.class);
        jobConf.setClass("odps.graph.vertex.id.class", vertexIdClass, WritableComparable.class);
        jobConf.setClass("odps.graph.vertex.value.class", vertexValueClass, Writable.class);
        jobConf.setClass("odps.graph.edge.value.class", edgeValueClass, Writable.class);
        jobConf.setClass("odps.graph.message.value.class", messageValueClass, Writable.class);
    }

    public static void verifyVertexId(WritableComparable id) throws IOException {
        if (id == null) {
            throw new IOException("ODPS-0730001: Vertex id is null");
        }
        if (id.getClass() != vertexIdClass) {
            throw new IOException("ODPS-0730001: Vertex id type error, expect '" + vertexIdClass + "', but '" + id.getClass() + "'");
        }
    }

    public static void verifyVertexValue(Writable value) throws IOException {
        if (value != null) {
            String propertiesClassName = "com.aliyun.odps.graph.udf.UDFPropertiesImpl";
            if (value.getClass() != vertexValueClass && !value.getClass().getName().equals(udfPropertiesClassName)) {
                throw new IOException("ODPS-0730001: Vertex value type of error, expect '" + vertexValueClass + "', but '" + value.getClass() + "'");
            }
        }
    }

    public static void verifyVertexEdge(Edge edge) throws IOException {
        if (edge == null) {
            throw new IOException("ODPS-0730001: Edge is null");
        }
        Object destVertexId = edge.getDestVertexId();
        if (destVertexId == null) {
            throw new IOException("ODPS-0730001: DestVertexId of " + edge.toString() + " is null");
        }
        if (destVertexId.getClass() != vertexIdClass) {
            throw new IOException("ODPS-0730001: Dest vertex id type of " + edge + " error, expect '" + vertexIdClass + "', but '" + destVertexId.getClass() + "'");
        }
        Object edgeValue = edge.getValue();
        if (edgeValue != null && edgeValue.getClass() != edgeValueClass && !edgeValue.getClass().getName().equals(udfPropertiesClassName)) {
            throw new IOException("ODPS-0730001: Edge value type of " + edge + " error, expect '" + edgeValueClass + "', but '" + edgeValue.getClass() + "'");
        }
    }

    public static void verifyVertex(Vertex vertex) throws IOException {
        if (vertex == null) {
            throw new IOException("ODPS-0730001: Vertex is null");
        }
        if (vertex.getClass() != vertexClass) {
            throw new IOException("ODPS-0730001: Vertex type of " + vertex + " error, expect '" + vertexClass + "', but '" + vertex.getClass() + "'");
        }
        try {
            VerifyUtils.verifyVertexId(vertex.getId());
            VerifyUtils.verifyVertexValue(vertex.getValue());
            if (vertex.hasEdges()) {
                for (Edge edge : vertex.getEdges()) {
                    VerifyUtils.verifyVertexEdge(edge);
                }
            }
        }
        catch (IOException e) {
            throw new IOException(e.getMessage() + ", from " + vertex.toString());
        }
    }

    static {
        udfPropertiesClassName = "com.aliyun.odps.graph.udf.UDFPropertiesImpl";
    }
}

