/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.graph.utils;

import com.aliyun.odps.Instance;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.counter.Counters;
import com.aliyun.odps.graph.counters.MemoryCounter;
import com.aliyun.odps.graph.counters.StatsCounter;
import com.aliyun.odps.utils.StringUtils;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Map;
import java.util.Set;

public class LogUtils {
    public static void showSummary(Instance.TaskSummary ts) {
        if (!StringUtils.isNullOrEmpty((String)ts.getSummaryText())) {
            System.err.println("Summary:");
            System.err.println(ts.getSummaryText());
        }
    }

    public static void fillCountersAndShowSummary(Instance.TaskSummary ts, Counters counters) throws OdpsException {
        String summary = ts.toString();
        if (!StringUtils.isNullOrEmpty((String)summary)) {
            Set groups = ts.entrySet();
            for (Map.Entry entry : groups) {
                String group = (String)entry.getKey();
                if (!(entry.getValue() instanceof Map)) continue;
                Map groupValues = (Map)entry.getValue();
                for (Map.Entry counterItem : groupValues.entrySet()) {
                    String counterName = (String)counterItem.getKey();
                    Object counterRawValue = counterItem.getValue();
                    long counterValue = 0L;
                    if (counterRawValue instanceof Integer) {
                        counterValue = ((Integer)counterRawValue).longValue();
                    } else if (counterRawValue instanceof Long) {
                        counterValue = (Long)counterRawValue;
                    } else if (counterRawValue instanceof BigInteger) {
                        counterValue = ((BigInteger)counterRawValue).longValue();
                    } else {
                        throw new OdpsException("Invalid counter value type: " + counterRawValue.getClass());
                    }
                    counters.findCounter(group, counterName).setValue(counterValue);
                }
            }
            LogUtils.showSummary(ts);
        }
        if (counters.countCounters() == 0) {
            throw new OdpsException("Get task summary and counters failed");
        }
    }

    static void addIfExists(JsonObject group, String counterName, String key, StringBuilder progress) {
        if (group.has(counterName)) {
            progress.append(key + "=");
            String value = group.get(counterName).getAsString();
            if (counterName.equals(MemoryCounter.MAX_USED_MEMORY.toString())) {
                value = String.valueOf(Long.parseLong(value) / 1000000L) + "M";
            }
            progress.append(value);
            progress.append(",");
        }
    }

    public static String assembleProgress(Instance.TaskSummary ts) throws IOException {
        StringBuilder progress = new StringBuilder();
        if (ts == null) {
            return progress.toString();
        }
        JsonObject jsonSummary = new JsonParser().parse(ts.getJsonSummary()).getAsJsonObject();
        if (jsonSummary.has(StatsCounter.class.getName())) {
            JsonObject graphStats = jsonSummary.get(StatsCounter.class.getName()).getAsJsonObject();
            String name = StatsCounter.FINAL_STAGE.toString();
            GraphStage stage = GraphStage.values()[graphStats.get(name).getAsInt()];
            progress.append(stage.getName());
            if (stage.equals((Object)GraphStage.GRAPH_STAGE_SUPERSTEP) && graphStats.entrySet().size() > 1) {
                progress.append("\t[");
                LogUtils.addIfExists(graphStats, StatsCounter.TOTAL_SUPERSTEPS.toString(), "step", progress);
                LogUtils.addIfExists(graphStats, StatsCounter.TOTAL_VERTICES.toString(), "vertices", progress);
                LogUtils.addIfExists(graphStats, StatsCounter.TOTAL_EDGES.toString(), "edges", progress);
                LogUtils.addIfExists(graphStats, StatsCounter.TOTAL_HALTED_VERTICES.toString(), "halted", progress);
                LogUtils.addIfExists(graphStats, StatsCounter.TOTAL_SENT_MESSAGES.toString(), "messages", progress);
                LogUtils.addIfExists(graphStats, StatsCounter.TOTAL_WORKERS.toString(), "workers", progress);
                LogUtils.addIfExists(graphStats, StatsCounter.TOTAL_RUNNING_WORKERS.toString(), "running", progress);
                if (jsonSummary.has(MemoryCounter.class.getName())) {
                    LogUtils.addIfExists(jsonSummary.get(MemoryCounter.class.getName()).getAsJsonObject(), MemoryCounter.MAX_USED_MEMORY_WORKER.toString(), "max_mem_workerid", progress);
                    LogUtils.addIfExists(jsonSummary.get(MemoryCounter.class.getName()).getAsJsonObject(), MemoryCounter.MAX_USED_MEMORY.toString(), "max_mem", progress);
                }
                progress.deleteCharAt(progress.length() - 1);
                progress.append("]");
            } else if (stage.equals((Object)GraphStage.GRAPH_STAGE_WAIT_WORKER_UP) && graphStats.entrySet().size() > 1) {
                progress.append("\t");
                LogUtils.addIfExists(graphStats, StatsCounter.TOTAL_RUNNING_WORKERS.toString(), "running", progress);
                progress.deleteCharAt(progress.length() - 1);
            }
        }
        return progress.toString();
    }

    public static enum GraphStage {
        GRAPH_STAGE_WAIT_WORKER_UP("WAIT_WORKER_UP", 0),
        GRAPH_STAGE_INIT_NETWORK("INIT_NETWORK", 1),
        GRAPH_STAGE_LOAD("LOAD", 2),
        GRAPH_STAGE_SETUP("SETUP", 3),
        GRAPH_STAGE_SUPERSTEP("SUPERSTEP", 4),
        GRAPH_STAGE_CHECKPOINT("CHECKPOINT", 5),
        GRAPH_STAGE_FAILOVER("FAILOVER", 6),
        GRAPH_STAGE_CLEANUP("CLENAUP", 7),
        GRAPH_STAGE_FAIL("FAIL", 8),
        GRAPH_STAGE_TERMINATE("TERMINATE", 9),
        GRAPH_STAGE_WAIT_SUBMIT("WAIT_SUBMIT", 10),
        GRAPH_STAGE_WAIT_GET_RESULT("WAIT_GET_RESULT", 11);

        private String name;
        private int value;

        private GraphStage(String name, int value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public int getValue() {
            return this.value;
        }
    }
}

