/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.graph.utils;

import com.aliyun.odps.counter.Counter;
import com.aliyun.odps.counter.CounterGroup;
import com.aliyun.odps.counter.Counters;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Map;

public class CounterUtils {
    public static String toJsonString(Counters counters) {
        JsonObject js = CounterUtils.toJson(counters);
        return js.toString();
    }

    public static Counters createFromJsonString(String json) {
        JsonObject el = new JsonParser().parse(json).getAsJsonObject();
        return CounterUtils.createFromJson(el);
    }

    private static Counters createFromJson(JsonObject obj) {
        Counters counters = new Counters();
        for (Map.Entry entry : obj.entrySet()) {
            String key = (String)entry.getKey();
            CounterGroup group = counters.getGroup(key);
            CounterUtils.fromJson(group, ((JsonElement)entry.getValue()).getAsJsonObject());
        }
        return counters;
    }

    private static void fromJson(CounterGroup group, JsonObject obj) {
        JsonArray counterArray = obj.has("counters") ? obj.get("counters").getAsJsonArray() : new JsonArray();
        for (int i = 0; i < counterArray.size(); ++i) {
            JsonObject subObj = counterArray.get(i).getAsJsonObject();
            String counterName = subObj.has("name") ? subObj.get("name").getAsString() : null;
            Counter counter = group.findCounter(counterName);
            long value = subObj.has("value") ? subObj.get("value").getAsLong() : 0L;
            counter.increment(value);
        }
    }

    private static JsonObject toJson(Counters counters) {
        JsonObject obj = new JsonObject();
        for (CounterGroup group : counters) {
            obj.add(group.getName(), (JsonElement)CounterUtils.toJson(group));
        }
        return obj;
    }

    private static JsonObject toJson(CounterGroup counterGroup) {
        JsonObject obj = new JsonObject();
        obj.addProperty("name", counterGroup.getName());
        JsonArray counterArray = new JsonArray();
        for (Counter entry : counterGroup) {
            counterArray.add((JsonElement)CounterUtils.toJson(entry));
        }
        obj.add("counters", (JsonElement)counterArray);
        return obj;
    }

    private static JsonObject toJson(Counter counter) {
        JsonObject js = new JsonObject();
        js.addProperty("name", counter.getName());
        js.addProperty("value", (Number)counter.getValue());
        return js;
    }
}

