/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.graph;

import com.aliyun.odps.conf.Configuration;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.graph.Aggregator;
import com.aliyun.odps.graph.AggregatorOwnerPartitioner;
import com.aliyun.odps.graph.Combiner;
import com.aliyun.odps.graph.ComputingVertexResolver;
import com.aliyun.odps.graph.GraphLoader;
import com.aliyun.odps.graph.LoadingVertexResolver;
import com.aliyun.odps.graph.Partitioner;
import com.aliyun.odps.graph.Vertex;
import com.aliyun.odps.graph.VertexResolver;
import com.aliyun.odps.graph.WorkerComputer;
import com.aliyun.odps.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class JobConf
extends Configuration {
    protected JobState state = JobState.DEFINE;

    public JobConf() {
        this.initResources();
    }

    public JobConf(Configuration conf) {
        super(conf);
        if (!(conf instanceof JobConf)) {
            this.initResources();
        }
    }

    @Deprecated
    public JobConf(Configuration conf, JobState js) {
        this(conf);
        this.state = js;
    }

    @Deprecated
    public JobConf(String config) {
        this.addResource(config);
        this.initResources();
    }

    @Deprecated
    public JobConf(boolean loadDefaults) {
        super(loadDefaults);
        if (loadDefaults) {
            this.initResources();
        }
    }

    protected void ensureState(JobState state) throws IllegalStateException {
        if (state != this.state) {
            throw new IllegalStateException("ODPS-0730001: Job in state " + (Object)((Object)this.state) + " instead of " + (Object)((Object)state));
        }
    }

    protected void checkState(String name) {
        if (this.state == JobState.RUNNING) {
            String graph = "odps.graph";
            if (name.toLowerCase().startsWith(graph)) {
                throw new IllegalStateException("ODPS-0730001: Cann't set configuration " + name + " started with odps.graph when job in state " + (Object)((Object)this.state));
            }
        }
    }

    public void addCacheResources(String resourceNames) {
        this.appendProperties("odps.graph.cache.resources", resourceNames);
    }

    public void addCacheResourcesToClassPath(String resourceNames) {
        this.appendProperties("odps.graph.classpath.resources", resourceNames);
        this.appendProperties("odps.graph.cache.resources", resourceNames);
    }

    public void addInput(TableInfo tbl) throws IOException {
        this.addInput(tbl, tbl.getCols());
    }

    public void addInput(TableInfo tbl, String[] cols) throws IOException {
        tbl.validate();
        String inputDesc = this.get("odps.graph.input.desc", "[]");
        JsonArray array = new JsonParser().parse(inputDesc).getAsJsonArray();
        array.add((JsonElement)JobConf.toJson(tbl, cols));
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        this.set("odps.graph.input.desc", gson.toJson((JsonElement)array));
    }

    public void addOutput(TableInfo tbl) throws IOException {
        this.addOutput(tbl, true);
    }

    public void addOutput(TableInfo tbl, boolean overwrite) throws IOException {
        if (!tbl.getLabel().equals("__default__")) {
            this.processOutput(tbl, tbl.getLabel(), overwrite);
        } else {
            this.processOutput(tbl, null, overwrite);
        }
    }

    public void setJobPriority(int priority) {
        this.setInt("odps.graph.job.priority", priority);
    }

    public int getJobPriority() {
        int graphPriority = this.getInt("odps.graph.job.priority", 9);
        int instancePriority = this.getInt("odps.instance.priority", 9);
        if (graphPriority != 9) {
            return graphPriority;
        }
        return instancePriority;
    }

    public long getSplitSize() {
        return this.getLong("odps.graph.split.size", 64L);
    }

    public void setSplitSize(long size) {
        this.setLong("odps.graph.split.size", size);
    }

    public int getWorkerCPU() {
        return this.getInt("odps.graph.worker.cpu", 200);
    }

    public void setWorkerCPU(int cpu) {
        this.setInt("odps.graph.worker.cpu", cpu);
    }

    public void setWorkerMemory(int mem) {
        this.setInt("odps.graph.worker.memory", mem);
    }

    public int getWorkerMemory() {
        return this.getInt("odps.graph.worker.memory", 4096);
    }

    public void setLogLevel(String level) {
        if (level == null) {
            throw new RuntimeException("Job log level can't be null");
        }
        this.set("odps.graph.log.level", level);
    }

    public void setGraphLoaderClass(Class<? extends GraphLoader> cls) {
        this.setClass("odps.graph.loader.class", cls, GraphLoader.class);
    }

    public Class<? extends GraphLoader> getGraphLoaderClass() {
        return this.getClass("odps.graph.loader.class", null, GraphLoader.class);
    }

    public void setVertexClass(Class<? extends Vertex> cls) {
        this.setClass("odps.graph.vertex.class", cls, Vertex.class);
    }

    public Class<? extends Vertex> getVertexClass() {
        return this.getClass("odps.graph.vertex.class", null, Vertex.class);
    }

    public void setWorkerComputerClass(Class<? extends WorkerComputer> cls) {
        this.setClass("odps.graph.worker.computer.class", cls, WorkerComputer.class);
    }

    public Class<? extends WorkerComputer> getWorkerComputerClass() {
        return this.getClass("odps.graph.worker.computer.class", WorkerComputer.class, WorkerComputer.class);
    }

    public void setCombinerClass(Class<? extends Combiner> cls) {
        this.setClass("odps.graph.combiner.class", cls, Combiner.class);
    }

    public Class<? extends Combiner> getCombinerClass() {
        return this.getClass("odps.graph.combiner.class", null, Combiner.class);
    }

    public void setPartitionerClass(Class<? extends Partitioner> cls) {
        this.setClass("odps.graph.partitioner.class", cls, Partitioner.class);
    }

    public Class<? extends Partitioner> getPartitionerClass() {
        return this.getClass("odps.graph.partitioner.class", null, Partitioner.class);
    }

    public void setAggregatorClass(Class<? extends Aggregator> cls) {
        this.setAggregatorClass(new Class[]{cls});
    }

    public void setAggregatorClass(Class<? extends Aggregator> ... cls) {
        String classNames = "";
        for (Class<? extends Aggregator> cl : cls) {
            classNames = classNames + cl.getName() + ";";
        }
        this.set("odps.graph.aggregator.classes", classNames);
    }

    public void setAggregatorOwnerPartitionerClass(Class<? extends AggregatorOwnerPartitioner> cls) {
        this.setClass("odps.graph.aggregator.owner.partitioner.class", cls, AggregatorOwnerPartitioner.class);
    }

    public Class<? extends AggregatorOwnerPartitioner> getAggregatorOwnerPartitionerClass() {
        return this.getClass("odps.graph.aggregator.owner.partitioner.class", null, AggregatorOwnerPartitioner.class);
    }

    public void setUseTreeAggregator(boolean useTreeAggregator) {
        this.setBoolean("odps.graph.use.tree.aggregator", useTreeAggregator);
    }

    public boolean getUseTreeAggregator() {
        return this.getBoolean("odps.graph.use.tree.aggregator", false);
    }

    public void setAggregatorTreeDepth(int depth) {
        this.setInt("odps.graph.aggregator.tree.depth", depth);
    }

    public int getAggregatorTreeDepth() {
        return this.getInt("odps.graph.aggregator.tree.depth", 2);
    }

    public void setRuntimePartitioning(boolean runtimePartitioning) {
        this.setBoolean("odps.graph.runtime.partitioning", runtimePartitioning);
    }

    public boolean getRuntimePartitioning() {
        return this.getBoolean("odps.graph.runtime.partitioning", true);
    }

    public void setMaxIteration(int maxIteration) {
        this.setInt("odps.graph.max.iteration", maxIteration);
    }

    public int getMaxIteration() {
        return this.getInt("odps.graph.max.iteration", -1);
    }

    public void setLoadingVertexResolver(Class<? extends LoadingVertexResolver> cls) {
        this.setClass("odps.graph.loading.vertex.resolver.class", cls, LoadingVertexResolver.class);
    }

    @Deprecated
    public void setLoadingVertexResolverClass(Class<? extends VertexResolver> cls) {
        this.setClass("odps.graph.loading.vertex.resolver.class", cls, VertexResolver.class);
    }

    public Class<? extends VertexResolver> getLoadingVertexResolver() {
        return this.getClass("odps.graph.loading.vertex.resolver.class", null, LoadingVertexResolver.class);
    }

    @Deprecated
    public Class<? extends VertexResolver> getLoadingVertexResolverClass() {
        return this.getClass("odps.graph.loading.vertex.resolver.class", null, VertexResolver.class);
    }

    @Deprecated
    public void setComputingVertexResolverClass(Class<? extends VertexResolver> cls) {
        this.setClass("odps.graph.computing.vertex.resolver.class", cls, VertexResolver.class);
    }

    @Deprecated
    public Class<? extends VertexResolver> getComputingVertexResolverClass() {
        return this.getClass("odps.graph.computing.vertex.resolver.class", null, VertexResolver.class);
    }

    public void setComputingVertexResolver(Class<? extends ComputingVertexResolver> cls) {
        this.setClass("odps.graph.computing.vertex.resolver.class", cls, VertexResolver.class);
    }

    public Class<? extends ComputingVertexResolver> getComputingVertexResolver() {
        return this.getClass("odps.graph.computing.vertex.resolver.class", null, ComputingVertexResolver.class);
    }

    public void setCheckpointSuperstepFrequency(int frequency) {
        this.setInt("odps.graph.checkpoint.superstep.frequency", frequency);
    }

    public void setSyncBetweenResolveCompute(boolean is_sync) {
        this.setBoolean("odps.graph.sync.resolve.compute", is_sync);
    }

    public boolean getSyncBetweenResolveCompute() {
        return this.getBoolean("odps.graph.sync.resolve.compute", true);
    }

    public void setNumWorkers(int n) {
        this.setInt("odps.graph.worker.num", n);
    }

    public int getNumWorkers() {
        return this.getInt("odps.graph.worker.num", -1);
    }

    public void setMemoryThreshold(float threshold) {
        this.setFloat("odps.graph.spill.memory.threshold", threshold);
    }

    public float getMemoryThreshold() {
        return this.getFloat("odps.graph.spill.memory.threshold", 0.5f);
    }

    public void setUseDiskBackedMessage(boolean useDiskBackedMessage) {
        this.setBoolean("odps.graph.use.diskbacked.message", useDiskBackedMessage);
    }

    public boolean getUseDiskBackedMessage() {
        return this.getBoolean("odps.graph.use.diskbacked.message", false);
    }

    public void setUseDiskBackedMutation(boolean useDiskBackedMutation) {
        this.setBoolean("odps.graph.use.diskbacked.mutation", useDiskBackedMutation);
    }

    public boolean getUseDiskBackedMutation() {
        return this.getBoolean("odps.graph.use.diskbacked.mutation", false);
    }

    public void setBroadcastMessageEnable(boolean broadcastMessageEnable) {
        this.setBoolean("odps.graph.broadcast.message.enable", broadcastMessageEnable);
    }

    public boolean getBroadcastMessageEnable() {
        return this.getBoolean("odps.graph.broadcast.message.enable", false);
    }

    public void setUseMultipleInputOutput(boolean useMultipleInputOutput) {
        this.setBoolean("odps.graph.use.multiple.input.output", useMultipleInputOutput);
    }

    public boolean getUseMultipleInputOutput() {
        return this.getBoolean("odps.graph.use.multiple.input.output", false);
    }

    private void initResources() {
        String libjars;
        String resources = System.getProperty("odps.cache.resources");
        if (resources != null && !resources.trim().isEmpty()) {
            this.addCacheResources(resources);
        }
        if ((libjars = System.getProperty("odps.classpath.resources")) != null && !libjars.trim().isEmpty()) {
            this.addCacheResourcesToClassPath(libjars);
        }
    }

    private static JsonObject toJson(TableInfo tbl, String[] cols) {
        JsonObject obj = new JsonObject();
        String projectName = tbl.getProjectName();
        if (projectName == null) {
            projectName = "";
        }
        obj.addProperty("projName", projectName);
        obj.addProperty("tblName", tbl.getTableName());
        JsonArray array = new JsonArray();
        LinkedHashMap partSpec = tbl.getPartSpec();
        for (Map.Entry entry : partSpec.entrySet()) {
            String key = StringUtils.strip((String)((String)entry.getKey()), (String)"'\"");
            String value = StringUtils.strip((String)((String)entry.getValue()), (String)"'\"");
            array.add((JsonElement)new JsonPrimitive(key + "=" + value));
        }
        obj.add("partSpec", (JsonElement)array);
        obj.addProperty("cols", cols == null ? "" : StringUtils.join((Object[])cols, (char)','));
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        obj = new JsonParser().parse(gson.toJson((JsonElement)obj)).getAsJsonObject();
        return obj;
    }

    private void processOutput(TableInfo tbl, String label, boolean overwrite) {
        String outputDesc = this.get("odps.graph.output.desc", "[]");
        JsonArray array = new JsonParser().parse(outputDesc).getAsJsonArray();
        array.add((JsonElement)this.toJson(tbl, label, overwrite));
        this.set("odps.graph.output.desc", new GsonBuilder().disableHtmlEscaping().create().toJson((JsonElement)array));
    }

    private JsonObject toJson(TableInfo tbl, String label, boolean overwrite) {
        JsonObject obj = new JsonObject();
        String projectName = tbl.getProjectName();
        if (projectName == null) {
            projectName = "";
        }
        obj.addProperty("projName", projectName);
        obj.addProperty("tblName", tbl.getTableName());
        JsonArray array = new JsonArray();
        LinkedHashMap partSpec = tbl.getPartSpec();
        for (Map.Entry entry : partSpec.entrySet()) {
            array.add((JsonElement)new JsonPrimitive((String)entry.getKey() + "=" + (String)entry.getValue()));
        }
        obj.add("partSpec", (JsonElement)array);
        obj.addProperty("label", label == null ? "" : label);
        obj.addProperty("overwrite", Boolean.valueOf(overwrite));
        return obj;
    }

    private void appendProperties(String name, String value) {
        int i;
        String originalValue = this.get(name);
        if (originalValue == null || originalValue.length() == 0) {
            this.set(name, value);
            return;
        }
        String[] orginalValues = originalValue.split(",");
        String[] appendValues = value.split(",");
        HashSet<String> set = new HashSet<String>();
        for (i = 0; i < orginalValues.length; ++i) {
            set.add(orginalValues[i].trim());
        }
        for (i = 0; i < appendValues.length; ++i) {
            if (set.contains(appendValues[i])) continue;
            originalValue = originalValue + "," + appendValues[i].trim();
        }
        this.set(name, originalValue);
    }

    static {
        Configuration.addDefaultResource((String)"odps-graph.xml");
    }

    public static enum JobState {
        DEFINE,
        RUNNING;

    }
}

