/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.xflow;

import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.utils.PluginUtil;
import com.aliyun.openservices.odps.console.xflow.CNNDetailProgressHelper;
import com.aliyun.openservices.odps.console.xflow.PAICommand;
import com.aliyun.openservices.odps.console.xflow.UrlPollingProgressHelper;
import com.aliyun.openservices.odps.console.xflow.XFlowProgressHelper;
import com.aliyun.openservices.odps.console.xflow.XFlowStageProgressHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class XFlowProgressHelperRegistry {
    private static HashMap<String, Class<? extends XFlowProgressHelper>> actionsMap = new HashMap();

    public static XFlowProgressHelper getProgressHelper(String algoName) {
        if (!actionsMap.containsKey(algoName.toUpperCase())) {
            return new XFlowStageProgressHelper();
        }
        Class<? extends XFlowProgressHelper> clz = actionsMap.get(algoName.toUpperCase());
        if (clz == null) {
            return null;
        }
        try {
            XFlowProgressHelper fetcher = clz.newInstance();
            return fetcher;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    static {
        actionsMap.put("CNN_FEATURE_TRAIN", CNNDetailProgressHelper.class);
        List<Object> printUrlList = new ArrayList();
        try {
            Properties properties = PluginUtil.getPluginProperty(PAICommand.class);
            String cmd = properties.getProperty("poll_url_list");
            if (!StringUtils.isNullOrEmpty((String)cmd)) {
                printUrlList = Arrays.asList(cmd.split(","));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (String algo : printUrlList) {
            actionsMap.put(algo, UrlPollingProgressHelper.class);
        }
    }
}

