/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.xflow;

import com.aliyun.odps.Instance;
import com.aliyun.odps.OdpsException;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.xflow.XFlowProgressHelper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Set;

public class UrlPollingProgressHelper
extends XFlowProgressHelper {
    private static int interval = 3000;
    private boolean connectedFlag = false;

    @Override
    public String getPAIAlgoName() {
        return "";
    }

    UrlPollingProgressHelper() {
        super.setInterval(interval);
    }

    @Override
    public boolean needProgressMessage(Instance instance) {
        return !instance.isTerminated();
    }

    @Override
    public String getProgressMessage(Instance instance) throws ODPSConsoleException, OdpsException {
        StringBuilder sb = new StringBuilder();
        Set taskNames = instance.getTaskNames();
        StringWriter strWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(strWriter);
        int i = 0;
        for (String taskName : taskNames) {
            List stages = instance.getTaskProgress(taskName);
            if (stages.size() == 0) {
                writer.print(taskName + ": running");
            } else {
                writer.print(taskName + ": ");
                writer.print(Instance.getStageProgressFormattedString((List)stages));
            }
            if (++i >= taskNames.size()) continue;
            writer.print(", ");
        }
        String url = this.getConfig();
        if (url != null && !this.connectedFlag) {
            int code = 0;
            try {
                URL pollingUrl = new URL(url);
                HttpURLConnection connection = (HttpURLConnection)pollingUrl.openConnection();
                connection.setRequestMethod("GET");
                connection.connect();
                code = connection.getResponseCode();
            }
            catch (IOException e) {
                throw new OdpsException(e.getMessage());
            }
            if (code == 200) {
                writer.print("\nurl: " + url);
                this.connectedFlag = true;
            }
        }
        String str = strWriter.toString();
        sb.append(str);
        return sb.toString();
    }
}

