/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.xflow;

import com.aliyun.odps.ListIterator;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.XFlow;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import com.aliyun.openservices.odps.console.utils.antlr.AntlrObject;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class ShowXflowsCommand
extends AbstractCommand {
    public static final String[] HELP_TAGS = new String[]{"show", "xflows", "xflow"};
    private String projectName = null;
    private String publicProject = "algo_public";
    private String xflowOwner = null;
    private static final Pattern PATTERN = Pattern.compile("\\s*(SHOW|LIST)\\s+XFLOWS($|\\s+(.*))", 34);

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: show|list xflows [-p,-project <project_name>] owner");
    }

    public ShowXflowsCommand(String projectName, String xflowOwner, String cmd, ExecutionContext ctx) {
        super(cmd, ctx);
        this.projectName = projectName;
        this.xflowOwner = xflowOwner;
    }

    public void ShowXflows(String projectName) throws OdpsException, ODPSConsoleException {
        Odps odps = this.getCurrentOdps();
        long size = 0L;
        ListIterator xflows = odps.xFlows().iterator(projectName, this.xflowOwner);
        this.getWriter().writeError("");
        while (xflows.hasNext()) {
            ODPSConsoleUtils.checkThreadInterrupted();
            XFlow xflow = (XFlow)xflows.next();
            this.getWriter().writeResult(xflow.getOwner() + ":" + xflow.getName());
            ++size;
        }
        this.getWriter().writeError(size + " xflows in project " + projectName + ".\n");
        System.out.flush();
    }

    public void run() throws OdpsException, ODPSConsoleException {
        if (this.projectName == null) {
            String curProject = this.getContext().getProjectName();
            this.ShowXflows(curProject);
            if (!curProject.equals(this.publicProject)) {
                this.ShowXflows(this.publicProject);
            }
        } else {
            this.ShowXflows(this.projectName);
        }
        this.getWriter().writeError("OK");
    }

    private static Options getOptions() {
        Options options = new Options();
        options.addOption("p", "project", true, "user spec project");
        return options;
    }

    private static CommandLine getCommandLine(String[] args) throws ODPSConsoleException {
        try {
            GnuParser parser = new GnuParser();
            return parser.parse(ShowXflowsCommand.getOptions(), args);
        }
        catch (ParseException e) {
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help.  " + e.getMessage(), (Throwable)e);
        }
    }

    public static ShowXflowsCommand parse(String cmd, ExecutionContext ctx) throws ODPSConsoleException {
        if (cmd == null || ctx == null) {
            return null;
        }
        Matcher matcher = PATTERN.matcher(cmd);
        if (!matcher.matches()) {
            return null;
        }
        String input = matcher.group(2);
        String[] inputs = new AntlrObject(input).getTokenStringArray();
        CommandLine commandLine = ShowXflowsCommand.getCommandLine(inputs);
        String projectName = null;
        if (commandLine.hasOption("p")) {
            projectName = commandLine.getOptionValue("p");
        }
        if (commandLine.getArgList().size() > 1) {
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. Invalid command.");
        }
        String owner = null;
        if (commandLine.getArgList().size() == 1) {
            owner = commandLine.getArgs()[0];
        }
        ShowXflowsCommand command = new ShowXflowsCommand(projectName, owner, cmd, ctx);
        return command;
    }
}

