/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.xflow;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.ml.OfflineModel;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.utils.antlr.AntlrObject;
import com.aliyun.openservices.odps.console.xflow.PAICommand;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class ReadOfflineModelCommand
extends AbstractCommand {
    public static final String[] HELP_TAGS = new String[]{"read", "offline", "model", "offlinemodel"};
    private ExecutionContext ctx;
    private String projectName;
    private String modelName;
    private String volumeName;
    private String partitionName;
    private static Pattern PATTERN = Pattern.compile("\\s*READ\\s+OFFLINEMODEL\\s+(.+)", 34);

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: read offlinemodel [-p,-project <project_name>] <offlinemodel_name> [as <volume_name>[.<partition>]]");
        stream.println("       read offlinemodel [<project_name>.]<offlinemodel_name> [as <volume_name>[.<partition>]]");
    }

    public ReadOfflineModelCommand(String projectName, String modelName, String volumeName, String partitionName, String cmd, ExecutionContext ctx) {
        super(cmd, ctx);
        this.ctx = ctx;
        this.projectName = projectName;
        this.modelName = modelName;
        this.volumeName = volumeName;
        this.partitionName = partitionName;
    }

    public void SubmitWriteVolumeJob() throws OdpsException, ODPSConsoleException {
        this.getWriter().writeError("Begin write model to volume");
        String algoName = "modeltransfer";
        String format = "pmml";
        String paiCmdStr = "";
        paiCmdStr = this.partitionName != null ? String.format("pai -name %s -project algo_public -DmodelName=%s -DvolumeName=%s -Dpartition=%s -Dformat=%s", algoName, this.modelName, this.volumeName, this.partitionName, format) : String.format("pai -name %s -project algo_public -DmodelName=%s -DvolumeName=%s -Dformat=%s", algoName, this.modelName, this.volumeName, format);
        try {
            PAICommand PAICmd = PAICommand.parse(paiCmdStr, this.ctx);
            PAICmd.run();
        }
        catch (ODPSConsoleException oce) {
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. Invalid command.");
        }
    }

    public void run() throws OdpsException, ODPSConsoleException {
        Odps odps = this.getCurrentOdps();
        if (!odps.offlineModels().exists(this.projectName, this.modelName)) {
            throw new ODPSConsoleException("Offlinemodel not found : " + this.modelName);
        }
        if (this.volumeName != null) {
            this.SubmitWriteVolumeJob();
            return;
        }
        OfflineModel model = odps.offlineModels().get(this.projectName, this.modelName);
        this.getWriter().writeResult(model.getModel());
        System.out.flush();
    }

    private static Options getOptions() {
        Options options = new Options();
        options.addOption("p", "project", true, "user spec project");
        return options;
    }

    private static CommandLine getCommandLine(String[] args) throws ODPSConsoleException {
        try {
            GnuParser parser = new GnuParser();
            return parser.parse(ReadOfflineModelCommand.getOptions(), args);
        }
        catch (ParseException e) {
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help.  " + e.getMessage(), (Throwable)e);
        }
    }

    public static ReadOfflineModelCommand parse(String cmd, ExecutionContext ctx) throws ODPSConsoleException {
        int argSize;
        if (cmd == null || ctx == null) {
            return null;
        }
        Matcher m = PATTERN.matcher(cmd);
        if (!m.matches()) {
            return null;
        }
        String input = m.group(1);
        String[] inputs = new AntlrObject(input).getTokenStringArray();
        CommandLine commandLine = ReadOfflineModelCommand.getCommandLine(inputs);
        String projectName = null;
        if (commandLine.hasOption("p")) {
            projectName = commandLine.getOptionValue("p");
        }
        if ((argSize = commandLine.getArgList().size()) != 1 && argSize != 3) {
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. Model name not found.");
        }
        String modelName = null;
        modelName = commandLine.getArgs()[0];
        if (!modelName.matches("[.\\w]+")) {
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. Invalid model name.");
        }
        if (modelName.contains(".")) {
            String[] result = modelName.split("\\.", 2);
            if (projectName != null && !result[0].equals(projectName)) {
                throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. Project name conflict.");
            }
            projectName = result[0];
            modelName = result[1];
        }
        String volumeName = null;
        String partitionName = null;
        if (commandLine.getArgList().size() == 3) {
            if (commandLine.getArgs()[1].toUpperCase().compareTo("AS") != 0) {
                throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. Invalid command.");
            }
            volumeName = commandLine.getArgs()[2];
            if (volumeName.contains(".")) {
                String[] result = volumeName.split("\\.", 2);
                volumeName = result[0];
                partitionName = result[1];
            }
        }
        if (projectName == null) {
            projectName = ctx.getProjectName();
        }
        return new ReadOfflineModelCommand(projectName, modelName, volumeName, partitionName, cmd, ctx);
    }
}

