/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.xflow;

import com.aliyun.odps.Instance;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.utils.PluginUtil;
import com.aliyun.openservices.odps.console.xflow.PAICommand;
import com.aliyun.openservices.odps.console.xflow.XFlowProgressHelper;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import java.util.Set;

public class CNNDetailProgressHelper
extends XFlowProgressHelper {
    private static int interval = 30000;
    public static final String ALGO_NAME = "CNN_FEATURE_TRAIN";
    boolean isTerminated = false;

    CNNDetailProgressHelper() {
        super.setInterval(interval);
    }

    @Override
    public String getPAIAlgoName() {
        return ALGO_NAME;
    }

    @Override
    public boolean needProgressMessage(Instance instance) {
        boolean result = this.isTerminated;
        if (instance.isTerminated()) {
            this.isTerminated = true;
        }
        return !result;
    }

    @Override
    public String getProgressMessage(Instance instance) throws ODPSConsoleException, OdpsException {
        StringBuilder sb = new StringBuilder();
        Set taskNames = instance.getTaskNames();
        StringWriter strWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(strWriter);
        int i = 0;
        for (String taskName : taskNames) {
            String details = instance.getTaskDetailJson2(taskName);
            if (StringUtils.isNullOrEmpty((String)details)) {
                writer.print(taskName + ": running");
            } else {
                String formatStr = this.getDetailFormattedString(details);
                if (StringUtils.isNullOrEmpty((String)formatStr)) {
                    formatStr = "running...";
                }
                writer.print(taskName + " : \n");
                writer.print(formatStr);
            }
            if (++i >= taskNames.size()) continue;
            writer.print("\n");
        }
        String str = strWriter.toString();
        sb.append(str);
        return sb.toString();
    }

    public String getDetailFormattedString(String details) throws ODPSConsoleException {
        try {
            JsonArray messages = new JsonParser().parse(details).getAsJsonObject().get("message").getAsJsonArray();
            StringBuilder result = new StringBuilder();
            for (int idx = 0; idx < messages.size(); ++idx) {
                JsonObject stage = messages.get(idx).getAsJsonObject();
                result.append(String.format("%s\t\t%s\n", stage.get("time").getAsString(), stage.get("msg").getAsString()));
            }
            return result.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        try {
            Properties properties = PluginUtil.getPluginProperty(PAICommand.class);
            String intervalString = properties.getProperty("cnn_progress_interval", "30000");
            interval = Integer.parseInt(intervalString);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

