/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.resource;

import com.aliyun.odps.Function;
import com.aliyun.odps.OdpsException;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.utils.Coordinate;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import java.io.PrintStream;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DescribeFunctionCommand
extends AbstractCommand {
    public static final String[] HELP_TAGS = new String[]{"describe", "desc", "function"};
    private static Pattern PATTERN = Pattern.compile("\\s*(DESCRIBE|DESC)\\s+FUNCTION\\s+(.*)", 2);
    private Coordinate coordinate;

    public static void printUsage(PrintStream stream, ExecutionContext ctx) {
        stream.println("Usage:");
        if (ctx.isProjectMode()) {
            stream.println("  describe|desc function [<project name>.]<function name>;");
            stream.println("Example:");
            stream.println("  desc function my_function;");
            stream.println("  desc function my_project.my_function");
        } else {
            stream.println("  describe|desc function [[<project name>.]<schema name>.]<function name>;");
            stream.println("Example:");
            stream.println("  desc function my_function;");
            stream.println("  desc function my_schema.my_function");
            stream.println("  desc function my_project.my_schema.my_function");
        }
    }

    public DescribeFunctionCommand(Coordinate coordinate, String cmd, ExecutionContext context) {
        super(cmd, context);
        this.coordinate = coordinate;
    }

    public static AbstractCommand parse(String cmd, ExecutionContext ctx) throws ODPSConsoleException {
        Matcher m = PATTERN.matcher(cmd);
        if (!m.matches()) {
            return null;
        }
        Coordinate coordinate = Coordinate.getCoordinateABC((String)m.group(2));
        return new DescribeFunctionCommand(coordinate, cmd, ctx);
    }

    public void run() throws OdpsException, ODPSConsoleException {
        this.coordinate.interpretByCtx(this.getContext());
        String projectName = this.coordinate.getProjectName();
        String schemaName = this.coordinate.getSchemaName();
        String functionName = this.coordinate.getObjectName();
        Function function = this.getCurrentOdps().functions().get(projectName, schemaName, functionName);
        String formatPattern = "%-40s%-40s%n";
        System.out.printf(formatPattern, "Name", functionName);
        System.out.printf(formatPattern, "Owner", function.getOwner());
        System.out.printf(formatPattern, "Created Time", ODPSConsoleUtils.formatDate((Date)function.getCreatedTime()));
        if (function.isSqlFunction()) {
            System.out.printf(formatPattern, "SQL Definition Text", function.getSqlDefinitionText());
        } else if (function.isEmbeddedFunction()) {
            this.printClassAndResources(function, formatPattern);
            System.out.printf(formatPattern, "Lang", function.getEmbeddedFunctionProgramLanguage());
            String filename = function.getEmbeddedFunctionFilename();
            if (null != filename) {
                System.out.printf(formatPattern, "File Name", filename);
            }
            System.out.println("Code");
            System.out.println(function.getEmbeddedFunctionCode());
        } else {
            this.printClassAndResources(function, formatPattern);
        }
    }

    private void printClassAndResources(Function function, String formatPattern) {
        System.out.printf(formatPattern, "Class", function.getClassPath());
        List resourceFullNames = function.getResourceFullNames();
        if (resourceFullNames != null) {
            StringBuilder builder = new StringBuilder();
            for (String name : resourceFullNames) {
                if (builder.length() != 0) {
                    builder.append(",");
                }
                builder.append(name);
            }
            System.out.printf(formatPattern, "Resources", builder);
        }
    }
}

