/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.xerial.snappy.PureJavaCrc32C;

public class ArrowHttpOutputStream
implements WritableByteChannel {
    private OutputStream out;
    private byte[] buf = new byte[0];
    private final int CHUNK_SIZE;
    private PureJavaCrc32C chunkCrc = new PureJavaCrc32C();
    private PureJavaCrc32C globalCrc = new PureJavaCrc32C();
    private boolean isOpen;
    private int currentPosition;
    private boolean isWriteChunkSize = false;

    public ArrowHttpOutputStream(OutputStream outputStream) {
        this(outputStream, 65536);
    }

    public ArrowHttpOutputStream(OutputStream outputStream, int chunkSize) {
        this.out = outputStream;
        this.isOpen = true;
        this.CHUNK_SIZE = chunkSize;
    }

    private void writeChunk(ByteBuffer src, int length) throws IOException {
        src.get(this.buf, this.currentPosition, length);
        this.out.write(this.buf, this.currentPosition, length);
        this.chunkCrc.update(this.buf, this.currentPosition, length);
        this.globalCrc.update(this.buf, this.currentPosition, length);
        this.currentPosition += length;
        if (this.currentPosition >= this.CHUNK_SIZE) {
            int crcCheckSum = (int)this.chunkCrc.getValue();
            this.writeUInt32(crcCheckSum);
            this.chunkCrc.reset();
            this.currentPosition = 0;
        }
    }

    private void writeUInt32(int number) throws IOException {
        byte[] temp = new byte[4];
        ArrowHttpOutputStream.intToBytes(number, temp);
        this.out.write(temp, 0, 4);
    }

    private void flush() throws IOException {
        int globalCrcCheckSum = (int)this.globalCrc.getValue();
        this.writeUInt32(globalCrcCheckSum);
        this.globalCrc.reset();
    }

    private static void intToBytes(int value, byte[] bytes) {
        bytes[0] = (byte)(value >>> 24);
        bytes[1] = (byte)(value >>> 16);
        bytes[2] = (byte)(value >>> 8);
        bytes[3] = (byte)value;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int totalWrite;
        int writeBytes;
        if (!this.isOpen) {
            throw new IOException("Operation forbidden on closed BufferReader");
        }
        if (!this.isWriteChunkSize) {
            this.writeUInt32(this.CHUNK_SIZE);
            this.buf = new byte[this.CHUNK_SIZE];
            this.isWriteChunkSize = true;
        }
        int len = src.remaining();
        for (totalWrite = 0; totalWrite < len; totalWrite += writeBytes) {
            writeBytes = Math.min(this.CHUNK_SIZE - this.currentPosition, len - totalWrite);
            this.writeChunk(src, writeBytes);
        }
        return totalWrite;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void close() throws IOException {
        if (this.isOpen) {
            this.flush();
            this.isOpen = false;
            this.out.close();
        }
    }
}

