/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.impl;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.commons.transport.Request;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.TunnelTableSchema;
import com.aliyun.odps.tunnel.hasher.DecimalHashObject;
import com.aliyun.odps.tunnel.hasher.TypeHasher;
import com.aliyun.odps.tunnel.impl.Slot;
import com.aliyun.odps.tunnel.impl.UpsertRecord;
import com.aliyun.odps.tunnel.impl.UpsertSessionImpl;
import com.aliyun.odps.tunnel.io.Checksum;
import com.aliyun.odps.tunnel.io.CompressOption;
import com.aliyun.odps.tunnel.io.ProtobufRecordPack;
import com.aliyun.odps.tunnel.streams.UpsertStream;
import com.aliyun.odps.type.DecimalTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.utils.FixedNettyChannelPool;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class UpsertStreamImpl
implements UpsertStream {
    private long maxBufferSize;
    private long slotBufferSize;
    private final CompressOption compressOption;
    private final URI endpoint;
    private final UpsertSessionImpl session;
    private Map<Integer, Slot> buckets;
    private List<Integer> hashKeys = new ArrayList<Integer>();
    private TunnelTableSchema schema;
    private final Map<Integer, ProtobufRecordPack> bucketBuffer = new HashMap<Integer, ProtobufRecordPack>();
    private long totalBufferSize = 0L;
    private final Bootstrap bootstrap;
    private CountDownLatch latch;
    private FixedNettyChannelPool channelPool;
    private long connectTimeout;
    private long readTimeout;
    private Status status = Status.NORMAL;
    private UpsertStream.Listener listener = null;

    public UpsertStreamImpl(Builder builder) throws IOException, TunnelException {
        this.compressOption = builder.getCompressOption();
        this.slotBufferSize = builder.getSlotBufferSize();
        this.maxBufferSize = builder.getMaxBufferSize();
        this.session = builder.session;
        this.endpoint = this.session.getEndpoint();
        this.buckets = this.session.getBuckets();
        this.schema = this.session.getRecordSchema();
        this.hashKeys = this.session.getHashKeys();
        this.bootstrap = this.session.getBootstrap();
        this.channelPool = this.session.getChannelPool();
        this.connectTimeout = this.session.getConnectTimeout();
        this.readTimeout = this.session.getReadTimeout();
        this.listener = builder.getListener();
        this.newBucketBuffer();
    }

    private void newBucketBuffer() throws IOException {
        for (Integer slot : this.buckets.keySet()) {
            this.bucketBuffer.put(slot, new ProtobufRecordPack(this.schema, new Checksum(), 0, this.compressOption));
        }
    }

    @Override
    public void upsert(Record record) throws IOException, TunnelException {
        this.write(record, Operation.UPSERT, null);
    }

    @Override
    public void upsert(Record record, List<String> upsertCols) throws IOException, TunnelException {
        if (upsertCols != null && !upsertCols.isEmpty() && !this.session.supportPartialUpdate()) {
            throw new TunnelException("Table " + this.session.tableName + " do not support partial update, consider set table properties 'acid.partial.fields.update.enable=true'");
        }
        if (upsertCols != null && !upsertCols.isEmpty()) {
            Set columnSet = this.schema.getColumns().stream().map(Column::getName).collect(Collectors.toSet());
            upsertCols.forEach(col -> {
                if (!columnSet.contains(col)) {
                    throw new IllegalArgumentException("Invalid column name:" + col);
                }
            });
        }
        this.write(record, Operation.UPSERT, upsertCols);
    }

    @Override
    public void delete(Record record) throws IOException, TunnelException {
        this.write(record, Operation.DELETE, null);
    }

    @Override
    public void flush() throws IOException, TunnelException {
        this.flush(true);
    }

    @Override
    public void close() throws IOException, TunnelException {
        if (this.status == Status.NORMAL) {
            this.flush();
            this.status = Status.CLOSED;
        }
    }

    @Override
    public void reset() throws IOException {
        if (!this.bucketBuffer.isEmpty()) {
            for (ProtobufRecordPack pack : this.bucketBuffer.values()) {
                pack.reset();
            }
        }
        this.totalBufferSize = 0L;
        this.status = Status.NORMAL;
    }

    private void write(Record record, Operation op, List<String> valueColumns) throws TunnelException, IOException {
        this.checkStatus();
        ArrayList<Integer> hashValues = new ArrayList<Integer>();
        for (int key : this.hashKeys) {
            Object value = record.get(key);
            if (value == null) {
                throw new TunnelException(" UpsertRecord must have primary key value, consider provide values for column '" + this.schema.getColumn(key).getName() + "'");
            }
            TypeInfo typeInfo = this.schema.getColumn(key).getTypeInfo();
            if (typeInfo.getOdpsType() == OdpsType.DECIMAL) {
                DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)typeInfo;
                value = new DecimalHashObject((BigDecimal)value, decimalTypeInfo.getPrecision(), decimalTypeInfo.getScale());
            }
            hashValues.add(TypeHasher.hash(typeInfo.getOdpsType(), value, this.session.getHasher()));
        }
        int bucket = TypeHasher.CombineHashVal(hashValues) % this.buckets.size();
        if (!this.bucketBuffer.containsKey(bucket)) {
            throw new TunnelException("Tunnel internal error! Do not have bucket for hash key " + bucket);
        }
        ProtobufRecordPack pack = this.bucketBuffer.get(bucket);
        UpsertRecord r = (UpsertRecord)record;
        r.setOperation(op == Operation.UPSERT ? (byte)85 : 68);
        ArrayList<Long> valueCols = new ArrayList<Long>();
        if (valueColumns != null) {
            for (String validColumnName : valueColumns) {
                valueCols.add(this.schema.getColumnId(validColumnName));
            }
        }
        r.setValueCols(valueCols);
        long bytes = pack.getTotalBytes();
        pack.append((Record)r.getRecord());
        bytes = pack.getTotalBytes() - bytes;
        this.totalBufferSize += bytes;
        if (pack.getTotalBytes() > this.slotBufferSize) {
            this.flush(false);
        } else if (this.totalBufferSize > this.maxBufferSize) {
            this.flush(true);
        }
    }

    private void flush(boolean flushAll) throws TunnelException, IOException {
        boolean success;
        ArrayList<FlushResultHandler> handlers = new ArrayList<FlushResultHandler>();
        int retry = 0;
        Map<Integer, Slot> bucketMap = this.session.getBuckets();
        if (bucketMap.size() != this.buckets.size()) {
            throw new TunnelException("session slot map is changed");
        }
        this.buckets = bucketMap;
        do {
            success = true;
            handlers.clear();
            Channel channel = null;
            try {
                this.checkStatus();
                this.latch = new CountDownLatch(this.bucketBuffer.size());
                for (Map.Entry<Integer, ProtobufRecordPack> entry : this.bucketBuffer.entrySet()) {
                    ProtobufRecordPack pack = entry.getValue();
                    if (pack.getSize() > 0L) {
                        if (pack.getTotalBytes() > this.slotBufferSize || flushAll) {
                            int bucketId = entry.getKey();
                            long bytes = pack.getTotalBytes();
                            pack.checkTransConsistency(false);
                            pack.complete();
                            bytes = pack.getTotalBytes() - bytes;
                            if (!flushAll) {
                                this.totalBufferSize += bytes;
                            }
                            Request request = this.session.buildRequest("PUT", bucketId, this.buckets.get(bucketId), pack.getTotalBytes(), pack.getSize(), this.compressOption);
                            channel = this.channelPool.acquire();
                            FlushResultHandler handler = new FlushResultHandler(pack, this.latch, this.listener, retry, bucketId);
                            channel.pipeline().addLast(new ChannelHandler[]{handler});
                            handlers.add(handler);
                            ChannelFuture channelFuture = channel.writeAndFlush((Object)this.buildFullHttpRequest(request, pack.getProtobufStream()));
                            channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                                if (!future.isSuccess()) {
                                    this.latch.countDown();
                                    this.channelPool.release(future.channel());
                                    handler.setException(new TunnelException("Connect : " + future.cause().getMessage(), future.cause()));
                                    future.channel().close();
                                } else {
                                    future.channel().pipeline().addFirst(new ChannelHandler[]{new ReadTimeoutHandler(this.readTimeout, TimeUnit.MILLISECONDS)});
                                }
                            }));
                            continue;
                        }
                        this.latch.countDown();
                        continue;
                    }
                    this.latch.countDown();
                }
                this.latch.await();
            }
            catch (InterruptedException e) {
                throw new TunnelException("flush interrupted", e);
            }
            for (FlushResultHandler handler : handlers) {
                if (handler.getException() != null) {
                    TunnelException e;
                    success = false;
                    if (this.listener != null) {
                        if (this.listener.onFlushFail(handler.getException(), retry)) continue;
                        this.status = Status.ERROR;
                        e = new TunnelException(handler.getException().getErrorMsg(), handler.getException());
                        e.setRequestId(handler.getException().getRequestId());
                        e.setErrorCode(handler.getException().getErrorCode());
                        throw e;
                    }
                    e = new TunnelException(handler.getException().getErrorMsg(), handler.getException());
                    e.setRequestId(handler.getException().getRequestId());
                    e.setErrorCode(handler.getException().getErrorCode());
                    throw e;
                }
                if (flushAll) continue;
                this.totalBufferSize -= handler.getFlushResult().flushSize;
            }
            ++retry;
        } while (!success);
        if (flushAll) {
            this.totalBufferSize = 0L;
        }
    }

    private void checkStatus() throws TunnelException {
        if (Status.CLOSED == this.status) {
            throw new TunnelException("Stream is closed!");
        }
        if (Status.ERROR == this.status) {
            throw new TunnelException("Stream has error!");
        }
    }

    private HttpRequest buildFullHttpRequest(Request request, ByteArrayOutputStream content) {
        String uri = request.getURI().toString().replace(this.endpoint.toString(), "");
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.PUT, uri, Unpooled.wrappedBuffer((byte[])content.toByteArray()));
        request.getHeaders().forEach((arg_0, arg_1) -> UpsertStreamImpl.lambda$buildFullHttpRequest$2((HttpRequest)req, arg_0, arg_1));
        req.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)request.getURI().getHost());
        return req;
    }

    private static /* synthetic */ void lambda$buildFullHttpRequest$2(HttpRequest req, String key, String value) {
        req.headers().set(key, (Object)value);
    }

    private class FlushResultHandler
    extends ChannelInboundHandlerAdapter {
        private UpsertStream.FlushResult flushResult = new UpsertStream.FlushResult();
        private ProtobufRecordPack pack;
        private TunnelException exception = null;
        CountDownLatch latch;
        long start;
        UpsertStream.Listener listener;
        int retry;
        int bucketId;

        public UpsertStream.FlushResult getFlushResult() {
            return this.flushResult;
        }

        public TunnelException getException() {
            return this.exception;
        }

        public void setException(TunnelException exception) {
            this.exception = exception;
        }

        FlushResultHandler(ProtobufRecordPack pack, CountDownLatch latch, UpsertStream.Listener listener, int retry, int bucketId) {
            this.flushResult.recordCount = pack.getSize();
            this.pack = pack;
            this.flushResult.flushSize = pack.getTotalBytes();
            this.latch = latch;
            this.start = System.currentTimeMillis();
            this.listener = listener;
            this.retry = retry;
            this.bucketId = bucketId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            block25: {
                FullHttpResponse response = null;
                try {
                    response = (FullHttpResponse)msg;
                    this.flushResult.traceId = response.headers().get("x-odps-request-id");
                    if (response.status().equals((Object)HttpResponseStatus.OK)) {
                        this.flushResult.flushTime = System.currentTimeMillis() - this.start;
                        this.pack.reset();
                        if (this.listener != null) {
                            try {
                                this.listener.onFlush(this.flushResult);
                            }
                            catch (Exception exception) {}
                        }
                        break block25;
                    }
                    try (ByteBufInputStream contentStream = new ByteBufInputStream(response.content());){
                        this.exception = new TunnelException(this.flushResult.traceId, (InputStream)contentStream, response.status().code());
                        if (response.status().code() == 308) {
                            if (response.headers().contains("odps-tunnel-routed-server")) {
                                String newSlotServer = response.headers().get("odps-tunnel-routed-server");
                                UpsertStreamImpl.this.session.updateBuckets(this.bucketId, newSlotServer);
                            } else {
                                UpsertStreamImpl.this.session.updateBuckets(this.bucketId, null);
                            }
                            UpsertStreamImpl.this.buckets = UpsertStreamImpl.this.session.getBuckets();
                        }
                    }
                }
                catch (Exception e) {
                    this.exception = new TunnelException(e.getMessage(), e);
                }
                finally {
                    this.latch.countDown();
                    if (response != null) {
                        response.release();
                    }
                    UpsertStreamImpl.this.channelPool.release(ctx.channel());
                    ctx.close();
                }
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            this.exception = cause instanceof ReadTimeoutException ? new TunnelException("Flush time out, cannot get response from server") : new TunnelException(cause.getMessage(), cause);
            this.latch.countDown();
            UpsertStreamImpl.this.channelPool.release(ctx.channel());
            ctx.close();
        }
    }

    public static class Builder
    implements UpsertStream.Builder {
        private UpsertSessionImpl session;
        private long maxBufferSize = 0x4000000L;
        private long slotBufferSize = 0x100000L;
        private CompressOption compressOption = new CompressOption(CompressOption.CompressAlgorithm.ODPS_LZ4_FRAME, -1, 0);
        private UpsertStream.Listener listener = null;

        public Builder setSession(UpsertSessionImpl session) {
            this.session = session;
            return this;
        }

        public UpsertSessionImpl getSession() {
            return this.session;
        }

        @Override
        public long getMaxBufferSize() {
            return this.maxBufferSize;
        }

        @Override
        public Builder setMaxBufferSize(long maxBufferSize) {
            this.maxBufferSize = maxBufferSize;
            return this;
        }

        @Override
        public long getSlotBufferSize() {
            return this.slotBufferSize;
        }

        @Override
        public Builder setSlotBufferSize(long slotBufferSize) {
            this.slotBufferSize = slotBufferSize;
            return this;
        }

        @Override
        public CompressOption getCompressOption() {
            return this.compressOption;
        }

        @Override
        public Builder setCompressOption(CompressOption compressOption) {
            this.compressOption = compressOption;
            return this;
        }

        @Override
        public UpsertStream.Listener getListener() {
            return this.listener;
        }

        @Override
        public Builder setListener(UpsertStream.Listener listener) {
            this.listener = listener;
            return this;
        }

        @Override
        public UpsertStream build() throws IOException, TunnelException {
            return new UpsertStreamImpl(this);
        }
    }

    private static enum Status {
        NORMAL,
        ERROR,
        CLOSED;

    }

    private static enum Operation {
        UPSERT,
        DELETE;

    }
}

