/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel;

import com.aliyun.odps.Column;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.ArrowUtils;
import com.aliyun.odps.commons.util.IOUtils;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.ArrowRecordReader;
import com.aliyun.odps.data.ArrowRecordWriter;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.RecordPack;
import com.aliyun.odps.data.RecordReader;
import com.aliyun.odps.data.RecordWriter;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.tunnel.Configuration;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.TunnelTableSchema;
import com.aliyun.odps.tunnel.impl.StreamUploadSessionImpl;
import com.aliyun.odps.tunnel.impl.UpsertSessionImpl;
import com.aliyun.odps.tunnel.io.ArrowTunnelRecordReader;
import com.aliyun.odps.tunnel.io.ArrowTunnelRecordWriter;
import com.aliyun.odps.tunnel.io.Checksum;
import com.aliyun.odps.tunnel.io.CompressOption;
import com.aliyun.odps.tunnel.io.ProtobufRecordPack;
import com.aliyun.odps.tunnel.io.TunnelBufferedWriter;
import com.aliyun.odps.tunnel.io.TunnelRecordReader;
import com.aliyun.odps.tunnel.io.TunnelRecordWriter;
import com.aliyun.odps.tunnel.io.TunnelRetryHandler;
import com.aliyun.odps.tunnel.streams.UpsertStream;
import com.aliyun.odps.utils.ColumnUtils;
import com.aliyun.odps.utils.ConnectionWatcher;
import com.aliyun.odps.utils.StringUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.compression.CompressionCodec;
import org.apache.arrow.vector.compression.NoCompressionCodec;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.arrow.vector.types.pojo.Schema;

public class TableTunnel {
    private final Configuration config;
    private final Random random = new Random();
    private final Odps odps;

    public TableTunnel(Odps odps) {
        this.odps = odps;
        this.config = new Configuration(odps);
    }

    public TableTunnel(Odps odps, Configuration config) {
        this.odps = odps;
        this.config = config;
    }

    public Odps getOdps() {
        return this.odps;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public UploadSession createUploadSession(String projectName, String tableName) throws TunnelException {
        return this.createUploadSession(projectName, this.config.getOdps().getCurrentSchema(), tableName, false);
    }

    public UploadSession createUploadSession(String projectName, String tableName, boolean overwrite) throws TunnelException {
        return this.createUploadSession(projectName, this.config.getOdps().getCurrentSchema(), tableName, overwrite);
    }

    public UploadSession createUploadSession(String projectName, String schemaName, String tableName, boolean overwrite) throws TunnelException {
        return new UploadSession(projectName, schemaName, tableName, null, null, overwrite);
    }

    public UploadSession createUploadSession(String projectName, String tableName, PartitionSpec partitionSpec) throws TunnelException {
        return this.createUploadSession(projectName, tableName, partitionSpec, false);
    }

    public UploadSession createUploadSession(String projectName, String tableName, PartitionSpec partitionSpec, boolean overwrite) throws TunnelException {
        return this.createUploadSession(projectName, this.config.getOdps().getCurrentSchema(), tableName, partitionSpec, overwrite);
    }

    public UploadSession createUploadSession(String projectName, String schemaName, String tableName, PartitionSpec partitionSpec, boolean overwrite) throws TunnelException {
        if (partitionSpec == null || partitionSpec.keys().size() == 0) {
            throw new IllegalArgumentException("Invalid arguments, partition spec required.");
        }
        return new UploadSession(projectName, schemaName, tableName, partitionSpec.toString().replaceAll("'", ""), null, overwrite);
    }

    public UploadSession getUploadSession(String projectName, String tableName, String id, long shares, long shareId) throws TunnelException {
        return this.getUploadSession(projectName, tableName, null, id, shares, shareId);
    }

    public UploadSession getUploadSession(String projectName, String tableName, PartitionSpec partitionSpec, String id, long shares, long shareId) throws TunnelException {
        return this.getUploadSession(projectName, this.config.getOdps().getCurrentSchema(), tableName, partitionSpec, id, shares, shareId);
    }

    public UploadSession getUploadSession(String projectName, String schemaName, String tableName, PartitionSpec partitionSpec, String id, long shares, long shareId) throws TunnelException {
        if (shares < 1L) {
            throw new IllegalArgumentException("Invalid arguments, shares must >= 1");
        }
        if (shareId < 0L) {
            throw new IllegalArgumentException("Invalid arguments, shareId must >= 0");
        }
        if (shares <= shareId) {
            throw new IllegalArgumentException("Invalid arguments, shares must > shareId");
        }
        UploadSession session = partitionSpec != null ? this.getUploadSession(projectName, schemaName, tableName, partitionSpec, id) : this.getUploadSession(projectName, schemaName, tableName, id);
        session.shares = shares;
        session.curBlockId = shareId;
        return session;
    }

    public UploadSession getUploadSession(String projectName, String tableName, String id) throws TunnelException {
        return this.getUploadSession(projectName, this.config.getOdps().getCurrentSchema(), tableName, id);
    }

    public UploadSession getUploadSession(String projectName, String schemaName, String tableName, String id) throws TunnelException {
        return new UploadSession(projectName, schemaName, tableName, null, id, false);
    }

    public UploadSession getUploadSession(String projectName, String tableName, PartitionSpec partitionSpec, String id) throws TunnelException {
        return this.getUploadSession(projectName, this.config.getOdps().getCurrentSchema(), tableName, partitionSpec, id);
    }

    public UploadSession getUploadSession(String projectName, String schemaName, String tableName, PartitionSpec partitionSpec, String id) throws TunnelException {
        return this.getUploadSession(projectName, schemaName, tableName, partitionSpec, id, true);
    }

    public UploadSession getUploadSession(String projectName, String schemaName, String tableName, PartitionSpec partitionSpec, String id, boolean getBlockId) throws TunnelException {
        return new UploadSession(projectName, schemaName, tableName, partitionSpec == null ? null : partitionSpec.toString().replace("'", ""), id, false, getBlockId);
    }

    public DownloadSessionBuilder buildDownloadSession(String projectName, String tableName) {
        return new DownloadSessionBuilder().setProjectName(projectName).setTableName(tableName);
    }

    @Deprecated
    public DownloadSession createDownloadSession(String projectName, String tableName) throws TunnelException {
        return this.createDownloadSession(projectName, tableName, false);
    }

    @Deprecated
    public DownloadSession createDownloadSession(String projectName, String tableName, boolean async) throws TunnelException {
        return this.createDownloadSession(projectName, this.config.getOdps().getCurrentSchema(), tableName, async);
    }

    @Deprecated
    public DownloadSession createDownloadSession(String projectName, String schemaName, String tableName, boolean async) throws TunnelException {
        return this.buildDownloadSession(projectName, tableName).setSchemaName(schemaName).setAsyncMode(async).build();
    }

    @Deprecated
    public DownloadSession createDownloadSession(String projectName, String tableName, PartitionSpec partitionSpec) throws TunnelException {
        return this.createDownloadSession(projectName, tableName, partitionSpec, false);
    }

    @Deprecated
    public DownloadSession createDownloadSession(String projectName, String tableName, PartitionSpec partitionSpec, boolean async) throws TunnelException {
        if (partitionSpec == null || partitionSpec.keys().size() == 0) {
            throw new IllegalArgumentException("Invalid arguments, partition spec required.");
        }
        return this.createDownloadSession(projectName, this.config.getOdps().getCurrentSchema(), tableName, partitionSpec, async);
    }

    @Deprecated
    public DownloadSession createDownloadSession(String projectName, String schemaName, String tableName, PartitionSpec partitionSpec, boolean async) throws TunnelException {
        if (partitionSpec == null || partitionSpec.keys().size() == 0) {
            throw new IllegalArgumentException("Invalid arguments, partition spec required.");
        }
        return this.buildDownloadSession(projectName, tableName).setSchemaName(schemaName).setPartitionSpec(partitionSpec).setAsyncMode(async).build();
    }

    @Deprecated
    public DownloadSession createDownloadSession(String projectName, String tableName, long shardId) throws TunnelException {
        if (shardId < 0L) {
            throw new IllegalArgumentException("Invalid arguments, shard id required.");
        }
        return this.buildDownloadSession(projectName, tableName).setShardId(shardId).build();
    }

    @Deprecated
    public DownloadSession createDownloadSession(String projectName, String tableName, PartitionSpec partitionSpec, long shardId) throws TunnelException {
        if (partitionSpec == null || partitionSpec.keys().size() == 0) {
            throw new IllegalArgumentException("Invalid arguments, partition spec required.");
        }
        if (shardId < 0L) {
            throw new IllegalArgumentException("Invalid arguments, shard id required.");
        }
        return this.buildDownloadSession(projectName, tableName).setPartitionSpec(partitionSpec).setShardId(shardId).build();
    }

    public DownloadSession getDownloadSession(String projectName, String tableName, String id) throws TunnelException {
        return this.getDownloadSession(projectName, this.config.getOdps().getCurrentSchema(), tableName, id);
    }

    public DownloadSession getDownloadSession(String projectName, String schemaName, String tableName, String id) throws TunnelException {
        return this.buildDownloadSession(projectName, tableName).setSchemaName(schemaName).setDownloadId(id).build();
    }

    @Deprecated
    public DownloadSession getDownloadSession(String projectName, String tableName, long shardId, String id) throws TunnelException {
        return this.buildDownloadSession(projectName, tableName).setShardId(shardId).setDownloadId(id).build();
    }

    public DownloadSession getDownloadSession(String projectName, String tableName, PartitionSpec partitionSpec, String id) throws TunnelException {
        return this.getDownloadSession(projectName, this.config.getOdps().getCurrentSchema(), tableName, partitionSpec, id);
    }

    public DownloadSession getDownloadSession(String projectName, String schemaName, String tableName, PartitionSpec partitionSpec, String id) throws TunnelException {
        if (partitionSpec == null || partitionSpec.keys().size() == 0) {
            throw new IllegalArgumentException("Invalid arguments, partition spec required.");
        }
        return this.buildDownloadSession(projectName, tableName).setSchemaName(schemaName).setPartitionSpec(partitionSpec).setDownloadId(id).build();
    }

    @Deprecated
    public DownloadSession getDownloadSession(String projectName, String tableName, PartitionSpec partitionSpec, long shardId, String id) throws TunnelException {
        if (partitionSpec == null || partitionSpec.keys().size() == 0) {
            throw new IllegalArgumentException("Invalid arguments, partition spec required.");
        }
        if (shardId < 0L) {
            throw new IllegalArgumentException("Invalid arguments, shard id required.");
        }
        return this.buildDownloadSession(projectName, tableName).setPartitionSpec(partitionSpec).setShardId(shardId).setDownloadId(id).build();
    }

    private String getResource(String projectName, String tableName) {
        return this.config.getResource(projectName, tableName);
    }

    public void setEndpoint(String endpoint) {
        try {
            URI u = new URI(endpoint);
            this.config.setEndpoint(u);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid endpoint.");
        }
    }

    public StreamUploadSession.Builder buildStreamUploadSession(String projectName, String tableName) {
        return new StreamUploadSessionImpl.Builder().setConfig(this.config).setProjectName(projectName).setTableName(tableName).setSchemaName(this.config.getOdps().getCurrentSchema());
    }

    public UpsertSession.Builder buildUpsertSession(String projectName, String tableName) {
        return new UpsertSessionImpl.Builder().setConfig(this.config).setProjectName(projectName).setTableName(tableName);
    }

    public ArrowStreamReader preview(String projectName, String schemaName, String tableName) throws TunnelException {
        return this.preview(projectName, schemaName, tableName, null);
    }

    public ArrowStreamReader preview(String projectName, String schemaName, String tableName, String partitionSpec) throws TunnelException {
        return this.preview(projectName, schemaName, tableName, partitionSpec, -1L);
    }

    public ArrowStreamReader preview(String projectName, String schemaName, String tableName, String partitionSpec, Long limit) throws TunnelException {
        return this.preview(projectName, schemaName, tableName, partitionSpec, limit, null);
    }

    public ArrowStreamReader preview(String projectName, String schemaName, String tableName, String partitionSpec, Long limit, List<String> requiredColumns) throws TunnelException {
        return this.preview(projectName, schemaName, tableName, partitionSpec, limit, requiredColumns, null);
    }

    private ArrowStreamReader preview(String projectName, String schemaName, String tableName, String partitionSpec, Long limit, List<String> requiredColumns, String acceptEncoding) throws TunnelException {
        if (limit != null && limit < 0L) {
            limit = -1L;
        }
        HashMap<String, String> headers = TableTunnel.getCommonHeader();
        if (acceptEncoding != null) {
            headers.put("Accept-Encoding", acceptEncoding);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("limit", String.valueOf(limit));
        if (partitionSpec != null) {
            params.put("partition", partitionSpec);
        }
        if (requiredColumns != null && !requiredColumns.isEmpty()) {
            TableSchema tableSchema = this.odps.tables().get(projectName, schemaName, tableName).getSchema();
            List<String> orderedColumns = ColumnUtils.orderColumns(tableSchema, requiredColumns);
            params.put("columns", String.join((CharSequence)",", orderedColumns));
        }
        String resource = ResourceBuilder.buildTableResource(projectName, schemaName, tableName);
        resource = resource + "/preview";
        RestClient client = this.config.newRestClient(projectName);
        try {
            Connection conn = client.connect(resource, "GET", params, headers);
            Response resp = conn.getResponse();
            if (!resp.isOK()) {
                throw new TunnelException(conn.getInputStream());
            }
            String contentEncoding = resp.getHeader("Content-Encoding");
            switch (Optional.ofNullable(contentEncoding).orElse("").toUpperCase()) {
                default: 
            }
            NoCompressionCodec.Factory compressionFactory = NoCompressionCodec.Factory.INSTANCE;
            RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);
            return new ArrowStreamReader(conn.getInputStream(), (BufferAllocator)allocator, (CompressionCodec.Factory)compressionFactory);
        }
        catch (IOException e) {
            throw new TunnelException("Failed to connect to the tunnel endpoint " + client.getEndpoint(), e);
        }
        catch (TunnelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TunnelException(e.getMessage(), e);
        }
    }

    static HashMap<String, String> getCommonHeader() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Length", String.valueOf(0));
        headers.put("odps-tunnel-date-transform", "v1");
        headers.put("x-odps-tunnel-version", String.valueOf(5));
        return headers;
    }

    public static void checkBlockVersion(long blockVersion) throws TunnelException {
        if (blockVersion <= 0L) {
            throw new TunnelException("Block version should be a positive integer.");
        }
    }

    public class DownloadSessionBuilder {
        private String projectName;
        private String schemaName;
        private String tableName;
        private PartitionSpec partitionSpec;
        private Long shardId;
        private String downloadId;
        private boolean asyncMode = false;
        private boolean waitAsyncBuild = true;

        public DownloadSessionBuilder setProjectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public DownloadSessionBuilder setSchemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public DownloadSessionBuilder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public DownloadSessionBuilder setPartitionSpec(PartitionSpec partitionSpec) {
            this.partitionSpec = partitionSpec;
            return this;
        }

        public DownloadSessionBuilder setDownloadId(String downloadId) {
            this.downloadId = downloadId;
            return this;
        }

        public DownloadSessionBuilder setShardId(Long shardId) {
            this.shardId = shardId;
            return this;
        }

        public DownloadSessionBuilder setAsyncMode(boolean asyncMode) {
            this.asyncMode = asyncMode;
            return this;
        }

        public DownloadSessionBuilder setWaitAsyncBuild(boolean waitAsyncBuild) {
            this.waitAsyncBuild = waitAsyncBuild;
            return this;
        }

        public DownloadSession build() throws TunnelException {
            return new DownloadSession(this.projectName, this.schemaName, this.tableName, this.partitionSpec == null ? null : this.partitionSpec.toString().replaceAll("'", ""), this.shardId, this.downloadId, this.asyncMode, this.waitAsyncBuild);
        }

        public boolean wait(DownloadSession download, int interval, long timeout) throws TunnelException {
            long sleepInterval;
            if (download == null) {
                return false;
            }
            interval = Math.max(interval, 1);
            interval = Math.min(interval, 30);
            timeout = Math.max(timeout, 0L);
            int maxSleepIntervalMs = interval * 1000 + 1;
            for (long timeoutValueMs = timeout * 1000L; download.status == DownloadStatus.INITIATING && timeoutValueMs > 0L; timeoutValueMs -= sleepInterval) {
                sleepInterval = TableTunnel.this.random.nextInt(maxSleepIntervalMs - 500) + 500;
                try {
                    Thread.sleep(sleepInterval);
                    download.reload();
                    continue;
                }
                catch (InterruptedException e) {
                    throw new TunnelException("Wait Async Create Download Session interrupted", e);
                }
            }
            if (download.status != DownloadStatus.INITIATING && download.status != DownloadStatus.NORMAL) {
                throw new TunnelException("Download session is " + download.status.toString());
            }
            return download.status == DownloadStatus.NORMAL;
        }
    }

    public class DownloadSession {
        private String id;
        private String projectName;
        private String schemaName;
        private String tableName;
        private String partitionSpec;
        private Long shardId;
        private long count;
        private TableSchema schema = new TableSchema();
        private DownloadStatus status = DownloadStatus.UNKNOWN;
        private String quotaName;
        private Configuration conf;
        private String RAPInstanceId;
        private RestClient tunnelServiceClient;
        private boolean shouldTransform = false;
        private Schema arrowSchema;

        DownloadSession(String projectName, String schemaName, String tableName, String partitionSpec, Long shardId, String downloadId, boolean async, boolean waitAsyncBuild) throws TunnelException {
            this.conf = TableTunnel.this.config;
            this.projectName = projectName;
            this.schemaName = schemaName;
            this.tableName = tableName;
            this.partitionSpec = partitionSpec;
            this.shardId = shardId;
            this.id = downloadId;
            this.tunnelServiceClient = this.conf.newRestClient(projectName);
            if (this.id == null) {
                this.initiate(async, waitAsyncBuild);
            } else {
                this.reload();
            }
        }

        public TunnelRecordReader openRecordReader(long start, long count) throws TunnelException, IOException {
            return this.openRecordReader(start, count, false);
        }

        public TunnelRecordReader openRecordReader(long start, long count, boolean compress) throws TunnelException, IOException {
            return this.openRecordReader(start, count, compress, null);
        }

        public TunnelRecordReader openRecordReader(long start, long count, CompressOption compress) throws TunnelException, IOException {
            return this.openRecordReader(start, count, compress, null);
        }

        public TunnelRecordReader openRecordReader(long start, long count, boolean compress, List<Column> columns) throws TunnelException, IOException {
            CompressOption option = compress ? new CompressOption() : new CompressOption(CompressOption.CompressAlgorithm.ODPS_RAW, 0, 0);
            return this.openRecordReader(start, count, option, columns);
        }

        public TunnelRecordReader openRecordReader(long start, long count, CompressOption compress, List<Column> columns) throws TunnelException, IOException {
            return this.openRecordReader(start, count, compress, columns, false);
        }

        public TunnelRecordReader openRecordReader(long start, long count, CompressOption compress, List<Column> columns, boolean disableModifiedCheck) throws TunnelException, IOException {
            if (columns != null && columns.isEmpty()) {
                throw new TunnelException("Specified column list is empty.");
            }
            TunnelRecordReader reader = new TunnelRecordReader(start, count, columns, compress, this.tunnelServiceClient, this, disableModifiedCheck);
            reader.setTransform(this.shouldTransform);
            return reader;
        }

        public Schema getArrowSchema() {
            if (this.arrowSchema == null) {
                this.arrowSchema = ArrowUtils.tableSchemaToArrowSchema(this.schema);
            }
            return this.arrowSchema;
        }

        public ArrowRecordReader openArrowRecordReader(long start, long count) throws TunnelException, IOException {
            return this.openArrowRecordReader(start, count, null, null);
        }

        public ArrowRecordReader openArrowRecordReader(long start, long count, CompressOption compress) throws TunnelException, IOException {
            return this.openArrowRecordReader(start, count, null, null, compress);
        }

        public ArrowRecordReader openArrowRecordReader(long start, long count, BufferAllocator allocator) throws TunnelException, IOException {
            return this.openArrowRecordReader(start, count, null, allocator);
        }

        public ArrowRecordReader openArrowRecordReader(long start, long count, List<Column> columns) throws TunnelException, IOException {
            return this.openArrowRecordReader(start, count, columns, null);
        }

        public ArrowRecordReader openArrowRecordReader(long start, long count, List<Column> columns, BufferAllocator allocator) throws TunnelException, IOException {
            return this.openArrowRecordReader(start, count, columns, allocator, new CompressOption(CompressOption.CompressAlgorithm.ODPS_RAW, 0, 0));
        }

        public ArrowRecordReader openArrowRecordReader(long start, long count, List<Column> columns, BufferAllocator allocator, CompressOption compress) throws TunnelException, IOException {
            return this.openArrowRecordReader(start, count, columns, allocator, compress, false);
        }

        public ArrowRecordReader openArrowRecordReader(long start, long count, List<Column> columns, BufferAllocator allocator, CompressOption compress, boolean disableModifiedCheck) throws TunnelException, IOException {
            return new ArrowTunnelRecordReader(start, count, columns, this.tunnelServiceClient, this, allocator, compress, disableModifiedCheck);
        }

        private void initiate(boolean async, boolean wait) throws TunnelException {
            HashMap<String, String> headers = TableTunnel.getCommonHeader();
            List<String> tags = this.conf.getTags();
            if (tags != null) {
                headers.put("odps-tunnel-tags", String.join((CharSequence)",", tags));
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("downloads", null);
            if (async) {
                params.put("asyncmode", "true");
            }
            if (this.partitionSpec != null && this.partitionSpec.length() > 0) {
                params.put("partition", this.partitionSpec);
            }
            if (this.shardId != null) {
                params.put("shard", String.valueOf(this.shardId));
            }
            if (this.conf.availableQuotaName()) {
                params.put("quotaName", this.conf.getQuotaName());
            }
            Connection conn = null;
            try {
                conn = this.tunnelServiceClient.connect(this.getResource(), "POST", params, headers);
                Response resp = conn.getResponse();
                if (resp.isOK()) {
                    this.loadFromJson(conn.getInputStream());
                    this.shouldTransform = StringUtils.equals((String)resp.getHeader("odps-tunnel-date-transform"), (String)"true");
                } else {
                    throw new TunnelException(resp.getHeader("x-odps-request-id"), conn.getInputStream(), resp.getStatus());
                }
                while (this.status == DownloadStatus.INITIATING && wait) {
                    Thread.sleep(TableTunnel.this.random.nextInt(30000) + 5000);
                    this.reload();
                }
            }
            catch (IOException e) {
                throw new TunnelException("Failed to create download session with tunnel endpoint " + this.tunnelServiceClient.getEndpoint(), e);
            }
            catch (TunnelException e) {
                throw e;
            }
            catch (OdpsException e) {
                throw new TunnelException(e.getMessage(), e);
            }
            catch (InterruptedException e) {
                throw new TunnelException(e.getMessage(), e);
            }
            finally {
                if (conn != null) {
                    try {
                        conn.disconnect();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        private void reload() throws TunnelException {
            block15: {
                HashMap<String, String> headers = TableTunnel.getCommonHeader();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("downloadid", this.id);
                if (this.partitionSpec != null && this.partitionSpec.length() > 0) {
                    params.put("partition", this.partitionSpec);
                }
                if (this.shardId != null) {
                    params.put("shard", String.valueOf(this.shardId));
                }
                Connection conn = null;
                try {
                    conn = this.tunnelServiceClient.connect(this.getResource(), "GET", params, headers);
                    Response resp = conn.getResponse();
                    if (resp.isOK()) {
                        this.loadFromJson(conn.getInputStream());
                        this.shouldTransform = StringUtils.equals((String)resp.getHeader("odps-tunnel-date-transform"), (String)"true");
                        break block15;
                    }
                    TunnelException e = new TunnelException(conn.getInputStream());
                    e.setRequestId(resp.getHeader("x-odps-request-id"));
                    throw e;
                }
                catch (IOException e) {
                    throw new TunnelException(e.getMessage(), e);
                }
                catch (TunnelException e) {
                    throw e;
                }
                catch (OdpsException e) {
                    throw new TunnelException(e.getMessage(), e);
                }
                finally {
                    if (conn != null) {
                        try {
                            conn.disconnect();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }

        public TableSchema getSchema() {
            return this.schema;
        }

        public long getRecordCount() {
            return this.count;
        }

        public String getId() {
            return this.id;
        }

        public DownloadStatus getStatus() throws TunnelException, IOException {
            this.reload();
            return this.status;
        }

        public Configuration getConfig() {
            return this.conf;
        }

        public String getPartitionSpec() {
            return this.partitionSpec;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getQuotaName() {
            return this.quotaName;
        }

        public String getRAPInstanceId() {
            return this.RAPInstanceId;
        }

        private String getResource() {
            return this.conf.getResource(this.projectName, this.schemaName, this.tableName);
        }

        private void loadFromJson(InputStream is) throws TunnelException {
            try {
                String json = IOUtils.readStreamAsString(is);
                JsonObject tree = new JsonParser().parse(json).getAsJsonObject();
                if (tree.has("DownloadID")) {
                    this.id = tree.get("DownloadID").getAsString();
                }
                if (tree.has("Status")) {
                    String downloadStatus = tree.get("Status").getAsString().toUpperCase();
                    this.status = DownloadStatus.valueOf(downloadStatus);
                }
                if (tree.has("RecordCount")) {
                    this.count = tree.get("RecordCount").getAsLong();
                }
                if (tree.has("Schema")) {
                    JsonObject tunnelTableSchema = tree.get("Schema").getAsJsonObject();
                    this.schema = new TunnelTableSchema(tunnelTableSchema);
                }
                if (tree.has("QuotaName")) {
                    this.quotaName = tree.get("QuotaName").getAsString();
                }
                if (tree.has("RAPInstanceId")) {
                    this.RAPInstanceId = tree.get("RAPInstanceId").getAsString();
                }
            }
            catch (Exception e) {
                throw new TunnelException("Invalid json content.", e);
            }
        }
    }

    public static enum DownloadStatus {
        UNKNOWN,
        NORMAL,
        CLOSED,
        EXPIRED,
        INITIATING;

    }

    public class UploadSession {
        private String id;
        private TableSchema schema = new TableSchema();
        private String projectName;
        private String schemaName;
        private String tableName;
        private String partitionSpec;
        private Long fieldMaxSize;
        private List<Long> blocks = new ArrayList<Long>();
        private UploadStatus status = UploadStatus.UNKNOWN;
        private String quotaName;
        private Configuration conf;
        private RestClient tunnelServiceClient;
        private final Long totalBLocks = 20000L;
        private Long shares = 1L;
        private Long curBlockId = 0L;
        private static final int RETRY_SLEEP_SECONDS = 5;
        private boolean shouldTransform = false;
        private boolean overwrite = false;
        private boolean fetchBlockId = true;
        private Schema arrowSchema;

        UploadSession(String projectName, String schemaName, String tableName, String partitionSpec, String uploadId, boolean overwrite) throws TunnelException {
            this(projectName, schemaName, tableName, partitionSpec, uploadId, overwrite, true);
        }

        UploadSession(String projectName, String schemaName, String tableName, String partitionSpec, String uploadId, boolean overwrite, boolean fetchBlockId) throws TunnelException {
            this.conf = TableTunnel.this.config;
            this.projectName = projectName;
            this.schemaName = schemaName;
            this.tableName = tableName;
            this.partitionSpec = partitionSpec;
            this.id = uploadId;
            this.overwrite = overwrite;
            this.fetchBlockId = fetchBlockId;
            this.tunnelServiceClient = this.conf.newRestClient(projectName);
            this.initiateOrReload();
        }

        private void initiateOrReload() throws TunnelException {
            TunnelRetryHandler retryHandler = new TunnelRetryHandler(this.conf);
            try {
                retryHandler.executeWithRetry(() -> {
                    if (this.id == null) {
                        this.initiate();
                    } else {
                        this.reload();
                    }
                    return null;
                });
            }
            catch (TunnelException | RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TunnelException(e.getMessage(), e);
            }
        }

        private void initiate() throws TunnelException {
            block17: {
                HashMap<String, String> headers = TableTunnel.getCommonHeader();
                List<String> tags = this.conf.getTags();
                if (tags != null) {
                    headers.put("odps-tunnel-tags", String.join((CharSequence)",", tags));
                }
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("uploads", null);
                if (this.partitionSpec != null && this.partitionSpec.length() > 0) {
                    params.put("partition", this.partitionSpec);
                }
                if (this.overwrite) {
                    params.put("overwrite", "true");
                }
                if (this.conf.availableQuotaName()) {
                    params.put("quotaName", this.conf.getQuotaName());
                }
                Connection conn = null;
                try {
                    conn = this.tunnelServiceClient.connect(this.getResource(), "POST", params, headers);
                    Response resp = conn.getResponse();
                    if (resp.isOK()) {
                        this.loadFromJson(conn.getInputStream());
                        this.shouldTransform = StringUtils.equals((String)resp.getHeader("odps-tunnel-date-transform"), (String)"true");
                        break block17;
                    }
                    throw new TunnelException(resp.getHeader("x-odps-request-id"), conn.getInputStream(), resp.getStatus());
                }
                catch (IOException e) {
                    throw new TunnelException("Failed to create upload session with tunnel endpoint " + this.tunnelServiceClient.getEndpoint(), e);
                }
                catch (TunnelException e) {
                    throw e;
                }
                catch (OdpsException e) {
                    throw new TunnelException(e.getMessage(), e);
                }
                finally {
                    if (conn != null) {
                        try {
                            conn.disconnect();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }

        public boolean isShouldTransform() {
            return this.shouldTransform;
        }

        public synchronized Long getAvailBlockId() {
            if (this.curBlockId >= this.totalBLocks) {
                throw new RuntimeException("No more available blockId, already " + this.curBlockId);
            }
            Long old = this.curBlockId;
            this.curBlockId = this.curBlockId + this.shares;
            return old;
        }

        public void commit() throws TunnelException, IOException {
            this.completeUpload();
        }

        public void writeBlock(long blockId, RecordPack pack) throws IOException {
            this.writeBlock(blockId, pack, 0L);
        }

        public void writeBlock(long blockId, RecordPack pack, long timeout) throws IOException {
            this.writeBlockInternal(blockId, pack, timeout, 0L);
        }

        public void writeBlock(long blockId, RecordPack pack, long timeout, long blockVersion) throws IOException, TunnelException {
            TableTunnel.checkBlockVersion(blockVersion);
            this.writeBlockInternal(blockId, pack, timeout, blockVersion);
        }

        private void writeBlockInternal(long blockId, RecordPack pack, long timeout, long blockVersion) throws IOException {
            TunnelRetryHandler retryHandler = new TunnelRetryHandler(this.conf);
            try {
                retryHandler.executeWithRetry(() -> {
                    Connection conn = null;
                    try {
                        if (pack instanceof ProtobufRecordPack) {
                            ProtobufRecordPack protoPack = (ProtobufRecordPack)pack;
                            conn = this.getConnection(blockId, protoPack.getCompressOption(), blockVersion);
                            this.sendBlock(protoPack, conn, timeout);
                        } else {
                            Record record;
                            RecordWriter writer = this.openRecordWriter(blockId);
                            RecordReader reader = pack.getRecordReader();
                            while ((record = reader.read()) != null) {
                                writer.write(record);
                            }
                            writer.close();
                        }
                    }
                    finally {
                        if (conn != null) {
                            try {
                                conn.disconnect();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    return null;
                });
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        private void sendBlock(ProtobufRecordPack pack, Connection conn) throws IOException {
            this.sendBlock(pack, conn, 0L);
        }

        private void sendBlock(ProtobufRecordPack pack, Connection conn, long timeout) throws IOException {
            if (null == conn) {
                throw new IOException("Invalid connection");
            }
            pack.checkTransConsistency(this.shouldTransform);
            pack.complete();
            ByteArrayOutputStream baos = pack.getProtobufStream();
            if (timeout > 0L) {
                ConnectionWatcher.getInstance().mark(conn, timeout);
            }
            Response response = null;
            try {
                baos.writeTo(conn.getOutputStream());
                conn.getOutputStream().close();
                baos.close();
                response = conn.getResponse();
            }
            catch (Throwable tr) {
                if (timeout > 0L && ConnectionWatcher.getInstance().checkTimedOut(conn)) {
                    throw new SocketTimeoutException("Flush time exceeded timeout user set: " + timeout + "ms");
                }
                throw tr;
            }
            finally {
                if (timeout > 0L) {
                    ConnectionWatcher.getInstance().release(conn);
                }
            }
            if (!response.isOK()) {
                TunnelException exception = new TunnelException(response.getHeader("x-odps-request-id"), conn.getInputStream(), response.getStatus());
                throw new IOException(exception.getMessage(), exception);
            }
        }

        public RecordWriter openRecordWriter(long blockId) throws TunnelException, IOException {
            return this.openRecordWriter(blockId, false);
        }

        public RecordWriter openRecordWriter(long blockId, boolean compress) throws TunnelException, IOException {
            CompressOption option = compress ? new CompressOption() : new CompressOption(CompressOption.CompressAlgorithm.ODPS_RAW, 0, 0);
            return this.openRecordWriter(blockId, option);
        }

        public RecordWriter openRecordWriter(long blockId, CompressOption compress) throws TunnelException, IOException {
            return this.openRecordWriterInternal(blockId, compress, 0L);
        }

        public RecordWriter openRecordWriter(long blockId, CompressOption compress, long blockVersion) throws TunnelException, IOException {
            TableTunnel.checkBlockVersion(blockVersion);
            return this.openRecordWriterInternal(blockId, compress, blockVersion);
        }

        private RecordWriter openRecordWriterInternal(long blockId, CompressOption compress, long blockVersion) throws TunnelException {
            TunnelRetryHandler retryHandler = new TunnelRetryHandler(this.conf);
            try {
                return retryHandler.executeWithRetry(() -> {
                    Connection conn = null;
                    try {
                        TunnelRecordWriter writer = null;
                        conn = this.getConnection(blockId, compress, blockVersion);
                        writer = new TunnelRecordWriter(this.schema, conn, compress);
                        writer.setTransform(this.shouldTransform);
                        return writer;
                    }
                    catch (IOException e) {
                        if (conn != null) {
                            try {
                                conn.disconnect();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        throw e;
                    }
                });
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new TunnelException(e.getMessage(), e);
            }
        }

        public RecordWriter openBufferedWriter() throws TunnelException {
            return this.openBufferedWriter(false);
        }

        public RecordWriter openBufferedWriter(boolean compress) throws TunnelException {
            CompressOption compressOption = compress ? this.conf.getCompressOption() : new CompressOption(CompressOption.CompressAlgorithm.ODPS_RAW, 0, 0);
            return this.openBufferedWriter(compressOption);
        }

        public RecordWriter openBufferedWriter(CompressOption compressOption) throws TunnelException {
            return this.openBufferedWriter(compressOption, 0L);
        }

        public RecordWriter openBufferedWriter(CompressOption compressOption, long timeout) throws TunnelException {
            return this.openBufferedWriter(compressOption, timeout, null);
        }

        public RecordWriter openBufferedWriter(CompressOption compressOption, long timeout, BlockVersionProvider versionProvider) throws TunnelException {
            try {
                return new TunnelBufferedWriter(this, compressOption, timeout, versionProvider);
            }
            catch (IOException e) {
                throw new TunnelException(e.getMessage(), e.getCause());
            }
        }

        public Schema getArrowSchema() {
            if (this.arrowSchema == null) {
                this.arrowSchema = ArrowUtils.tableSchemaToArrowSchema(this.schema);
            }
            return this.arrowSchema;
        }

        public ArrowRecordWriter openArrowRecordWriter(long blockId) throws TunnelException, IOException {
            return this.openArrowRecordWriter(blockId, new CompressOption(CompressOption.CompressAlgorithm.ODPS_RAW, 0, 0));
        }

        public ArrowRecordWriter openArrowRecordWriter(long blockId, CompressOption option) throws TunnelException, IOException {
            return this.openArrowRecordWriterInternal(blockId, option, 0L);
        }

        public ArrowRecordWriter openArrowRecordWriter(long blockId, CompressOption option, long blockVersion) throws TunnelException, IOException {
            TableTunnel.checkBlockVersion(blockVersion);
            return this.openArrowRecordWriterInternal(blockId, option, blockVersion);
        }

        private ArrowRecordWriter openArrowRecordWriterInternal(long blockId, CompressOption option, long blockVersion) throws TunnelException, IOException {
            ArrowTunnelRecordWriter arrowTunnelRecordWriter = null;
            Connection conn = null;
            try {
                conn = this.getConnection(blockId, true, option, blockVersion);
                arrowTunnelRecordWriter = new ArrowTunnelRecordWriter(this, conn, option);
            }
            catch (IOException e) {
                if (conn != null) {
                    conn.disconnect();
                }
                throw new TunnelException(e.getMessage(), e.getCause());
            }
            catch (TunnelException e) {
                throw e;
            }
            catch (OdpsException e) {
                throw new TunnelException(e.getMessage(), e);
            }
            return arrowTunnelRecordWriter;
        }

        private Connection getConnection(long blockId, CompressOption compress, long blockVersion) throws OdpsException, IOException {
            return this.getConnection(blockId, false, compress, blockVersion);
        }

        private Connection getConnection(long blockId, boolean isArrow, CompressOption compress, long blockVersion) throws OdpsException, IOException {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Transfer-Encoding", "chunked");
            headers.put("Content-Type", "application/octet-stream");
            headers.put("x-odps-tunnel-version", String.valueOf(5));
            switch (compress.algorithm) {
                case ODPS_RAW: {
                    break;
                }
                case ODPS_ZLIB: {
                    headers.put("Content-Encoding", "deflate");
                    break;
                }
                case ODPS_SNAPPY: {
                    headers.put("Content-Encoding", "x-snappy-framed");
                    break;
                }
                case ODPS_LZ4_FRAME: {
                    headers.put("Content-Encoding", "x-lz4-frame");
                    break;
                }
                case ODPS_ARROW_LZ4_FRAME: {
                    headers.put("Content-Encoding", "x-odps-lz4-frame");
                    break;
                }
                default: {
                    throw new TunnelException("invalid compression option.");
                }
            }
            List<String> tags = this.conf.getTags();
            if (tags != null) {
                headers.put("odps-tunnel-tags", String.join((CharSequence)",", tags));
            }
            HashMap<String, String> params = new HashMap<String, String>();
            if (blockVersion > 0L) {
                params.put("block_version", Long.toString(blockVersion));
            }
            params.put("uploadid", this.id);
            params.put("blockid", Long.toString(blockId));
            if (isArrow) {
                params.put("arrow", "");
            }
            if (this.partitionSpec != null && this.partitionSpec.length() > 0) {
                params.put("partition", this.partitionSpec);
            }
            if (this.conf.availableQuotaName()) {
                params.put("quotaName", this.conf.getQuotaName());
            }
            return this.tunnelServiceClient.connect(this.getResource(), "PUT", params, headers);
        }

        private void reload() throws TunnelException {
            block16: {
                HashMap<String, String> headers = TableTunnel.getCommonHeader();
                List<String> tags = this.conf.getTags();
                if (tags != null) {
                    headers.put("odps-tunnel-tags", String.join((CharSequence)",", tags));
                }
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("uploadid", this.id);
                if (this.partitionSpec != null && this.partitionSpec.length() > 0) {
                    params.put("partition", this.partitionSpec);
                }
                params.put("getblockid", String.valueOf(this.fetchBlockId));
                if (this.conf.availableQuotaName()) {
                    params.put("quotaName", this.conf.getQuotaName());
                }
                Connection conn = null;
                try {
                    conn = this.tunnelServiceClient.connect(this.getResource(), "GET", params, headers);
                    Response resp = conn.getResponse();
                    if (resp.isOK()) {
                        this.loadFromJson(conn.getInputStream());
                        this.shouldTransform = StringUtils.equals((String)resp.getHeader("odps-tunnel-date-transform"), (String)"true");
                        break block16;
                    }
                    TunnelException e = new TunnelException(conn.getInputStream());
                    throw e;
                }
                catch (IOException e) {
                    throw new TunnelException(e.getMessage(), e);
                }
                catch (TunnelException e) {
                    throw e;
                }
                catch (OdpsException e) {
                    throw new TunnelException(e.getMessage(), e);
                }
                finally {
                    if (conn != null) {
                        try {
                            conn.disconnect();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }

        public void commit(Long[] blocks) throws TunnelException, IOException {
            if (blocks == null) {
                throw new IllegalArgumentException("Invalid argument: blocks.");
            }
            HashMap<Long, Boolean> clientBlockMap = new HashMap<Long, Boolean>();
            for (Long blockId : blocks) {
                clientBlockMap.put(blockId, true);
            }
            Long[] serverBlocks = this.getBlockList();
            HashMap<Long, Boolean> serverBlockMap = new HashMap<Long, Boolean>();
            for (Long blockId : serverBlocks) {
                serverBlockMap.put(blockId, true);
            }
            if (serverBlockMap.size() != clientBlockMap.size()) {
                throw new TunnelException("Blocks not match, server: " + serverBlockMap.size() + ", tunnelServiceClient: " + clientBlockMap.size());
            }
            for (Long blockId : blocks) {
                if (serverBlockMap.containsKey(blockId)) continue;
                throw new TunnelException("Block not exsits on server, block id is " + blockId);
            }
            this.completeUpload();
        }

        private void completeUpload() throws TunnelException, IOException {
            HashMap<String, String> headers = TableTunnel.getCommonHeader();
            List<String> tags = this.conf.getTags();
            if (tags != null) {
                headers.put("odps-tunnel-tags", String.join((CharSequence)",", tags));
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("uploadid", this.id);
            if (this.partitionSpec != null && this.partitionSpec.length() > 0) {
                params.put("partition", this.partitionSpec);
            }
            if (this.conf.availableQuotaName()) {
                params.put("quotaName", this.conf.getQuotaName());
            }
            TunnelRetryHandler retryHandler = new TunnelRetryHandler(this.conf);
            try {
                retryHandler.executeWithRetry(() -> {
                    Connection conn = null;
                    try {
                        conn = this.tunnelServiceClient.connect(this.getResource(), "POST", params, headers);
                        Response resp = conn.getResponse();
                        if (resp.isOK()) {
                            this.loadFromJson(conn.getInputStream());
                            Object var5_5 = null;
                            return var5_5;
                        }
                        throw new TunnelException(resp.getHeader("x-odps-request-id"), conn.getInputStream(), resp.getStatus());
                    }
                    finally {
                        if (conn != null) {
                            try {
                                conn.disconnect();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                });
            }
            catch (TunnelException | RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TunnelException(e.getMessage(), e);
            }
        }

        public String getId() {
            return this.id;
        }

        public TableSchema getSchema() {
            return this.schema;
        }

        public String getQuotaName() {
            return this.quotaName;
        }

        public UploadStatus getStatus() throws TunnelException, IOException {
            this.reload();
            return this.status;
        }

        public Configuration getConfig() {
            return this.conf;
        }

        public Record newRecord() {
            return new ArrayRecord(this.getSchema().getColumns().toArray(new Column[0]), true, this.fieldMaxSize);
        }

        public RecordPack newRecordPack() throws IOException {
            return this.newRecordPack(null);
        }

        public RecordPack newRecordPack(CompressOption option) throws IOException {
            return this.newRecordPack(0, option);
        }

        public RecordPack newRecordPack(int capacity, CompressOption option) throws IOException {
            ProtobufRecordPack pack = new ProtobufRecordPack(this.schema, new Checksum(), capacity, option);
            pack.setTransform(this.shouldTransform);
            return pack;
        }

        public Long[] getBlockList() throws TunnelException, IOException {
            this.reload();
            return this.blocks.toArray(new Long[0]);
        }

        public String getResource() {
            return this.conf.getResource(this.projectName, this.schemaName, this.tableName);
        }

        private void loadFromJson(InputStream is) throws TunnelException {
            try {
                String json = IOUtils.readStreamAsString(is);
                JsonObject tree = new JsonParser().parse(json).getAsJsonObject();
                if (tree.has("UploadID")) {
                    this.id = tree.get("UploadID").getAsString();
                }
                if (tree.has("Status")) {
                    String uploadStatus = tree.get("Status").getAsString().toUpperCase();
                    this.status = UploadStatus.valueOf(uploadStatus);
                }
                this.blocks.clear();
                if (tree.has("UploadedBlockList")) {
                    JsonArray blockList = tree.get("UploadedBlockList").getAsJsonArray();
                    for (int i = 0; i < blockList.size(); ++i) {
                        if (!blockList.get(i).getAsJsonObject().has("BlockID")) continue;
                        this.blocks.add(blockList.get(i).getAsJsonObject().get("BlockID").getAsLong());
                    }
                }
                if (tree.has("Schema")) {
                    JsonObject tunnelTableSchema = tree.get("Schema").getAsJsonObject();
                    this.schema = new TunnelTableSchema(tunnelTableSchema);
                }
                if (tree.has("MaxFieldSize")) {
                    this.fieldMaxSize = tree.get("MaxFieldSize").getAsLong();
                }
                if (tree.has("QuotaName")) {
                    this.quotaName = tree.get("QuotaName").getAsString();
                }
            }
            catch (Exception e) {
                throw new TunnelException("Invalid json content.", e);
            }
        }
    }

    public static enum UploadStatus {
        UNKNOWN,
        NORMAL,
        CLOSING,
        CLOSED,
        CANCELED,
        EXPIRED,
        CRITICAL,
        COMMITTING;

    }

    public static interface UpsertSession
    extends Closeable {
        public String getId();

        public String getQuotaName();

        public String getStatus() throws TunnelException;

        public TableSchema getSchema();

        public void commit(boolean var1) throws TunnelException;

        public void abort() throws TunnelException;

        @Override
        public void close();

        public Record newRecord();

        public UpsertStream.Builder buildUpsertStream();

        public static interface Builder {
            public String getUpsertId();

            public Builder setUpsertId(String var1);

            public String getSchemaName();

            public Builder setSchemaName(String var1);

            public String getPartitionSpec();

            public Builder setPartitionSpec(PartitionSpec var1);

            public Builder setPartitionSpec(String var1);

            public long getSlotNum();

            public Builder setSlotNum(long var1);

            public long getCommitTimeout();

            public Builder setCommitTimeout(long var1);

            public Builder setNetworkThreadNum(int var1);

            public Builder setConcurrentNum(int var1);

            public Builder setConnectTimeout(long var1);

            public Builder setReadTimeout(long var1);

            public long getLifecycle();

            public Builder setLifecycle(long var1);

            public UpsertSession build() throws TunnelException, IOException;
        }
    }

    public static interface StreamUploadSession {
        public void setP2pMode(boolean var1);

        public String getId();

        public TableSchema getSchema();

        public String getSchemaVersion();

        public String getQuotaName();

        public StreamRecordPack newRecordPack() throws IOException;

        public StreamRecordPack newRecordPack(CompressOption var1) throws IOException, TunnelException;

        public Record newRecord();

        public static abstract class Builder {
            private String schemaName;
            private PartitionSpec partitionSpec;
            private long slotNum = 0L;
            private boolean createPartition = false;
            private String schemaVersion;
            protected boolean allowSchemaMismatch = true;

            public String getSchemaName() {
                return this.schemaName;
            }

            public Builder setSchemaName(String schemaName) {
                this.schemaName = schemaName;
                return this;
            }

            public String getPartitionSpec() {
                return this.partitionSpec == null ? null : this.partitionSpec.toString().replaceAll("'", "");
            }

            public Builder setPartitionSpec(PartitionSpec spec) {
                this.partitionSpec = spec;
                return this;
            }

            public Builder setPartitionSpec(String spec) {
                this.partitionSpec = spec == null ? null : new PartitionSpec(spec);
                return this;
            }

            public long getSlotNum() {
                return this.slotNum;
            }

            public Builder setSlotNum(long slotNum) {
                this.slotNum = slotNum;
                return this;
            }

            public Builder setSchemaVersion(String schemaVersion) {
                this.schemaVersion = schemaVersion;
                return this;
            }

            public String getSchemaVersion() {
                return this.schemaVersion;
            }

            public boolean isCreatePartition() {
                return this.createPartition;
            }

            public Builder setCreatePartition(boolean createPartition) {
                this.createPartition = createPartition;
                return this;
            }

            public Builder allowSchemaMismatch(boolean allowSchemaMismatch) {
                this.allowSchemaMismatch = allowSchemaMismatch;
                return this;
            }

            public abstract StreamUploadSession build() throws TunnelException;
        }
    }

    public static class FlushOption {
        private long timeout = 0L;

        public FlushOption timeout(long tm) {
            this.timeout = tm;
            return this;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public void setTimeout(long timeout) {
            this.timeout = timeout;
        }
    }

    public static interface StreamRecordPack {
        public void append(Record var1) throws IOException;

        public long getRecordCount();

        public long getDataSize();

        public String flush() throws IOException;

        public FlushResult flush(FlushOption var1) throws IOException;

        public void reset() throws IOException;
    }

    public static interface FlushResult {
        public String getTraceId();

        public long getFlushSize();

        public long getRecordCount();
    }

    public static interface BlockVersionProvider {
        public long generateVersion(long var1);
    }
}

