/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.record.accessor;

import com.aliyun.odps.table.arrow.accessor.ArrowArrayAccessor;
import com.aliyun.odps.table.arrow.accessor.ArrowVectorAccessor;
import com.aliyun.odps.table.record.accessor.ArrowToRecordConverter;
import com.aliyun.odps.type.ArrayTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.ListVector;

public class ArrowArrayAccessorImpl {

    public static class ArrowArrayAccessorForRecord
    extends ArrowArrayAccessor<List<Object>> {
        private final boolean isExtension;
        private final TypeInfo elementTypeInfo;
        private final ArrowVectorAccessor dataAccessor;

        public ArrowArrayAccessorForRecord(ListVector vector, TypeInfo typeInfo, boolean isExtension) {
            super(vector);
            this.isExtension = isExtension;
            this.elementTypeInfo = ((ArrayTypeInfo)typeInfo).getElementTypeInfo();
            this.dataAccessor = ArrowToRecordConverter.createColumnVectorAccessor((ValueVector)vector.getDataVector(), this.elementTypeInfo, isExtension);
        }

        @Override
        protected List<Object> getArrayData(int offset, int length) {
            ArrayList<Object> list = new ArrayList<Object>();
            try {
                for (int i = 0; i < length; ++i) {
                    list.add(ArrowToRecordConverter.getData(this.dataAccessor, this.elementTypeInfo, offset + i, this.isExtension));
                }
                return list;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not get the array", e);
            }
        }
    }
}

