/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.arrow.accessor;

import com.aliyun.odps.table.arrow.accessor.ArrowVectorAccessor;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.StructVector;

public class ArrowTimestampExtensionAccessor
extends ArrowVectorAccessor {
    protected final BigIntVector sec;
    protected final IntVector nano;

    public ArrowTimestampExtensionAccessor(StructVector structVector) {
        super((ValueVector)structVector);
        this.sec = (BigIntVector)structVector.getVectorById(0);
        this.nano = (IntVector)structVector.getVectorById(1);
    }

    public LocalDateTime getTimestampNtz(int index) {
        return LocalDateTime.ofEpochSecond(this.sec.get(index), this.nano.get(index), ZoneOffset.UTC);
    }

    public Instant getTimestamp(int index) {
        return Instant.ofEpochSecond(this.sec.get(index), this.nano.get(index));
    }
}

