/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table;

import com.aliyun.odps.table.utils.Preconditions;
import com.aliyun.odps.utils.NameSpaceSchemaUtils;
import java.io.Serializable;
import java.util.Objects;

public class TableIdentifier
implements Serializable {
    private final String project;
    private final String schema;
    private final String table;

    public static TableIdentifier of(String project, String table) {
        return new TableIdentifier(project, table);
    }

    public static TableIdentifier of(String project, String schema, String table) {
        return new TableIdentifier(project, schema, table);
    }

    public TableIdentifier(String project, String table) {
        this(project, "default", table);
    }

    public TableIdentifier(String project, String schema, String table) {
        Preconditions.checkString(project, "Identifier project cannot be null");
        Preconditions.checkString(table, "Identifier table cannot be null");
        this.project = project;
        this.schema = schema;
        this.table = table;
    }

    public String getProject() {
        return this.project;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTable() {
        return this.table;
    }

    public String toString() {
        return NameSpaceSchemaUtils.getFullName(this.project, this.schema, this.table);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableIdentifier that = (TableIdentifier)o;
        return Objects.equals(this.project, that.project) && Objects.equals(this.schema, that.schema) && Objects.equals(this.table, that.table);
    }

    public int hashCode() {
        return Objects.hash(this.project, this.schema, this.table);
    }
}

