/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.sqa.commandapi;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Table;
import com.aliyun.odps.TableFilter;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.sqa.commandapi.Command;
import com.aliyun.odps.sqa.commandapi.CommandInfo;
import com.aliyun.odps.sqa.commandapi.RecordIter;
import com.aliyun.odps.sqa.commandapi.utils.CommandUtil;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class ShowTablesCommand
implements Command {
    private static final Map<String, TypeInfo> showTablesMap = new LinkedHashMap<String, TypeInfo>();
    private String project;
    private String schema;
    private String prefix;

    public ShowTablesCommand(String project, String schema, String prefix) {
        this.project = project;
        this.schema = schema;
        this.prefix = prefix;
    }

    @Override
    public boolean isSync() {
        return true;
    }

    @Override
    public List<TypeInfo> getResultTypes() {
        return new ArrayList<TypeInfo>(showTablesMap.values());
    }

    @Override
    public List<String> getResultHeaders() {
        return new ArrayList<String>(showTablesMap.keySet());
    }

    @Override
    public RecordIter run(Odps odps, CommandInfo commandInfo) throws OdpsException {
        TableFilter prefixFilter = new TableFilter();
        prefixFilter.setName(this.prefix);
        boolean useOdpsNamespaceSchema = commandInfo.isOdpsNamespaceSchema();
        String schemaCopy = this.schema;
        this.schema = CommandUtil.getRealSchemaName(odps, this.project, this.schema, useOdpsNamespaceSchema);
        this.project = CommandUtil.getRealProjectName(odps, this.project, schemaCopy, useOdpsNamespaceSchema);
        Iterator<Table> it = odps.tables().iterator(this.project, this.schema, prefixFilter, false);
        return new TableRecordIter(it, this.getResultHeaders(), this.getResultTypes());
    }

    static {
        showTablesMap.put("Owner", (TypeInfo)TypeInfoFactory.STRING);
        showTablesMap.put("TableName", (TypeInfo)TypeInfoFactory.STRING);
    }

    static class TableRecordIter
    extends RecordIter<Table> {
        TableRecordIter(Iterator<Table> it, List<String> headers, List<TypeInfo> typeInfos) {
            super(it, headers, typeInfos);
        }

        @Override
        Record toRecord(Table table) {
            ArrayRecord record = new ArrayRecord(this.columns);
            record.set(0, (Object)table.getOwner());
            record.set(1, (Object)table.getName());
            return record;
        }
    }
}

