/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.sqa.commandapi;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Task;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.sqa.commandapi.Command;
import com.aliyun.odps.sqa.commandapi.CommandInfo;
import com.aliyun.odps.sqa.commandapi.RecordIter;
import com.aliyun.odps.sqa.commandapi.utils.CommandUtil;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class DescribeInstanceCommand
implements Command {
    private static final Map<String, TypeInfo> instanceMap = new LinkedHashMap<String, TypeInfo>();
    private String instanceId;

    public DescribeInstanceCommand(String instanceId) {
        this.instanceId = instanceId;
    }

    @Override
    public boolean isSync() {
        return true;
    }

    @Override
    public List<TypeInfo> getResultTypes() {
        return new ArrayList<TypeInfo>(instanceMap.values());
    }

    @Override
    public List<String> getResultHeaders() {
        return new ArrayList<String>(instanceMap.keySet());
    }

    @Override
    public RecordIter<Record> run(Odps odps, CommandInfo commandInfo) throws OdpsException {
        String projectName = odps.getDefaultProject();
        if (!odps.instances().exists(projectName, this.instanceId)) {
            throw new RuntimeException("Instance not found : " + this.instanceId);
        }
        Instance i = odps.instances().get(projectName, this.instanceId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ID", i.getId());
        map.put("Owner", i.getOwner());
        map.put("StartTime", i.getStartTime());
        map.put("EndTime", i.getEndTime());
        map.put("InstanceStatus", i.getStatus().toString());
        LinkedHashMap<String, String> taskStatusMap = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Instance.TaskStatus> entry : i.getTaskStatus().entrySet()) {
            taskStatusMap.put(entry.getKey(), entry.getValue().toString());
        }
        map.put("TaskStatus", taskStatusMap);
        ArrayList<String> queryList = new ArrayList<String>();
        for (Task task : i.getTasks()) {
            queryList.add(task.getCommandText());
        }
        map.put("Query", queryList);
        return new RecordIter<Record>(CommandUtil.toRecord(map, instanceMap).iterator(), this.getResultHeaders(), this.getResultTypes());
    }

    static {
        instanceMap.put("ID", (TypeInfo)TypeInfoFactory.STRING);
        instanceMap.put("Owner", (TypeInfo)TypeInfoFactory.STRING);
        instanceMap.put("StartTime", (TypeInfo)TypeInfoFactory.DATETIME);
        instanceMap.put("EndTime", (TypeInfo)TypeInfoFactory.DATETIME);
        instanceMap.put("InstanceStatus", (TypeInfo)TypeInfoFactory.STRING);
        instanceMap.put("TaskStatus", (TypeInfo)TypeInfoFactory.getMapTypeInfo((TypeInfo)TypeInfoFactory.STRING, (TypeInfo)TypeInfoFactory.STRING));
        instanceMap.put("Query", (TypeInfo)TypeInfoFactory.getArrayTypeInfo((TypeInfo)TypeInfoFactory.STRING));
    }
}

