/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.sqa.commandapi;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.sqa.commandapi.CommandInfo;
import com.aliyun.odps.sqa.commandapi.MergeTaskCommand;
import com.aliyun.odps.sqa.commandapi.RecordIter;
import com.aliyun.odps.utils.StringUtils;
import java.util.HashMap;

class CompactCommand
extends MergeTaskCommand {
    private String compactType;

    public CompactCommand(String tableName, String partition, String compactType) {
        super(tableName, partition);
        this.compactType = compactType;
    }

    private boolean checkTransactional(String tablePart, Odps odps) {
        String projectName = odps.getDefaultProject();
        String tableName = tablePart.split("\\s+")[0];
        if (tableName.contains(".")) {
            tableName = tableName.split("\\.")[1];
        }
        return odps.tables().get(projectName, tableName).isTransactional();
    }

    @Override
    public boolean isSync() {
        return false;
    }

    @Override
    public RecordIter<Record> run(Odps odps, CommandInfo commandInfo) throws OdpsException {
        String tableInfo = this.getTableName() + " " + this.getPartition();
        if (!this.checkTransactional(tableInfo, odps)) {
            throw new OdpsException(tableInfo + " is not a transactional table.");
        }
        this.compactType = CompactCommand.getCompactType(this.compactType.trim());
        if (this.compactType == null) {
            throw new RuntimeException("Compact type should be MAJOR or MINOR.");
        }
        String taskNamePrefix = "console_merge_task_";
        HashMap<String, String> settingMap = new HashMap<String, String>();
        settingMap.put("odps.merge.txn.table.compact", this.compactType);
        settingMap.put("odps.merge.restructure.action", "hardlink");
        return this.mergeTaskRun(odps, commandInfo, taskNamePrefix, settingMap);
    }

    private static String getCompactType(String type) {
        if (StringUtils.isNullOrEmpty((String)type)) {
            return null;
        }
        if (type.equalsIgnoreCase("major")) {
            return "major_compact";
        }
        if (type.equalsIgnoreCase("minor")) {
            return "minor_compact";
        }
        return null;
    }
}

