/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.simpleframework.xml.core;

import com.aliyun.odps.simpleframework.xml.core.Creator;
import com.aliyun.odps.simpleframework.xml.core.Criteria;
import com.aliyun.odps.simpleframework.xml.core.Detail;
import com.aliyun.odps.simpleframework.xml.core.Instantiator;
import com.aliyun.odps.simpleframework.xml.core.Parameter;
import com.aliyun.odps.simpleframework.xml.core.ParameterMap;
import com.aliyun.odps.simpleframework.xml.core.PersistenceException;
import java.util.ArrayList;
import java.util.List;

class ClassInstantiator
implements Instantiator {
    private final List<Creator> creators;
    private final ParameterMap registry;
    private final Creator primary;
    private final Detail detail;

    public ClassInstantiator(List<Creator> creators, Creator primary, ParameterMap registry, Detail detail) {
        this.creators = creators;
        this.registry = registry;
        this.primary = primary;
        this.detail = detail;
    }

    @Override
    public boolean isDefault() {
        int count = this.creators.size();
        if (count <= 1) {
            return this.primary != null;
        }
        return false;
    }

    @Override
    public Object getInstance() throws Exception {
        return this.primary.getInstance();
    }

    @Override
    public Object getInstance(Criteria criteria) throws Exception {
        Creator creator = this.getCreator(criteria);
        if (creator == null) {
            throw new PersistenceException("Constructor not matched for %s", this.detail);
        }
        return creator.getInstance(criteria);
    }

    private Creator getCreator(Criteria criteria) throws Exception {
        Creator result = this.primary;
        double max = 0.0;
        for (Creator instantiator : this.creators) {
            double score = instantiator.getScore(criteria);
            if (!(score > max)) continue;
            result = instantiator;
            max = score;
        }
        return result;
    }

    @Override
    public Parameter getParameter(String name) {
        return (Parameter)this.registry.get(name);
    }

    @Override
    public List<Parameter> getParameters() {
        return this.registry.getAll();
    }

    @Override
    public List<Creator> getCreators() {
        return new ArrayList<Creator>(this.creators);
    }

    public String toString() {
        return String.format("creator for %s", this.detail);
    }
}

