/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.simpleframework.xml.core;

import com.aliyun.odps.simpleframework.xml.Attribute;
import com.aliyun.odps.simpleframework.xml.core.Contact;
import com.aliyun.odps.simpleframework.xml.core.Context;
import com.aliyun.odps.simpleframework.xml.core.Converter;
import com.aliyun.odps.simpleframework.xml.core.Decorator;
import com.aliyun.odps.simpleframework.xml.core.Expression;
import com.aliyun.odps.simpleframework.xml.core.Introspector;
import com.aliyun.odps.simpleframework.xml.core.Primitive;
import com.aliyun.odps.simpleframework.xml.core.Qualifier;
import com.aliyun.odps.simpleframework.xml.core.TemplateLabel;
import com.aliyun.odps.simpleframework.xml.stream.Format;
import com.aliyun.odps.simpleframework.xml.stream.Style;
import java.lang.annotation.Annotation;

class AttributeLabel
extends TemplateLabel {
    private Decorator decorator;
    private Introspector detail;
    private Expression path;
    private Attribute label;
    private Format format;
    private Class type;
    private String name;
    private String empty;
    private boolean required;

    public AttributeLabel(Contact contact, Attribute label, Format format) {
        this.detail = new Introspector(contact, this, format);
        this.decorator = new Qualifier(contact);
        this.required = label.required();
        this.type = contact.getType();
        this.empty = label.empty();
        this.name = label.name();
        this.format = format;
        this.label = label;
    }

    @Override
    public Decorator getDecorator() throws Exception {
        return this.decorator;
    }

    @Override
    public Converter getConverter(Context context) throws Exception {
        String ignore = this.getEmpty(context);
        Contact type = this.getContact();
        return new Primitive(context, type, ignore);
    }

    @Override
    public String getEmpty(Context context) {
        if (this.detail.isEmpty(this.empty)) {
            return null;
        }
        return this.empty;
    }

    @Override
    public String getName() throws Exception {
        Style style = this.format.getStyle();
        String name = this.detail.getName();
        return style.getAttribute(name);
    }

    @Override
    public String getPath() throws Exception {
        Expression path = this.getExpression();
        String name = this.getName();
        return path.getAttribute(name);
    }

    @Override
    public Expression getExpression() throws Exception {
        if (this.path == null) {
            this.path = this.detail.getExpression();
        }
        return this.path;
    }

    @Override
    public Annotation getAnnotation() {
        return this.label;
    }

    @Override
    public String getOverride() {
        return this.name;
    }

    @Override
    public Contact getContact() {
        return this.detail.getContact();
    }

    @Override
    public Class getType() {
        return this.type;
    }

    @Override
    public boolean isAttribute() {
        return true;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public boolean isData() {
        return false;
    }

    @Override
    public String toString() {
        return this.detail.toString();
    }
}

