/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.ml;

import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;

public class OfflineModel
extends LazyLoad {
    private OfflineModelDesc modelDesc;
    private RestClient client;
    private String project;

    OfflineModel(OfflineModelDesc desc, String project, Odps odps) {
        this.modelDesc = desc;
        this.project = project;
        this.client = odps.getRestClient();
    }

    public String getProject() {
        return this.project;
    }

    public String getName() {
        return this.modelDesc.modelName;
    }

    public String getOwner() {
        if (this.modelDesc.owner == null && this.client != null) {
            this.lazyLoad();
        }
        return this.modelDesc.owner;
    }

    @Override
    public void reload() throws OdpsException {
        String resource = ResourceBuilder.buildOfflineModelResource(this.project, this.modelDesc.modelName);
        this.modelDesc = this.client.request(OfflineModelDesc.class, resource, "GET");
    }

    public String getModel() throws OdpsException {
        String resource = ResourceBuilder.buildOfflineModelResource(this.project, this.modelDesc.modelName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("data", null);
        Response response = this.client.request(resource, "GET", params, null, null, 0L);
        try {
            return new String(response.getBody(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new OdpsException(e.getMessage(), e);
        }
    }

    public Date getCreatedTime() {
        if (this.modelDesc.createdTime == null && this.client != null) {
            this.lazyLoad();
        }
        return this.modelDesc.createdTime;
    }

    public Date getLastModifiedTime() {
        if (this.modelDesc.lastModifiedTime == null && this.client != null) {
            this.lazyLoad();
        }
        return this.modelDesc.lastModifiedTime;
    }

    public String getType() {
        if (this.modelDesc.type == null && this.client != null) {
            this.lazyLoad();
        }
        return this.modelDesc.type;
    }

    @Root(name="OfflineModel", strict=false)
    static class OfflineModelDesc {
        @Element(name="Name", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String modelName;
        @Element(name="Owner", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String owner;
        @Element(name="CreationTime", required=false)
        @Convert(value=SimpleXmlUtils.DateConverter.class)
        Date createdTime;
        @Element(name="LastModifiedTime", required=false)
        @Convert(value=SimpleXmlUtils.DateConverter.class)
        Date lastModifiedTime;
        @Element(name="Type", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String type;

        OfflineModelDesc() {
        }
    }
}

