/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.data;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.DefaultRecordReader;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.SimpleStruct;
import com.aliyun.odps.table.arrow.accessor.ArrowVectorAccessor;
import com.aliyun.odps.table.record.accessor.ArrowToRecordConverter;
import com.aliyun.odps.type.ArrayTypeInfo;
import com.aliyun.odps.type.MapTypeInfo;
import com.aliyun.odps.type.StructTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowReader;

public class ArrowStreamRecordReader
extends DefaultRecordReader {
    private final ArrowReader arrowReader;
    private final Deque<Record> records;
    private List<Column> columns;
    private ZoneId timeZone = ZoneId.of("Asia/Shanghai");
    private DateTimeFormatter timeStampFormat;
    private DateTimeFormatter dateTimeFormat;
    private DateFormat dateFormat;
    private boolean useLegacyOutputFormat = false;

    public ArrowStreamRecordReader(ArrowReader arrowReader, TableSchema tableSchema) {
        this(arrowReader, tableSchema, (Set<String>)null);
    }

    public ArrowStreamRecordReader(ArrowReader arrowReader, TableSchema tableSchema, List<String> columnFilter) {
        this(arrowReader, tableSchema, (Set<String>)(columnFilter == null ? null : new HashSet<String>(columnFilter)));
    }

    public ArrowStreamRecordReader(ArrowReader arrowReader, TableSchema tableSchema, Set<String> columnFilter) {
        super(new ByteArrayInputStream(new byte[0]), null);
        this.arrowReader = arrowReader;
        this.records = new ArrayDeque<Record>();
        this.columns = tableSchema.getColumns();
        this.columns.addAll(tableSchema.getPartitionColumns());
        if (columnFilter != null) {
            this.columns = this.columns.stream().filter(column -> columnFilter.contains(column.getName())).collect(Collectors.toList());
            if (columnFilter.isEmpty()) {
                throw new IllegalArgumentException("zero available columns selected, please check your column filter.");
            }
        }
    }

    public void setTimeZone(ZoneId timeZone) {
        this.timeZone = timeZone;
    }

    public void setUseLegacyOutputFormat(boolean flag) {
        this.useLegacyOutputFormat = flag;
        this.timeStampFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS");
        this.dateTimeFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    }

    @Override
    public Record read() throws IOException {
        if (!this.records.isEmpty()) {
            return this.records.removeFirst();
        }
        if (this.arrowReader != null && this.arrowReader.loadNextBatch()) {
            VectorSchemaRoot vectorSchemaRoot = this.arrowReader.getVectorSchemaRoot();
            if (vectorSchemaRoot.getRowCount() == 0) {
                return null;
            }
            this.convertToRecord(vectorSchemaRoot);
            return this.records.removeFirst();
        }
        return null;
    }

    @Override
    public List<String> readRaw() throws IOException {
        throw new UnsupportedOperationException("arrow reader do not support readRaw(), please use read() instead");
    }

    @Override
    public InputStream getRawStream() {
        throw new UnsupportedOperationException("arrow reader do not support getRawStream(), please use read() instead");
    }

    @Override
    public Column[] getSchema() {
        return this.columns.toArray(new Column[0]);
    }

    private void convertToRecord(VectorSchemaRoot vectorSchemaRoot) throws IOException {
        for (int rowId = 0; rowId < vectorSchemaRoot.getRowCount(); ++rowId) {
            ArrayRecord arrayRecord = new ArrayRecord(this.columns.toArray(new Column[0]));
            for (Column column : this.columns) {
                FieldVector vector = vectorSchemaRoot.getVector(column.getName());
                TypeInfo typeInfo = column.getTypeInfo();
                ArrowVectorAccessor columnVectorAccessor = ArrowToRecordConverter.createColumnVectorAccessor((ValueVector)vector, typeInfo, true);
                Object data = ArrowToRecordConverter.getData(columnVectorAccessor, typeInfo, rowId, true);
                if (typeInfo.getOdpsType() == OdpsType.DATETIME) {
                    Object object = data = data == null ? null : ((ZonedDateTime)data).withZoneSameInstant(this.timeZone);
                }
                if (this.useLegacyOutputFormat) {
                    data = this.transformToLegacyType(data, typeInfo);
                }
                arrayRecord.set(column.getName(), data);
            }
            this.records.addLast((Record)arrayRecord);
        }
    }

    private Object transformToLegacyType(Object data, TypeInfo typeInfo) {
        if (data == null) {
            return data;
        }
        switch (typeInfo.getOdpsType()) {
            case DATE: {
                data = Date.valueOf((LocalDate)data);
                break;
            }
            case DATETIME: {
                data = this.parseDatetime(this.dateTimeFormat.format(((ZonedDateTime)data).withZoneSameInstant(this.timeZone).toLocalDateTime()));
                break;
            }
            case TIMESTAMP: {
                data = this.parseTimestamp(this.timeStampFormat.format(((Instant)data).atZone(ZoneId.systemDefault()).withZoneSameInstant(this.timeZone).toLocalDateTime()));
                break;
            }
            case STRING: {
                if (!(data instanceof byte[])) break;
                data = new String((byte[])data);
                break;
            }
            case ARRAY: {
                TypeInfo elementTypeInfo = ((ArrayTypeInfo)typeInfo).getElementTypeInfo();
                ((ArrayList)data).replaceAll(item -> this.transformToLegacyType(item, elementTypeInfo));
                break;
            }
            case MAP: {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                SimpleStruct newMap = new HashMap();
                ((HashMap)data).forEach((? super K key, ? super V value) -> {
                    key = this.transformToLegacyType(key, mapTypeInfo.getKeyTypeInfo());
                    value = this.transformToLegacyType(value, mapTypeInfo.getValueTypeInfo());
                    newMap.put(key, value);
                });
                data = newMap;
                break;
            }
            case STRUCT: {
                List fieldTypeInfos = ((StructTypeInfo)typeInfo).getFieldTypeInfos();
                ArrayList<Object> fieldValues = new ArrayList<Object>(fieldTypeInfos.size());
                SimpleStruct originStruct = data;
                for (int index = 0; index < fieldTypeInfos.size(); ++index) {
                    fieldValues.add(this.transformToLegacyType(originStruct.getFieldValue(index), (TypeInfo)fieldTypeInfos.get(index)));
                }
                data = new SimpleStruct((StructTypeInfo)typeInfo, fieldValues);
                break;
            }
        }
        return data;
    }

    private java.util.Date parseDatetime(String date) {
        try {
            return this.dateFormat.parse(date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("parse date `" + date + "` error: " + e.getMessage(), e);
        }
    }

    private Timestamp parseTimestamp(String st) {
        String[] splits = st.split("\\.");
        Timestamp timestamp = new Timestamp(this.parseDatetime(splits[0]).getTime());
        if (splits.length == 2 && !splits[1].isEmpty()) {
            String nanoValueStr = splits[1];
            if (nanoValueStr.length() > 9) {
                nanoValueStr = nanoValueStr.substring(0, 9);
            } else if (nanoValueStr.length() < 9) {
                StringBuilder nanoValueStrBuilder = new StringBuilder();
                nanoValueStrBuilder.append(nanoValueStr);
                while (nanoValueStrBuilder.length() < 9) {
                    nanoValueStrBuilder.append("0");
                }
                nanoValueStr = nanoValueStrBuilder.toString();
            }
            timestamp.setNanos(Integer.parseInt(nanoValueStr));
        }
        return timestamp;
    }

    @Override
    public void close() {
        if (this.arrowReader == null) {
            return;
        }
        try {
            this.arrowReader.close();
        }
        catch (IOException e) {
            throw new IllegalStateException("close arrow reader failed, which may cause memory leak");
        }
    }
}

