/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.commons;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.utils.StringUtils;
import java.net.URI;
import java.net.URISyntaxException;

public class GeneralConfiguration {
    public static int DEFAULT_CHUNK_SIZE = 1496;
    public static int DEFAULT_SOCKET_CONNECT_TIMEOUT = 180;
    public static int DEFAULT_SOCKET_TIMEOUT = 300;
    public static int DEFAULT_SOCKET_RETRY_TIMES = 4;
    protected Odps odps;
    private int chunkSize = DEFAULT_CHUNK_SIZE;
    private int socketConnectTimeout = DEFAULT_SOCKET_CONNECT_TIMEOUT;
    private int socketTimeout = DEFAULT_SOCKET_TIMEOUT;
    private int socketRetryTimes = DEFAULT_SOCKET_RETRY_TIMES;
    protected URI endpoint;

    public GeneralConfiguration(Odps odps) {
        this.odps = odps;
    }

    public Account getAccount() {
        return this.odps.getAccount();
    }

    public URI getEndpoint(String projectName) throws OdpsException {
        if (this.endpoint != null) {
            return this.endpoint;
        }
        throw new OdpsException("Endpoint not set yet\uff01");
    }

    public void setEndpoint(URI endpoint) {
        if (endpoint == null) {
            throw new IllegalArgumentException("Missing endpoint.");
        }
        this.endpoint = endpoint;
    }

    public URI getURI(String projectName, String tableName) throws OdpsException {
        StringBuilder sb = new StringBuilder();
        String e = this.getEndpoint(projectName).toString();
        sb.append(e);
        if (!e.endsWith("/")) {
            sb.append("/");
        }
        sb.append("projects/");
        sb.append(projectName);
        sb.append("/tables/").append(tableName);
        try {
            return new URI(sb.toString());
        }
        catch (URISyntaxException e1) {
            throw new RuntimeException(e1);
        }
    }

    public String getResource(String projectName, String tableName) {
        return ResourceBuilder.buildTableResource(projectName, tableName);
    }

    public String getResource(String projectName, String schemaName, String tableName) {
        if (!StringUtils.isNullOrEmpty((String)schemaName)) {
            return ResourceBuilder.buildTableResource(projectName, schemaName, tableName);
        }
        return this.getResource(projectName, tableName);
    }

    public String getStreamUploadResource(String projectName, String tableName, long shardId) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getResource(projectName, tableName)).append("/shards/").append(Long.toString(shardId));
        return sb.toString();
    }

    public String getStreamUploadResource(String projectName, String tableName) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getResource(projectName, tableName)).append("/shards");
        return sb.toString();
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public int getSocketConnectTimeout() {
        return this.socketConnectTimeout;
    }

    public void setSocketConnectTimeout(int timeout) {
        this.socketConnectTimeout = timeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int timeout) {
        this.socketTimeout = timeout;
    }

    public int getSocketRetryTimes() {
        return this.socketRetryTimes;
    }

    public void setSocketRetryTimes(int retryTimes) {
        this.socketRetryTimes = retryTimes;
    }

    public String getUserAgent() {
        return this.odps.getUserAgent();
    }
}

