/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.Map;

public class TableLifecycleConfig {
    private Map<String, String> tierToLowFrequency;
    private Map<String, String> tierToLongterm;

    public Map<String, String> getTierToLowFrequency() {
        return this.tierToLowFrequency;
    }

    public Map<String, String> getTierToLongTerm() {
        return this.tierToLongterm;
    }

    public static TableLifecycleConfig parse(String jsonStr) {
        JsonObject jsonObject = new JsonParser().parse(jsonStr).getAsJsonObject();
        return TableLifecycleConfig.parse(jsonObject);
    }

    public static TableLifecycleConfig parse(JsonObject jsonObject) {
        if (jsonObject == null || !jsonObject.has("LifecycleConfig")) {
            return null;
        }
        TableLifecycleConfig tableLifecycleConfig = new TableLifecycleConfig();
        String lifecycleConfigJson = jsonObject.get("LifecycleConfig").getAsString();
        JsonObject lifecycleConfig = new JsonParser().parse(lifecycleConfigJson).getAsJsonObject();
        if (lifecycleConfig.has("TierToLowFrequency")) {
            JsonObject tierToLowFrequency = lifecycleConfig.getAsJsonObject("TierToLowFrequency");
            tableLifecycleConfig.tierToLowFrequency = TableLifecycleConfig.parseTableLifecycleConfigItem(tierToLowFrequency);
        }
        if (lifecycleConfig.has("TierToLongterm")) {
            JsonObject tierToLongTerm = lifecycleConfig.getAsJsonObject("TierToLongterm");
            tableLifecycleConfig.tierToLongterm = TableLifecycleConfig.parseTableLifecycleConfigItem(tierToLongTerm);
        }
        return tableLifecycleConfig;
    }

    private static Map<String, String> parseTableLifecycleConfigItem(JsonObject jsonObject) {
        HashMap<String, String> tableLifecycleConfigItem = new HashMap<String, String>();
        if (jsonObject == null) {
            return tableLifecycleConfigItem;
        }
        for (TableLifecycleConfigItemEnum item : TableLifecycleConfigItemEnum.values()) {
            if (!jsonObject.has(item.getName())) continue;
            tableLifecycleConfigItem.put(item.getName(), jsonObject.get(item.getName()).getAsString());
        }
        return tableLifecycleConfigItem;
    }

    public static enum TableLifecycleConfigItemEnum {
        DaysAfterLastModificationGreaterThan("DaysAfterLastModificationGreaterThan"),
        DaysAfterLastAccessGreaterThan("DaysAfterLastAccessGreaterThan"),
        DaysAfterLastTierModificationGreaterThan("DaysAfterLastTierModificationGreaterThan");

        private final String name;

        private TableLifecycleConfigItemEnum(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static TableLifecycleConfigItemEnum getByName(String name) {
            for (TableLifecycleConfigItemEnum item : TableLifecycleConfigItemEnum.values()) {
                if (!item.getName().equals(name)) continue;
                return item;
            }
            return null;
        }
    }
}

