/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Project;
import com.aliyun.odps.utils.StringUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class CreateProjectParam {
    private Project.ProjectModel projectModel = new Project.ProjectModel();

    public CreateProjectParam name(String name) {
        if (StringUtils.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("Project name is required.");
        }
        this.projectModel.name = name;
        return this;
    }

    public CreateProjectParam owner(String owner) {
        if (StringUtils.isNullOrEmpty((String)owner)) {
            throw new IllegalArgumentException("Project owner is required.");
        }
        this.projectModel.owner = owner;
        return this;
    }

    public CreateProjectParam comment(String comment) {
        this.projectModel.comment = comment;
        return this;
    }

    public CreateProjectParam superAdmin(String superAdministrator) {
        this.projectModel.superAdministrator = superAdministrator;
        return this;
    }

    public CreateProjectParam properties(Map<String, String> properties) {
        if (Objects.isNull(this.projectModel.properties)) {
            this.projectModel.properties = new LinkedHashMap();
        }
        this.projectModel.properties.putAll(properties);
        return this;
    }

    public CreateProjectParam appendProperty(String key, String value) {
        if (Objects.isNull(this.projectModel.properties)) {
            this.projectModel.properties = new LinkedHashMap();
        }
        this.projectModel.properties.put(key, value);
        return this;
    }

    public CreateProjectParam defaultCluster(String clusterName) {
        if (StringUtils.isNullOrEmpty((String)clusterName)) {
            throw new IllegalArgumentException("Project default cluster is required.");
        }
        this.projectModel.defaultCluster = clusterName;
        return this;
    }

    public CreateProjectParam defaultQuotaId(String quotaId) {
        this.projectModel.defaultQuotaID = quotaId;
        return this;
    }

    public CreateProjectParam groupName(String groupName) {
        this.projectModel.projectGroupName = groupName;
        return this;
    }

    public CreateProjectParam defaultCtrlService(String defaultCtrlService) {
        this.projectModel.defaultCtrlService = defaultCtrlService;
        return this;
    }

    Project.ProjectModel getProjectModel() {
        return this.projectModel;
    }
}

