/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.utils;

public class UTF8ByteArrayUtils {
    public static int findByte(byte[] utf, int start, int end, byte b) {
        for (int i = start; i < end; ++i) {
            if (utf[i] != b) continue;
            return i;
        }
        return -1;
    }

    public static int findBytes(byte[] utf, int start, int end, byte[] b) {
        int matchEnd = end - b.length;
        for (int i = start; i <= matchEnd; ++i) {
            boolean matched = true;
            for (int j = 0; j < b.length; ++j) {
                if (utf[i + j] == b[j]) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            return i;
        }
        return -1;
    }

    public static int findNthByte(byte[] utf, int start, int length, byte b, int n) {
        int pos = -1;
        int nextStart = start;
        for (int i = 0; i < n; ++i) {
            pos = UTF8ByteArrayUtils.findByte(utf, nextStart, length, b);
            if (pos < 0) {
                return pos;
            }
            nextStart = pos + 1;
        }
        return pos;
    }

    public static int findNthByte(byte[] utf, byte b, int n) {
        return UTF8ByteArrayUtils.findNthByte(utf, 0, utf.length, b, n);
    }

    public static String unescapeSeparator(String separator) {
        StringBuilder sb = new StringBuilder();
        UnescapeState state = UnescapeState.NORMAL;
        int num = 0;
        for (char c : separator.toCharArray()) {
            switch (state) {
                case NORMAL: {
                    if (c == '\\') {
                        state = UnescapeState.START_ESCAPE;
                        break;
                    }
                    sb.append(c);
                    break;
                }
                case START_ESCAPE: {
                    if (c == 't') {
                        sb.append('\t');
                        state = UnescapeState.NORMAL;
                        break;
                    }
                    if (c == '\\') {
                        sb.append('\\');
                        state = UnescapeState.NORMAL;
                        break;
                    }
                    if (c >= '0' && c <= '7') {
                        num = c - 48;
                        state = UnescapeState.ESCAPE_N;
                        break;
                    }
                    state = UnescapeState.INVALID;
                    break;
                }
                case ESCAPE_N: {
                    if (c >= '0' && c <= '7') {
                        num = num * 8 + (c - 48);
                        state = UnescapeState.ESCAPE_NN;
                        break;
                    }
                    state = UnescapeState.INVALID;
                    break;
                }
                case ESCAPE_NN: {
                    if (c >= '0' && c <= '7') {
                        if ((num = num * 8 + (c - 48)) > 127) {
                            state = UnescapeState.INVALID;
                            break;
                        }
                        sb.append((char)num);
                        state = UnescapeState.NORMAL;
                        break;
                    }
                    state = UnescapeState.INVALID;
                    break;
                }
                default: {
                    throw new IllegalStateException("Not handled unescaping state:" + (Object)((Object)state));
                }
            }
            if (state.equals((Object)UnescapeState.INVALID)) break;
        }
        if (!state.equals((Object)UnescapeState.NORMAL)) {
            throw new IllegalArgumentException("Invalid escaping in separator:'" + separator + "'");
        }
        return sb.toString();
    }

    private static enum UnescapeState {
        NORMAL,
        START_ESCAPE,
        ESCAPE_N,
        ESCAPE_NN,
        INVALID;

    }
}

