/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.utils;

import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.data.VolumeInfo;
import com.aliyun.odps.mapred.conf.JobConf;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Arrays;

public class OutputUtils {
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    private static final String OUTPUT_DESC = "odps.mapred.output.desc";
    private static final String VOLUME_OUTPUT_DESC = "odps.mapred.volume.output.desc";

    public static void addTable(TableInfo table, JobConf conf) {
        TableInfo[] tableInfos = OutputUtils.getTables(conf);
        tableInfos = tableInfos == null ? new TableInfo[1] : Arrays.copyOf(tableInfos, tableInfos.length + 1);
        tableInfos[tableInfos.length - 1] = table;
        conf.set(OUTPUT_DESC, gson.toJson((Object)tableInfos));
    }

    public static TableInfo[] getTables(JobConf conf) {
        String inputDesc = conf.get(OUTPUT_DESC);
        if (inputDesc != null && !inputDesc.isEmpty()) {
            return (TableInfo[])gson.fromJson(inputDesc, TableInfo[].class);
        }
        return null;
    }

    public static void setTables(TableInfo[] tables, JobConf conf) {
        if (tables != null && tables.length > 0) {
            conf.set(OUTPUT_DESC, gson.toJson((Object)tables));
        } else {
            conf.set(OUTPUT_DESC, "");
        }
    }

    public static void addVolume(VolumeInfo volume, JobConf conf) {
        VolumeInfo[] volumeInfos = OutputUtils.getVolumes(conf);
        volumeInfos = volumeInfos == null ? new VolumeInfo[1] : Arrays.copyOf(volumeInfos, volumeInfos.length + 1);
        volumeInfos[volumeInfos.length - 1] = volume;
        conf.set(VOLUME_OUTPUT_DESC, gson.toJson((Object)volumeInfos));
    }

    public static void setVolumes(VolumeInfo[] volumes, JobConf conf) {
        if (volumes != null && volumes.length > 0) {
            conf.set(VOLUME_OUTPUT_DESC, gson.toJson((Object)volumes));
        } else {
            conf.set(VOLUME_OUTPUT_DESC, "");
        }
    }

    public static VolumeInfo[] getVolumes(JobConf conf) {
        String volumeOutputDesc = conf.get(VOLUME_OUTPUT_DESC);
        if (volumeOutputDesc != null && !volumeOutputDesc.isEmpty()) {
            return (VolumeInfo[])gson.fromJson(volumeOutputDesc, VolumeInfo[].class);
        }
        return null;
    }
}

