/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.conf;

import com.aliyun.odps.Column;
import com.aliyun.odps.Survey;
import com.aliyun.odps.conf.Configuration;
import com.aliyun.odps.data.RecordComparator;
import com.aliyun.odps.mapred.Mapper;
import com.aliyun.odps.mapred.MapperBase;
import com.aliyun.odps.mapred.Partitioner;
import com.aliyun.odps.mapred.Reducer;
import com.aliyun.odps.mapred.ReducerBase;
import com.aliyun.odps.mapred.conf.SessionState;
import com.aliyun.odps.mapred.utils.SchemaUtils;
import com.aliyun.odps.utils.StringUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobConf
extends Configuration {
    private static final Log LOG = LogFactory.getLog(JobConf.class);

    public JobConf() {
        super((Configuration)SessionState.get().getDefaultJob());
    }

    public JobConf(Configuration conf) {
        super((Configuration)SessionState.get().getDefaultJob());
        this.mergeConfiguration(conf);
    }

    @Survey
    public JobConf(String config) {
        this();
        this.addResource(config);
    }

    public JobConf(boolean loadSessionContext) {
        if (loadSessionContext) {
            this.mergeConfiguration(SessionState.get().getDefaultJob());
        }
    }

    private void mergeConfiguration(Configuration conf) {
        for (Map.Entry entry : conf) {
            this.set((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public void setResources(String resourceNames) {
        this.set("odps.mapred.resources", resourceNames);
    }

    public String[] getResources() {
        return this.getStrings("odps.mapred.resources");
    }

    public Column[] getMapOutputKeySchema() {
        String rs = this.get("odps.mapred.mapoutput.key.schema");
        return SchemaUtils.fromString(rs);
    }

    public Column[] getMapOutputKeySchema4Pileline(int nodeId) {
        String rs = this.get(String.format("odps.pipeline.%d.output.key.schema", nodeId));
        return SchemaUtils.fromString(rs);
    }

    public Column[] getMapOutputValueSchema4Pileline(int nodeId) {
        String rs = this.get(String.format("odps.pipeline.%d.output.value.schema", nodeId));
        return SchemaUtils.fromString(rs);
    }

    public String getStreamProcessor(String taskType) {
        return this.get(String.format("stream.%s.streamprocessor", taskType));
    }

    public String getPartitioner(int nodeId) {
        return this.get(String.format("odps.pipeline.%s.partition.class", nodeId));
    }

    public boolean isStreamJob() {
        return this.get("stream.addenvironment") != null;
    }

    public boolean isPipeline() {
        return this.get("odps.pipeline.list") != null;
    }

    public void setFunctionResources(String resourceNames) {
        this.set("odps.mapred.function.resources", resourceNames);
    }

    public String[] getFunctionResources() {
        return this.getStrings("odps.mapred.function.resources");
    }

    public void setFunctionCreateText(String text) {
        this.set("odps.mapred.function.create.text", text);
    }

    public String getFunctionCreateText() {
        return this.get("odps.mapred.function.create.text");
    }

    public void setFunctionDropText(String text) {
        this.set("odps.mapred.function.drop.text", text);
    }

    public String getFunctionDropText() {
        return this.get("odps.mapred.function.drop.text");
    }

    public void setMapOutputKeySchema(Column[] schema) {
        this.set("odps.mapred.mapoutput.key.schema", SchemaUtils.toString(schema));
    }

    public Column[] getMapOutputValueSchema() {
        String rs = this.get("odps.mapred.mapoutput.value.schema");
        return SchemaUtils.fromString(rs);
    }

    public void setMapOutputValueSchema(Column[] schema) {
        this.set("odps.mapred.mapoutput.value.schema", SchemaUtils.toString(schema));
    }

    public String[] getOutputKeySortColumns() {
        String joined = this.get("odps.mapred.output.key.sort.columns", null);
        if (joined == null || joined.isEmpty()) {
            return SchemaUtils.getNames(this.getMapOutputKeySchema());
        }
        return joined.split(",");
    }

    public void setOutputKeySortColumns(String[] cols) {
        this.set("odps.mapred.output.key.sort.columns", StringUtils.join((Object[])cols, (String)","));
    }

    public SortOrder[] getOutputKeySortOrder() {
        SortOrder[] order;
        String joined = this.get("odps.mapred.output.key.sort.order", null);
        if (joined == null || joined.isEmpty()) {
            order = new SortOrder[this.getOutputKeySortColumns().length];
            Arrays.fill((Object[])order, (Object)SortOrder.ASC);
        } else {
            String[] orders = joined.split(",");
            order = new SortOrder[orders.length];
            for (int i = 0; i < order.length; ++i) {
                order[i] = SortOrder.valueOf(orders[i]);
            }
        }
        return order;
    }

    public void setOutputKeySortOrder(SortOrder[] order) {
        this.set("odps.mapred.output.key.sort.order", StringUtils.join((Object[])order, (String)","));
    }

    public String[] getOutputGroupingColumns() {
        String joined = this.get("odps.mapred.output.group.columns", null);
        if (joined != null) {
            return joined.split(",");
        }
        return SchemaUtils.getNames(this.getMapOutputKeySchema());
    }

    public void setOutputGroupingColumns(String[] cols) {
        this.set("odps.mapred.output.group.columns", StringUtils.join((Object[])cols, (String)","));
    }

    public Class<? extends RecordComparator> getOutputKeyComparatorClass() {
        return this.getClass("odps.stage.mapred.output.key.comparator.class", null, RecordComparator.class);
    }

    public void setOutputKeyComparatorClass(Class<? extends RecordComparator> theClass) {
        this.setClass("odps.stage.mapred.output.key.comparator.class", theClass, RecordComparator.class);
    }

    public Class<? extends RecordComparator> getOutputKeyGroupingComparatorClass() {
        return this.getClass("odps.mapred.output.key.grouping.comparator.class", null, RecordComparator.class);
    }

    public void setOutputKeyGroupingComparatorClass(Class<? extends RecordComparator> theClass) {
        this.setClass("odps.mapred.output.key.grouping.comparator.class", theClass, RecordComparator.class);
    }

    public Class<? extends Mapper> getMapperClass() {
        return this.getClass("odps.mapred.map.class", MapperBase.class, Mapper.class);
    }

    public void setMapperClass(Class<? extends Mapper> theClass) {
        this.setClass("odps.mapred.map.class", theClass, Mapper.class);
    }

    public String[] getPartitionColumns() {
        String joined = this.get("odps.mapred.partition.columns", null);
        if (joined != null) {
            return joined.split(",");
        }
        return SchemaUtils.getNames(this.getMapOutputKeySchema());
    }

    public void setPartitionColumns(String[] cols) {
        this.set("odps.mapred.partition.columns", StringUtils.join((Object[])cols, (String)","));
    }

    public Class<? extends Reducer> getReducerClass() {
        return this.getClass("odps.mapred.reduce.class", ReducerBase.class, Reducer.class);
    }

    public void setReducerClass(Class<? extends Reducer> theClass) {
        this.setClass("odps.mapred.reduce.class", theClass, Reducer.class);
    }

    public Class<? extends Reducer> getCombinerClass() {
        return this.getClass("odps.mapred.combine.class", null, Reducer.class);
    }

    public void setCombinerClass(Class<? extends Reducer> theClass) {
        this.setClass("odps.mapred.combine.class", theClass, Reducer.class);
    }

    public Class<? extends Partitioner> getPartitionerClass() {
        return this.getClass("odps.mapred.partition.class", null, Partitioner.class);
    }

    public void setPartitionerClass(Class<? extends Partitioner> theClass) {
        this.setClass("odps.mapred.partition.class", theClass, Partitioner.class);
    }

    public long getSplitSize() {
        return this.getLong("odps.stage.mapper.split.size", 256L);
    }

    public void setSplitSize(long size) {
        this.setLong("odps.stage.mapper.split.size", size);
    }

    public int getNumMapTasks() {
        return this.getInt("odps.stage.mapper.num", 1);
    }

    public void setNumMapTasks(int n) {
        this.setInt("odps.stage.mapper.num", n);
        this.setBoolean("odps.optimizer.cbo.enable.dynamic.parallelism", false);
    }

    public int getNumReduceTasks() {
        return this.getInt("odps.stage.reducer.num", 1);
    }

    public void setNumReduceTasks(int n) {
        this.setInt("odps.stage.reducer.num", n);
        this.setInt("odps.sql.reducer.instances", n);
        this.setBoolean("odps.optimizer.cbo.enable.dynamic.parallelism", false);
    }

    public int getMemoryForMapTask() {
        return this.getInt("odps.stage.mapper.mem", 2048);
    }

    public void setMemoryForMapTask(int mem) {
        this.setInt("odps.stage.mapper.mem", mem);
    }

    public int getMemoryForReduceTask() {
        return this.getInt("odps.stage.reducer.mem", 2048);
    }

    public void setMemoryForReduceTask(int mem) {
        this.setInt("odps.stage.reducer.mem", mem);
    }

    public int getMemoryForMapperJVM() {
        return this.getInt("odps.stage.mapper.jvm.mem", 1024);
    }

    public void setMemoryForMapperJVM(int mem) {
        this.setInt("odps.stage.mapper.jvm.mem", mem);
    }

    public int getMemoryForReducerJVM() {
        return this.getInt("odps.stage.reducer.jvm.mem", 1024);
    }

    public void setMemoryForReducerJVM(int mem) {
        this.setInt("odps.stage.reducer.jvm.mem", mem);
    }

    public int getMemoryForJVM() {
        return this.getInt("odps.stage.jvm.mem", 1024);
    }

    public void setMemoryForJVM(int mem) {
        this.setInt("odps.stage.jvm.mem", mem);
    }

    public int getCombinerCacheItems() {
        return this.getInt("odps.mapred.combiner.cache.items", 1024);
    }

    public void setCombinerCacheItems(int size) {
        this.setInt("odps.mapred.combiner.cache.items", size);
    }

    public float getCombinerCacheSpillPercent() {
        return this.getFloat("odps.mapred.combiner.cache.spill.percent", 0.5f);
    }

    public void setCombinerCacheSpillPercent(float percent) {
        this.setFloat("odps.mapred.combiner.cache.spill.percent", percent);
    }

    public boolean getCombinerOptimizeEnable() {
        return this.getBoolean("odps.mapred.combiner.optimize.enable", false);
    }

    public void setCombinerOptimizeEnable(boolean isCombineOpt) {
        this.setBoolean("odps.mapred.combiner.optimize.enable", isCombineOpt);
    }

    public int getFunctionTimeout() {
        return this.getInt("odps.function.timeout", 600);
    }

    public void setFunctionTimeout(int timeout) {
        this.setInt("odps.function.timeout", timeout);
    }

    public int getInstancePriority() {
        return this.getInt("odps.instance.priority", 9);
    }

    public boolean getOutputOverwrite() {
        return this.getBoolean("odps.mapred.output.overwrite", true);
    }

    public void setOutputOverwrite(boolean isOverwrite) {
        this.setBoolean("odps.mapred.output.overwrite", isOverwrite);
    }

    public boolean getInnerOutputEnable() {
        return this.getBoolean("odps.mapred.inner.output.enable", false);
    }

    public void setInnerOutputEnable(boolean isInnerOutput) {
        this.setBoolean("odps.mapred.inner.output.enable", isInnerOutput);
    }

    public void setInstancePriority(int priority) {
        this.setInt("odps.instance.priority", priority);
    }

    @Deprecated
    public Column[] getOutputSchema() {
        try {
            this.onDeprecated(JobConf.class.getMethod("getOutputSchema", new Class[0]));
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Deprecated
    public Column[] getOutputSchema(String label) {
        try {
            this.onDeprecated(JobConf.class.getMethod("getOutputSchema", String.class));
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Deprecated
    public void setOutputSchema(Column[] schema, String label) {
        try {
            this.onDeprecated(JobConf.class.getMethod("setOutputSchema", Column[].class, String.class));
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    private void onDeprecated(Method method) {
        this.set("odps.deprecated." + method.getDeclaringClass().getCanonicalName() + "." + method.getName(), "true");
        LOG.warn((Object)("Calling deprecated method:" + method));
    }

    public static enum SortOrder {
        ASC,
        DESC;

    }
}

